/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.insight.xml.schema.scanning;

import com.tssap.tools.insight.exceptions.NoMoreElementsException;
import com.tssap.tools.insight.xml.schema.scanning.IgnoreComments;
import com.tssap.tools.insight.xml.schema.scanning.InvalidDocumentStateException;
import com.tssap.tools.insight.xml.schema.scanning.NoCorrespondingTagException;
import com.tssap.util.xml.schema.model.elements.XmlStringHelper;
import java.util.Enumeration;

abstract class XmlTokenizer
implements Enumeration {
    private int currentPosition;
    private String xmlString;
    private boolean hasMoreElementsFlag = true;
    public static final char TAGSTARTCHAR = '<';
    public static final char TAGENDCHAR = '>';
    protected String fileNodeType = null;
    protected IgnoreComments ignoreJavaCode;

    protected int lookForTagNameAndWhiteSpace(String tagName, boolean firstOccurenceDesired) {
        return this.lookForTagNameAndWhiteSpace(tagName, firstOccurenceDesired, this.getXmlString());
    }

    private int lookForTagNameAndWhiteSpace(String tagName, boolean firstOccurenceDesired, String currentString) {
        int pos = firstOccurenceDesired ? currentString.indexOf('<' + tagName) : currentString.lastIndexOf('<' + tagName);
        if (pos == -1) {
            return -1;
        }
        int whiteSpacePos = pos + tagName.length() + 1;
        if (XmlStringHelper.isWhiteSpace((char)currentString.charAt(whiteSpacePos))) {
            return pos;
        }
        if (firstOccurenceDesired) {
            int newPos = this.lookForTagNameAndWhiteSpace(tagName, firstOccurenceDesired, currentString.substring(whiteSpacePos));
            if (newPos > -1) {
                return whiteSpacePos + newPos;
            }
            return -1;
        }
        return this.lookForTagNameAndWhiteSpace(tagName, firstOccurenceDesired, currentString.substring(0, pos));
    }

    public XmlTokenizer(String xmlString) {
        this.xmlString = xmlString;
    }

    public String getXmlString() {
        return this.xmlString;
    }

    public Object nextElement() throws InvalidDocumentStateException {
        return this.nextTag();
    }

    public void setFileNodeType(String fileNodeType) {
        this.fileNodeType = fileNodeType;
    }

    protected void setXmlString(String str) {
        this.xmlString = str;
    }

    protected boolean isHasMoreElementsFlagSet() {
        return this.hasMoreElementsFlag;
    }

    protected void setHasMoreElementsFlag(boolean b) {
        this.hasMoreElementsFlag = b;
    }

    protected int getCurrentPosition() {
        return this.currentPosition;
    }

    protected void setCurrentPosition(int pos) {
        this.currentPosition = pos;
    }

    public abstract boolean hasMoreElements();

    protected abstract String nextCorrespondingElement(String var1) throws NoCorrespondingTagException;

    protected abstract String nextTag() throws InvalidDocumentStateException, NoMoreElementsException;
}

