/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.insight.xml.schema.scanning;

import com.tssap.tools.insight.exceptions.InvalidPositionForTargetException;
import com.tssap.tools.insight.exceptions.NoMoreElementsException;
import com.tssap.tools.insight.interfaces.ContextGetterI;
import com.tssap.tools.insight.interfaces.SearchContextI;
import com.tssap.tools.insight.interfaces.SearchTargetGetterI;
import com.tssap.tools.insight.xml.schema.interfaceimpl.XmlContext;
import com.tssap.tools.insight.xml.schema.scanning.ForwardXmlTokenizer;
import com.tssap.tools.insight.xml.schema.scanning.IgnorableTagList;
import com.tssap.tools.insight.xml.schema.scanning.InvalidAttributePositionException;
import com.tssap.tools.insight.xml.schema.scanning.InvalidDocumentStateException;
import com.tssap.tools.insight.xml.schema.scanning.InvalidTagPositionException;
import com.tssap.tools.insight.xml.schema.scanning.NoCorrespondingTagException;
import com.tssap.tools.insight.xml.schema.scanning.ReverseXmlTokenizer;
import com.tssap.tools.insight.xml.schema.scanning.ScannedAttributeString;
import com.tssap.tools.insight.xml.schema.scanning.XmlStringConverter;
import com.tssap.tools.insight.xml.schema.scanning.XmlTokenizer;
import com.tssap.util.insight.interfaces.MultipleContextDirectionsI;
import com.tssap.util.insight.interfaces.SearchTargetI;
import com.tssap.util.xml.schema.model.elements.InputWord;
import com.tssap.util.xml.schema.model.elements.ScannedTag;
import com.tssap.util.xml.schema.model.elements.XmlStringHelper;
import com.tssap.util.xml.schema.model.interfaceimpl.XmlTarget;
import com.tssap.util.xml.schema.model.util.Helper;

public class TagHistoryScanner
implements ContextGetterI,
SearchTargetGetterI {
    private String editorText = "";
    private int editorCaretPosition;
    private String fileType;
    private String partialReverseText;
    private String partialForwardText;
    private String startedReverseTag = null;
    private String startedForwardTag = null;
    private String untrimmedStartedForwardTag = null;
    private ForwardXmlTokenizer forwardTokenizer;
    private ReverseXmlTokenizer reverseTokenizer;
    private boolean scanningDirection;
    private boolean insideTagStructure = false;
    private boolean insideIncompleteTag = false;
    private boolean attributesAllowed = false;
    private boolean overTagName = false;
    private ScannedTag containingTag = null;
    private InputWord forwardInputWord = new InputWord();
    private InputWord reverseInputWord = new InputWord();

    public SearchTargetI findSearchTarget(SearchTargetI oldTarget) {
        if (this.isValueInsightAllowed()) {
            ((XmlTarget)oldTarget).setTarget("value");
            ((XmlTarget)oldTarget).setCalledByKeyStroke(false);
            return oldTarget;
        }
        if (this.isAttributeInsightPosValid()) {
            ((XmlTarget)oldTarget).setTarget("mandatoryAttribute");
            ((XmlTarget)oldTarget).setCalledByKeyStroke(true);
            return oldTarget;
        }
        if (this.isTagInsightPosValid(true)) {
            ((XmlTarget)oldTarget).setTarget("tag");
            ((XmlTarget)oldTarget).setCalledByKeyStroke(true);
            return oldTarget;
        }
        return null;
    }

    public SearchContextI investigateContext(SearchTargetI target, MultipleContextDirectionsI direction, SearchContextI oldContext) throws InvalidPositionForTargetException {
        this.fileType = ((XmlTarget)target).getFileNodeType();
        if (target.getTarget().equals("tag")) {
            return this.getTagContext(((XmlTarget)target).isCallDoneByKestroke(), direction.getContextDirection());
        }
        if (target.getTarget().equals("attribute") || target.getTarget().equals("mandatoryAttribute")) {
            return this.getAttributeContext(((XmlTarget)target).isCallDoneByKestroke());
        }
        if (target.getTarget().equals("value")) {
            return this.getValueContext();
        }
        return null;
    }

    private InputWord getReverseInputWord(boolean calledByKeyStroke) throws InvalidTagPositionException, NoCorrespondingTagException, InvalidDocumentStateException {
        this.scanningDirection = false;
        try {
            this.scanTagHistory(calledByKeyStroke);
        }
        catch (NoMoreElementsException ex) {
            if (this.reverseInputWord.size() > 0) {
                throw new NoMoreElementsException();
            }
            throw new NoMoreElementsException();
        }
        catch (NoCorrespondingTagException ex) {
            this.reverseInputWord.print();
            throw ex;
        }
        return this.reverseInputWord;
    }

    private SearchContextI getValueContext() throws InvalidPositionForTargetException {
        XmlContext context = new XmlContext();
        if (this.isValueInsightAllowed()) {
            context.setAttributeName(this.getAttributeNameForValue());
            context.setTagName(this.containingTag.getUnQualifiedName());
            context.setStartString(this.getReverseValueString());
            context.setEndString(this.getForwardValueString());
            try {
                context.setInputWord(this.getReverseInputWordForAttributeInisght());
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            return context;
        }
        throw new InvalidPositionForTargetException();
    }

    private SearchContextI getAttributeContext(boolean calledByKeystroke) throws InvalidPositionForTargetException {
        XmlContext context = new XmlContext();
        this.getAttributeNameForValue();
        if (this.isAttributeInsightPosValid()) {
            try {
                context.setCurrentContainintAttribute(this.createCurrentContainingAttribute());
                if (calledByKeystroke) {
                    this.analyseCurrentAttributeString(this.createCurrentContainingAttribute(), context);
                }
                context.setContainingTag(this.containingTag);
                context.setInputWord(this.getReverseInputWordForAttributeInisght());
                return context;
            }
            catch (InvalidAttributePositionException e) {
                throw new InvalidPositionForTargetException();
            }
            catch (NoCorrespondingTagException e) {
                System.out.println("No corresponding tag, document invalid!");
                return null;
            }
        }
        throw new InvalidPositionForTargetException();
    }

    private SearchContextI getTagContext(boolean calledByKeystroke, String direction) throws InvalidPositionForTargetException {
        if (this.isTagInsightPosValid(calledByKeystroke)) {
            XmlContext context = new XmlContext();
            if (calledByKeystroke) {
                context.setStartString(this.getStartedReverseTag());
                context.setEndString(this.getStartedForwardTag());
            } else {
                context.setStartString("<");
            }
            try {
                if (direction.equals("backward")) {
                    context.setInputWord(this.getReverseInputWord(calledByKeystroke));
                } else {
                    context.setInputWord(this.getForwardInputWord(calledByKeystroke));
                }
            }
            catch (InvalidTagPositionException e) {
                System.out.println("Invalid tag position!");
                throw new InvalidPositionForTargetException();
            }
            catch (NoCorrespondingTagException e) {
                System.out.println("No corresponding tag found, document invalid!");
                return null;
            }
            catch (NoMoreElementsException e) {
                context.setInputWord(new InputWord());
                return context;
            }
            return context;
        }
        throw new InvalidPositionForTargetException();
    }

    private void analyseCurrentAttributeString(ScannedAttributeString currentAttString, XmlContext context) {
        boolean validRestFlag = false;
        if (currentAttString != null) {
            if (currentAttString.getAttributeStart() != null) {
                context.setStartString(currentAttString.getAttributeStart());
            }
            if (currentAttString.getAttributeEnd() != null) {
                context.setEndString(currentAttString.getAttributeEnd());
            }
        }
        validRestFlag = currentAttString != null && currentAttString.getRestString() != null && currentAttString.getRestString().startsWith("=");
        context.setValidAttributeEnd(validRestFlag);
    }

    private InputWord getReverseInputWordForAttributeInisght() throws NoCorrespondingTagException, InvalidAttributePositionException {
        boolean addContainingTag = false;
        if (this.reverseInputWord.isEmpty()) {
            addContainingTag = true;
        }
        try {
            this.createInputWord();
        }
        catch (NoMoreElementsException e) {
            this.reverseInputWord = new InputWord();
        }
        if (this.isAttributeInsightPosValid() || this.isValueInsightAllowed()) {
            if (this.containingTag == null) {
                throw new InvalidAttributePositionException();
            }
            if (addContainingTag) {
                if (this.containingTag.isEmptyTag()) {
                    this.reverseInputWord.add(new ScannedTag(this.containingTag.getQualifiedName(), false, false, false));
                    this.reverseInputWord.add(new ScannedTag(this.containingTag.getQualifiedName(), true, false, false));
                } else {
                    this.reverseInputWord.add(this.containingTag);
                }
            }
            return this.reverseInputWord;
        }
        throw new InvalidAttributePositionException();
    }

    private InputWord getForwardInputWord(boolean calledByKeyStroke) throws InvalidTagPositionException, NoCorrespondingTagException, InvalidDocumentStateException {
        this.scanningDirection = true;
        this.scanTagHistory(calledByKeyStroke);
        InputWord resultWord = new InputWord();
        int i = 0;
        while (i < this.forwardInputWord.size()) {
            resultWord.add(0, this.forwardInputWord.elementAt(i));
            ++i;
        }
        return resultWord;
    }

    private String getStartedReverseTag() {
        if (this.startedReverseTag == null) {
            return "";
        }
        return this.startedReverseTag;
    }

    private String getStartedForwardTag() {
        if (this.startedForwardTag == null) {
            return "";
        }
        return this.startedForwardTag;
    }

    private ScannedTag createScannedTagFromString(String tagString) {
        ScannedTag st = this.identifyEmptyTag(tagString) ? new ScannedTag(tagString, true, true, true) : (!this.identifyClosedTag(tagString) ? new ScannedTag(tagString, false, false, true) : new ScannedTag(tagString, true, false));
        return st;
    }

    private ScannedAttributeString createCurrentContainingAttribute() {
        int localCaretPosition = this.editorCaretPosition - this.partialReverseText.length();
        String tagString = this.startedReverseTag;
        if (this.startedForwardTag != null) {
            tagString = tagString + this.untrimmedStartedForwardTag;
        }
        if (XmlStringHelper.firstIndexOfWhiteSpace((String)tagString) > tagString.indexOf(60) && XmlStringHelper.firstIndexOfWhiteSpace((String)tagString) < localCaretPosition) {
            String attributeString = tagString.substring(XmlStringHelper.firstIndexOfWhiteSpace((String)tagString));
            if (attributeString.length() <= (localCaretPosition -= XmlStringHelper.firstIndexOfWhiteSpace((String)tagString))) {
                return null;
            }
            if (attributeString.charAt(localCaretPosition) == ' ') {
                return new ScannedAttributeString(" ", localCaretPosition);
            }
            return new ScannedAttributeString(attributeString, localCaretPosition);
        }
        return null;
    }

    private String getTagString() {
        String tagString = "";
        if (this.startedReverseTag != null) {
            tagString = this.startedReverseTag;
        }
        if (this.startedForwardTag != null) {
            tagString = tagString + this.startedForwardTag;
        }
        return tagString;
    }

    private String getReverseValueString() {
        String tagString = this.getTagString();
        int localCaretPosition = this.getLocalCaretPosition();
        if (localCaretPosition == 0) {
            return "";
        }
        int index = localCaretPosition - 1;
        char temp = tagString.charAt(index);
        while (temp != '=' && temp != '\"' && temp != '\'' || temp == '>') {
            temp = tagString.charAt(--index);
        }
        if (index < localCaretPosition) {
            return tagString.substring(index + 1, localCaretPosition);
        }
        return "";
    }

    private boolean isValueInsightAllowed() {
        int localCaretPosition = this.editorCaretPosition - this.partialReverseText.length();
        String tagString = this.getTagString();
        if (tagString.indexOf("=") == -1 || tagString.indexOf(32) == -1 && tagString.length() > 1) {
            return false;
        }
        if (tagString.indexOf("=") > -1 && tagString.indexOf("=") >= localCaretPosition) {
            return false;
        }
        String forwardVal = this.getForwardValueString();
        String revVal = this.getReverseValueString();
        if (revVal.equals(" ")) {
            return false;
        }
        return this.isValueInsightAllowed(this.startedReverseTag);
    }

    private String getForwardValueString() {
        int localCaretPosition;
        int index = localCaretPosition = this.getLocalCaretPosition();
        String tagString = this.getTagString();
        if (localCaretPosition == 0 || localCaretPosition >= tagString.length()) {
            return "";
        }
        char temp = tagString.charAt(localCaretPosition);
        while (temp != '\"' && temp != '\'' || temp == '>') {
            if (++index < tagString.length()) {
                temp = tagString.charAt(index);
                continue;
            }
            return null;
        }
        if (index > localCaretPosition) {
            return tagString.substring(localCaretPosition, index);
        }
        return "";
    }

    private int getLocalCaretPosition() {
        return this.editorCaretPosition - this.partialReverseText.length();
    }

    private String getAttributeNameForValue() {
        int localCaretPosition = this.editorCaretPosition - this.partialReverseText.length();
        return XmlStringHelper.findPreviousAttributeNameFromCaretPos((String)this.getTagString(), (int)this.getLocalCaretPosition());
    }

    /*
     * Unable to fully structure code
     */
    private boolean isValueDelimited(String inStr) {
        currentStart = 0;
        singleQuoteIndex = inStr.indexOf(39);
        doublequoteIndex = inStr.indexOf(34);
        if (singleQuoteIndex != -1 || doublequoteIndex != -1) ** GOTO lbl13
        return false;
lbl-1000:
        // 1 sources

        {
            currentStart = singleQuoteIndex > -1 && singleQuoteIndex < doublequoteIndex ? inStr.indexOf(39, singleQuoteIndex + 1) : inStr.indexOf(34, doublequoteIndex + 1);
            if (currentStart == -1) {
                return false;
            }
            singleQuoteIndex = inStr.indexOf(39, currentStart + 1);
            doublequoteIndex = inStr.indexOf(34, currentStart + 1);
            if (singleQuoteIndex != -1 || doublequoteIndex != -1) continue;
            return false;
lbl13:
            // 2 sources

            ** while (currentStart != -1)
        }
lbl14:
        // 1 sources

        return currentStart > -1;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isValueInsightAllowed(String inStr) {
        currentStart = 0;
        singleQuoteIndex = inStr.indexOf(39);
        doublequoteIndex = inStr.indexOf(34);
        if (singleQuoteIndex != -1 || doublequoteIndex != -1) ** GOTO lbl13
        return false;
lbl-1000:
        // 1 sources

        {
            currentStart = singleQuoteIndex > -1 && singleQuoteIndex < doublequoteIndex ? inStr.indexOf(39, singleQuoteIndex + 1) : inStr.indexOf(34, doublequoteIndex + 1);
            if (currentStart == -1) {
                return true;
            }
            singleQuoteIndex = inStr.indexOf(39, currentStart + 1);
            doublequoteIndex = inStr.indexOf(34, currentStart + 1);
            if (singleQuoteIndex != -1 || doublequoteIndex != -1) continue;
            return false;
lbl13:
            // 2 sources

            ** while (currentStart != -1)
        }
lbl14:
        // 1 sources

        return currentStart == -1;
    }

    private void createCurrentContainingTag() {
        String tagString;
        this.attributesAllowed = true;
        if (XmlStringHelper.firstIndexOfWhiteSpace((String)this.startedReverseTag) == -1) {
            this.attributesAllowed = false;
        }
        if (this.isValueDelimited(this.startedReverseTag)) {
            this.attributesAllowed = false;
        }
        if (this.startedReverseTag.endsWith("=")) {
            this.attributesAllowed = false;
        }
        String trimmedStartedForwardTag = "";
        if (this.startedForwardTag != null) {
            trimmedStartedForwardTag = this.startedForwardTag.trim();
        }
        if (trimmedStartedForwardTag != null && trimmedStartedForwardTag.length() > 0) {
            this.insideTagStructure = true;
            tagString = (this.startedReverseTag + trimmedStartedForwardTag).trim();
            if (trimmedStartedForwardTag.equals(">") || trimmedStartedForwardTag.equals("/>")) {
                this.attributesAllowed = true;
            }
        } else {
            this.insideIncompleteTag = true;
            tagString = this.startedReverseTag;
        }
        if (tagString.endsWith("/>")) {
            tagString = Helper.deleteTagBrace((String)tagString);
            tagString = tagString + "/";
        } else {
            tagString = Helper.deleteTagBrace((String)tagString);
        }
        this.containingTag = this.createScannedTagFromString(tagString);
    }

    private boolean identifyClosedTag(String tag) {
        return tag.indexOf("/") == 0;
    }

    private boolean identifyEmptyTag(String tag) {
        return tag.indexOf("/") == tag.length() - 1;
    }

    private void createEmptyTag(String name) {
        ScannedTag st = new ScannedTag(name, true, true);
        st.setSisterTag();
        this.sortCreatedTagIntoCorrectInputWord(st);
    }

    private void createClosedTag(String name) {
        ScannedTag st = new ScannedTag(name, true, false);
        st.setSisterTag();
        this.sortCreatedTagIntoCorrectInputWord(st);
    }

    private void createOpenParentTag(String name) {
        ScannedTag st = new ScannedTag(name, false, false, true);
        st.setParent();
        this.sortCreatedTagIntoCorrectInputWord(st);
    }

    private void createClosedParentTag(String name) {
        ScannedTag st = new ScannedTag(name, true, false, false);
        st.setParent();
        this.sortCreatedTagIntoCorrectInputWord(st);
    }

    private void createOpenTag(String name) {
        ScannedTag st = new ScannedTag(name, false, false);
        st.setSisterTag();
        this.sortCreatedTagIntoCorrectInputWord(st);
    }

    private void sortCreatedTagIntoCorrectInputWord(ScannedTag st) {
        if (!this.scanningDirection) {
            this.reverseInputWord.add(0, st);
        } else {
            this.forwardInputWord.add(st);
        }
    }

    private boolean isJspJavaCodeSection(String newTag) {
        return newTag.startsWith("%");
    }

    private void createInputWord() throws NoCorrespondingTagException, NoMoreElementsException, InvalidDocumentStateException {
        String nextCorrespondingTag = "";
        String newTag = this.findTag();
        if (!this.scanningDirection) {
            boolean i = false;
        }
        if (newTag.length() < 1) {
            this.createInputWord();
        }
        if (newTag.startsWith("!--") || this.isJspJavaCodeSection(newTag)) {
            this.createInputWord();
            return;
        }
        ScannedTag st = new ScannedTag(newTag, false, false, false);
        if ((this.fileType.equals("jsp") || this.fileType.equals("xsl")) && IgnorableTagList.containsElement(st.getUnQualifiedName())) {
            this.createInputWord();
            return;
        }
        if (this.identifyEmptyTag(newTag)) {
            if (this.scanningDirection) {
                this.createOpenTag(newTag);
                this.createClosedTag(newTag);
            } else {
                this.createClosedTag(newTag);
                this.createOpenTag(newTag);
            }
            this.createInputWord();
            return;
        }
        if (!this.scanningDirection) {
            this.buildInputWordReverse(newTag);
        } else {
            this.buildInputWordForwards(newTag);
        }
    }

    private void buildInputWordReverse(String newTag) throws NoCorrespondingTagException {
        String nextCorrespondingTag = "";
        if (this.identifyClosedTag(newTag)) {
            this.createClosedTag(newTag);
            nextCorrespondingTag = this.findCorrespondingTag(newTag.substring(1, newTag.length()));
            this.createOpenTag(nextCorrespondingTag);
            this.createInputWord();
        } else {
            this.createOpenParentTag(newTag);
        }
    }

    private void buildInputWordForwards(String newTag) throws NoCorrespondingTagException {
        String nextCorrespondingTag = "";
        if (!this.identifyClosedTag(newTag)) {
            this.createOpenTag(newTag);
            nextCorrespondingTag = this.findCorrespondingTag(newTag);
            this.createClosedTag(newTag);
            this.createInputWord();
        } else {
            this.createClosedParentTag(newTag);
        }
    }

    private String findCorrespondingTag(String tag) throws NoCorrespondingTagException {
        String nextCorrespondingTag = "";
        nextCorrespondingTag = this.scanningDirection ? this.forwardTokenizer.nextCorrespondingElement(tag) : this.reverseTokenizer.nextCorrespondingElement(tag);
        return nextCorrespondingTag;
    }

    private String findTag() throws NoMoreElementsException, InvalidDocumentStateException {
        String nextTag = "";
        XmlTokenizer tokenizer = this.scanningDirection ? this.forwardTokenizer : this.reverseTokenizer;
        if (tokenizer == null || !tokenizer.hasMoreElements()) {
            throw new NoMoreElementsException();
        }
        tokenizer.setFileNodeType(this.fileType);
        nextTag = (String)tokenizer.nextElement();
        return nextTag;
    }

    private boolean isTagInsightPosValid(boolean calledByKeyStroke) {
        return !this.insideTagStructure && !this.insideIncompleteTag || this.overTagName && calledByKeyStroke;
    }

    private boolean isAttributeInsightPosValid() {
        return this.attributesAllowed && (this.containingTag.isEmptyTag() || !this.containingTag.isClosedTag());
    }

    private void scanTagHistory(boolean calledByKeyStroke) throws InvalidTagPositionException, NoCorrespondingTagException {
        if (this.isTagInsightPosValid(calledByKeyStroke)) {
            try {
                this.createInputWord();
            }
            catch (InvalidDocumentStateException e) {
                throw new InvalidTagPositionException();
            }
        } else {
            throw new InvalidTagPositionException();
        }
    }

    private void reSetAll() {
        this.editorText = null;
        this.editorCaretPosition = 0;
        this.partialReverseText = null;
        this.partialForwardText = null;
        this.startedReverseTag = null;
        this.startedForwardTag = null;
        this.forwardTokenizer = null;
        this.reverseTokenizer = null;
        this.insideTagStructure = false;
        this.insideIncompleteTag = false;
        this.attributesAllowed = false;
        this.overTagName = false;
        this.containingTag = null;
        this.forwardInputWord = new InputWord();
        this.reverseInputWord = new InputWord();
    }

    private int lookForBrace(String searchedBrace, boolean backward, String searchText) {
        String searchString = new String(searchText);
        int result = backward ? searchString.lastIndexOf(searchedBrace) : searchString.indexOf(searchedBrace);
        if (result != -1 && (searchedBrace.equals("<") && searchString.substring(result).startsWith("<%") || searchedBrace.equals(">") && searchString.substring(0, result + 1).endsWith("%>"))) {
            if (backward) {
                return this.lookForBrace(searchedBrace, backward, searchString.substring(0, result - 1));
            }
            return this.lookForBrace(searchedBrace, backward, searchString.substring(result + 1)) + result + 1;
        }
        return result;
    }

    private void setTexts(String text, int caretPosition) {
        this.partialReverseText = this.deMineXmlString(this.editorText.substring(0, caretPosition));
        this.partialForwardText = this.deMineXmlString(this.editorText.substring(caretPosition, this.editorText.length()));
    }

    public void initialise(String text, int caretPosition) {
        this.reSetAll();
        this.editorText = text;
        this.editorCaretPosition = caretPosition;
        this.setTexts(text, caretPosition);
        int lastOpenendBracePosition = this.lookForBrace("<", true, this.partialReverseText);
        if (lastOpenendBracePosition != -1) {
            boolean bl = this.overTagName = !XmlStringHelper.hasWhiteSpaces((String)this.partialReverseText, (int)lastOpenendBracePosition, (int)caretPosition);
            if (this.lookForBrace(">", true, this.partialReverseText) < lastOpenendBracePosition) {
                this.startedReverseTag = this.partialReverseText.substring(lastOpenendBracePosition, this.partialReverseText.length());
                this.partialReverseText = this.partialReverseText.substring(0, lastOpenendBracePosition);
            }
        }
        this.reverseTokenizer = new ReverseXmlTokenizer(this.partialReverseText);
        if (!(this.partialForwardText.startsWith("<") && !this.partialForwardText.startsWith("#") || this.partialForwardText.equals(""))) {
            int firstClosedBracePosition = this.lookForBrace(">", false, this.partialForwardText);
            int firstOpenedBracePosition = this.lookForBrace("<", false, this.partialForwardText);
            if (firstOpenedBracePosition != -1 && firstClosedBracePosition > firstOpenedBracePosition) {
                this.startedForwardTag = "";
            } else if (firstClosedBracePosition > -1) {
                this.startedForwardTag = this.partialForwardText.substring(0, firstClosedBracePosition + 1);
                this.partialForwardText = !this.startedForwardTag.equals(this.partialForwardText) ? this.partialForwardText.substring(this.startedForwardTag.length(), this.partialForwardText.length()) : "";
            } else {
                this.startedForwardTag = this.partialForwardText;
            }
            if (this.startedForwardTag != null) {
                this.untrimmedStartedForwardTag = this.startedForwardTag;
                this.startedForwardTag = this.startedForwardTag.trim();
            } else {
                this.startedForwardTag = "";
            }
            if (this.startedReverseTag != null) {
                this.createCurrentContainingTag();
            }
        }
        this.forwardTokenizer = new ForwardXmlTokenizer(this.partialForwardText);
    }

    private String deMineXmlString(String xmlString) {
        return new XmlStringConverter(xmlString).convertString();
    }
}

