/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.insight.xml.schema.scanning;

import com.tssap.tools.insight.exceptions.NoMoreElementsException;
import com.tssap.tools.insight.xml.schema.scanning.InvalidDocumentStateException;
import com.tssap.tools.insight.xml.schema.scanning.NoCorrespondingTagException;
import com.tssap.tools.insight.xml.schema.scanning.ReverseIgnoreComments;
import com.tssap.tools.insight.xml.schema.scanning.XmlTokenizer;

public class ReverseXmlTokenizer
extends XmlTokenizer {
    private final int MINPOSITION = 0;

    public ReverseXmlTokenizer(String xmlString) {
        super(xmlString);
        xmlString = xmlString.trim();
        if (xmlString.length() < 1) {
            return;
        }
        if (xmlString.charAt(xmlString.length() - 1) == '<') {
            this.setCurrentPosition(xmlString.length() - 1);
        } else {
            this.setCurrentPosition(xmlString.length());
        }
        this.ignoreJavaCode = new ReverseIgnoreComments(new String[][]{{"/*", "*/"}, {"//", "\n"}, {"\"", "\""}});
    }

    public boolean hasMoreElements() {
        return this.getXmlString().lastIndexOf(60) != -1 && this.isHasMoreElementsFlagSet();
    }

    private int getLastFoundPosition(String name, boolean openedTagSearched) {
        if (!openedTagSearched) {
            return this.getXmlString().lastIndexOf("</" + name + '>');
        }
        int pos1 = this.lookForTagNameAndWhiteSpace(name, false);
        int pos2 = this.getXmlString().lastIndexOf('<' + name + '>');
        if (pos1 > -1 && pos2 > -1) {
            if (pos1 > pos2) {
                return pos1;
            }
            return pos2;
        }
        if (pos1 > -1) {
            return pos1;
        }
        if (pos2 > -1) {
            return pos2;
        }
        return -1;
    }

    public String nextCorrespondingElement(String oldTag) throws NoCorrespondingTagException {
        int depth = 1;
        int lastOpenPos = -1;
        while (depth > 0) {
            lastOpenPos = this.getLastFoundPosition(oldTag, true);
            if (lastOpenPos == -1) {
                throw new NoCorrespondingTagException();
            }
            int lastClosedPos = this.getLastFoundPosition(oldTag, false);
            if (lastOpenPos > lastClosedPos) {
                --depth;
                this.setXmlString(this.getXmlString().substring(0, lastOpenPos));
            }
            if (lastClosedPos > lastOpenPos) {
                ++depth;
                this.setXmlString(this.getXmlString().substring(0, lastClosedPos));
            }
            if (this.getXmlString().length() >= 1) continue;
            this.setXmlString("");
        }
        return oldTag;
    }

    private int scanNextTagStart() {
        int tagStart = this.getXmlString().lastIndexOf(60);
        return tagStart;
    }

    protected String nextTag() throws InvalidDocumentStateException, NoMoreElementsException {
        String nextTag = "";
        this.setCurrentPosition(this.scanNextTagStart());
        int lastTagEnd = this.getXmlString().lastIndexOf(62);
        if (this.getCurrentPosition() > lastTagEnd) {
            this.setHasMoreElementsFlag(false);
            throw new InvalidDocumentStateException();
        }
        if (this.getCurrentPosition() != -1) {
            nextTag = this.getXmlString().substring(this.getCurrentPosition() + 1, lastTagEnd);
            if (nextTag.startsWith("?xml")) {
                throw new NoMoreElementsException();
            }
            this.setXmlString(this.getXmlString().substring(0, this.getCurrentPosition()));
            String temp = this.getXmlString().trim();
            if (temp.length() == 0 || !temp.startsWith("<") && !temp.startsWith("#")) {
                this.setHasMoreElementsFlag(false);
            }
        }
        return nextTag;
    }
}

