/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.insight.xml.schema.scanning;

import com.tssap.tools.insight.xml.schema.scanning.ForwardIgnoreComments;
import com.tssap.tools.insight.xml.schema.scanning.InvalidDocumentStateException;
import com.tssap.tools.insight.xml.schema.scanning.NoCorrespondingTagException;
import com.tssap.tools.insight.xml.schema.scanning.XmlTokenizer;
import com.tssap.util.xml.schema.model.elements.XmlStringHelper;

public class ForwardXmlTokenizer
extends XmlTokenizer {
    private int maxPosition;

    public ForwardXmlTokenizer(String xmlString) {
        super(xmlString);
        this.setMaxPosition(xmlString);
        this.setCurrentPosition(0);
        this.ignoreJavaCode = new ForwardIgnoreComments(new String[][]{{"/*", "*/"}, {"//", "\n"}, {"\"", "\""}});
    }

    public boolean hasMoreElements() {
        return this.getXmlString().indexOf(62) != -1 && this.isHasMoreElementsFlagSet() && this.getXmlString().indexOf(60) != -1;
    }

    private int getFirstFoundPosition(String name, boolean openedTagSearched) {
        if (!openedTagSearched) {
            return this.getXmlString().indexOf("</" + name + '>');
        }
        int pos1 = this.getXmlString().indexOf('<' + name + '>');
        int pos2 = this.lookForTagNameAndWhiteSpace(name, true);
        if (pos1 > -1 && pos2 > -1) {
            if (pos1 < pos2) {
                return pos1;
            }
            return pos2;
        }
        if (pos1 > -1) {
            return pos1;
        }
        if (pos2 > -1) {
            return pos2;
        }
        return -1;
    }

    public String nextCorrespondingElement(String oldTag) throws NoCorrespondingTagException {
        if (XmlStringHelper.firstIndexOfWhiteSpace((String)oldTag) != -1) {
            oldTag = oldTag.substring(0, XmlStringHelper.firstIndexOfWhiteSpace((String)oldTag));
        }
        int depth = 1;
        while (depth > 0) {
            int firstClosedPos = this.getFirstFoundPosition(oldTag, false);
            if (firstClosedPos == -1) {
                throw new NoCorrespondingTagException();
            }
            int firstOpenPos = this.getFirstFoundPosition(oldTag, true);
            if (firstClosedPos < firstOpenPos || firstOpenPos == -1) {
                --depth;
                this.setNewXMLStringPosition(firstClosedPos);
            }
            if (firstOpenPos >= firstClosedPos || firstOpenPos <= -1) continue;
            ++depth;
            this.setNewXMLStringPosition(firstOpenPos);
        }
        return "/" + oldTag;
    }

    private void setNewXMLStringPosition(int position) {
        int endIndex = this.getXmlString().indexOf(62, position);
        this.setXmlString(this.getXmlString().substring(endIndex + 1, this.maxPosition));
        this.setMaxPosition(this.getXmlString());
        if (this.getXmlString().length() < 1) {
            this.setXmlString("");
        }
    }

    protected void setMaxPosition(String inString) {
        this.maxPosition = inString.length();
    }

    private int scanNextTagEnd() {
        int tagStart = this.getXmlString().indexOf(60);
        if (this.fileNodeType.equals("jsp") && tagStart > -1 && this.getXmlString().substring(tagStart).startsWith("<%")) {
            this.setXmlString(this.getXmlString().substring(this.ignoreJavaCode.getRestStringPosition(this.getXmlString().substring(tagStart + 2), "%>") + tagStart + 2));
            this.setMaxPosition(this.getXmlString());
        }
        int tagEnd = this.getXmlString().indexOf(62);
        while (this.fileNodeType.equals("jsp") && tagEnd > -1 && this.getXmlString().substring(0, tagEnd + 1).endsWith("%>")) {
            tagEnd = this.getXmlString().substring(tagEnd + 1, this.getXmlString().length()).indexOf(62) + tagEnd + 1;
        }
        return tagEnd;
    }

    protected String nextTag() throws InvalidDocumentStateException {
        String nextTag = "";
        this.setCurrentPosition(this.scanNextTagEnd());
        int lastTagStart = this.getXmlString().indexOf(60);
        if (this.getCurrentPosition() != -1) {
            nextTag = this.getXmlString().substring(lastTagStart + 1, this.getCurrentPosition());
            this.setXmlString(this.getXmlString().substring(this.getCurrentPosition() + 1, this.maxPosition));
            this.setMaxPosition(this.getXmlString());
        }
        return nextTag;
    }
}

