/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.insight.xml.schema.manipulation;

import com.tssap.tools.insight.InsightControl;
import com.tssap.tools.insight.event.ControlForManipulatorEvent;
import com.tssap.tools.insight.event.ControlForManipulatorListener;
import com.tssap.tools.insight.event.InsightRequestEvent;
import com.tssap.tools.insight.event.InsightRequestListener;
import com.tssap.tools.insight.interfaces.EditorProxyI;
import com.tssap.tools.insight.interfaces.ManipulationTargetI;
import com.tssap.tools.insight.interfaces.SearchContextI;
import com.tssap.tools.insight.xml.schema.ValueSelectedEvent;
import com.tssap.tools.insight.xml.schema.ValueSelectedListener;
import com.tssap.tools.insight.xml.schema.interfaceimpl.XmlContext;
import com.tssap.tools.insight.xml.schema.interfaceimpl.XmlInsertManipulationInfo;
import com.tssap.tools.insight.xml.schema.interfaceimpl.XmlMandatoryAttributesManipulationInfo;
import com.tssap.tools.insight.xml.schema.interfaceimpl.XmlRepositionManipulationInfo;
import com.tssap.tools.insight.xml.schema.interfaceimpl.XmlRootManipulationInfo;
import com.tssap.tools.insight.xml.schema.manipulation.StateObject;
import com.tssap.util.insight.interfaces.SearchTargetI;
import com.tssap.util.xml.schema.model.interfaceimpl.XmlTarget;
import com.tssap.util.xml.schema.model.util.Helper;
import java.util.Vector;

public class XmlInstanceManipulation
implements ValueSelectedListener,
ControlForManipulatorListener {
    private InitiatInsightAnouncer insightAnouncer = new InitiatInsightAnouncer();
    private EditorProxyI editorPane;
    private String fileNodeType;
    private StateObject obj = new StateObject();
    private boolean attributeInisghtAllowed = false;

    public XmlInstanceManipulation(EditorProxyI editorPane, String fileNodeType) {
        this.editorPane = editorPane;
        this.fileNodeType = fileNodeType;
    }

    private void insertRootElementForNodeType(String fileNodeType) {
        if (fileNodeType.equals("xsd")) {
            this.rootSelected("<xsd:schema targetNamespace=\"\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\n\n\n\n</xsd:schema>", (SearchTargetI)new XmlTarget("root"));
        }
    }

    public void handleControlForManipulatorEvent(ControlForManipulatorEvent event) {
        ManipulationTargetI target = event.getManipulationTarget();
        if (target.getManipulationTarget().equals("mandatory_attribute")) {
            this.insertMandatoryAttribute(event.getContext(), ((XmlMandatoryAttributesManipulationInfo)target).getAttributeVector());
        }
        if (target.getManipulationTarget().equals("reposition")) {
            this.repositionCursor(((XmlRepositionManipulationInfo)target).getRepositionBy());
        }
        if (target.getManipulationTarget().equals("root_element")) {
            this.insertRootElementForNodeType(((XmlRootManipulationInfo)target).getFileNodeType());
        }
        if (target.getManipulationTarget().equals("space")) {
            if (((XmlInsertManipulationInfo)target).getStringToInsert() != null) {
                this.insertString(((XmlInsertManipulationInfo)target).getStringToInsert());
            } else {
                this.insertNecessaryCharSpace();
            }
        }
    }

    public void valueSelected(ValueSelectedEvent e) {
        this.obj = ((XmlContext)e.getSearchContext()).getStateObject();
        if (e.getValue() != null && e.getValue().length() > 0) {
            if (((XmlTarget)e.getSearchTarget()).getTarget().equals("attribute")) {
                this.attributeSelected(e.getValue(), e.getSearchContext(), e.getSearchTarget());
            }
            if (((XmlTarget)e.getSearchTarget()).getTarget().equals("tag")) {
                this.tagSelected(e.getValue(), e.getSearchContext(), e.getSearchTarget());
            }
            if (((XmlTarget)e.getSearchTarget()).getTarget().equals("value")) {
                this.valueSelected(e.getValue(), e.getSearchContext(), e.getSearchTarget());
            }
            if (((XmlTarget)e.getSearchTarget()).getTarget().equals("root")) {
                this.rootSelected(e.getValue(), e.getSearchTarget());
            }
        } else {
            this.insightAnouncer.notifyOfInisghtActionRequest(this, null, null);
        }
    }

    public void addInitiateInsightListener(InsightRequestListener iil) {
        this.insightAnouncer.addNewInitiateInsightListener(iil);
    }

    private void tagSelected(String selectedTag, SearchContextI context, SearchTargetI target) {
        boolean closedTag = selectedTag.charAt(1) == '/';
        String lTagName = Helper.deleteTagBrace((String)selectedTag);
        this.insertSelectedValue(selectedTag, "tag", target);
        if (!closedTag) {
            XmlTarget newTarget = new XmlTarget("mandatoryAttribute");
            newTarget.setFileNodeType(this.fileNodeType);
            this.insightAnouncer.notifyOfInisghtActionRequest(this, context, (SearchTargetI)newTarget);
        }
    }

    private void rootSelected(String selectedRootElement, SearchTargetI target) {
        if (this.fileNodeType.equals("xsl")) {
            String frontPart = selectedRootElement.substring(0, selectedRootElement.indexOf(">"));
            String endPart = selectedRootElement.substring(selectedRootElement.indexOf(">") + 1);
            selectedRootElement = frontPart + " xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">" + "\n\n\n\n" + endPart;
        }
        this.insertSelectedValue(selectedRootElement, "root", target);
    }

    private void valueSelected(String selectedValue, SearchContextI context, SearchTargetI target) {
        this.insertSelectedValue(selectedValue, "value", target);
        if (target instanceof XmlMandatoryAttributesManipulationInfo) {
            this.insertMandatoryAttribute(context, ((XmlMandatoryAttributesManipulationInfo)target).getAttributeVector());
        } else {
            this.insertMandatoryAttribute(context, null);
        }
    }

    private void attributeSelected(String selectedAttribute, SearchContextI context, SearchTargetI target) {
        String lAppendix = "=\"\"";
        String completeString = "";
        completeString = this.obj.getEndString().toString().equals("") && !this.obj.isValidAttributeEnd() ? selectedAttribute + lAppendix : selectedAttribute;
        this.insertSelectedValue(completeString, "attribute", target);
        XmlTarget newTarget = new XmlTarget("value");
        newTarget.setFileNodeType(this.fileNodeType);
        this.insightAnouncer.notifyOfInisghtActionRequest(this, context, (SearchTargetI)newTarget);
    }

    private void insertMandatoryAttribute(SearchContextI context, Vector mandatoryAttributes) {
        XmlTarget target;
        if (mandatoryAttributes != null && mandatoryAttributes.size() > 0) {
            this.obj = ((XmlContext)context).getStateObject();
            if (this.obj.getStartString() == null || this.obj.getStartString().getLength() < 1) {
                this.insertString(" ");
            }
            if (!this.obj.isValidAttributeEnd()) {
                this.insertSelectedValue(mandatoryAttributes.elementAt(0) + "=\"\"", "attribute", (SearchTargetI)new XmlTarget("mandatoryAttribute"));
            } else {
                this.insertSelectedValue((String)mandatoryAttributes.elementAt(0), "attribute", (SearchTargetI)new XmlTarget("mandatoryAttribute"));
            }
            String attName = (String)mandatoryAttributes.elementAt(0);
            mandatoryAttributes.remove(0);
            ((XmlContext)context).getStateObject().setMandatoryAttributes(mandatoryAttributes);
            target = new XmlTarget("value");
        } else {
            target = new XmlTarget("attribute");
        }
        target.setFileNodeType(this.fileNodeType);
        this.insightAnouncer.notifyOfInisghtActionRequest(this, context, (SearchTargetI)target);
    }

    private final void insertSelectedValue(String selectedValue, String nodeType, SearchTargetI target) {
        String stringToInsert = selectedValue;
        int pos = 0;
        try {
            if (!target.getTarget().equals("root")) {
                if (this.obj.getStartString().isStartStringOf(stringToInsert)) {
                    stringToInsert = this.obj.getStartString().getStringTail(stringToInsert);
                } else {
                    this.editorPane.deletePrevString(this.obj.getStartString().getLength());
                }
                if (this.obj.getEndString().isEndStringOf(stringToInsert)) {
                    pos = this.obj.getEndString().getLength();
                    stringToInsert = this.obj.getEndString().getStringHead(stringToInsert);
                } else {
                    this.editorPane.deleteNextString(this.obj.getEndString().getLength());
                }
            }
            this.insertString(stringToInsert);
            if (nodeType.equals("tag")) {
                if (selectedValue.endsWith("/>")) {
                    pos -= 2;
                } else if (selectedValue.endsWith(">")) {
                    pos = selectedValue.indexOf("></") > -1 ? (pos -= (selectedValue.length() - 1) / 2 + 2) : --pos;
                }
            }
            if (nodeType.equals("attribute")) {
                pos = this.obj.isValidAttributeEnd() ? (pos += 2) : --pos;
            }
            if (nodeType.equals("value")) {
                ++pos;
            }
            if (nodeType.equals("root")) {
                String temp = stringToInsert.substring(stringToInsert.indexOf("</"));
                pos -= temp.length() + 2;
            }
            this.setRelativeCaretPosition(pos);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    private void repositionCursor(int repositionBy) {
        this.setRelativeCaretPosition(repositionBy);
    }

    private final void insertString(String text, int caretPosition) {
        if (this.editorPane != null) {
            this.editorPane.insertString(text, caretPosition);
        }
    }

    private final void insertNecessaryCharSpace() {
        this.editorPane.insertNecessaryCharSpace();
    }

    private final void insertString(String text) {
        if (this.editorPane != null) {
            this.insertString(text, this.editorPane.getCaretPosition());
        }
    }

    private final void setRelativeCaretPosition(int relativePosition) {
        if (this.editorPane != null) {
            this.editorPane.setCaretPosition(this.editorPane.getCaretPosition() + relativePosition);
        }
    }

    private static class InitiatInsightAnouncer {
        private Vector listeners = new Vector();
        private String elementName;

        public synchronized void addNewInitiateInsightListener(InsightRequestListener l) {
            this.listeners.addElement(l);
        }

        public synchronized void removeNewModelListener(InsightRequestListener l) {
            this.listeners.removeElement(l);
        }

        protected void notifyOfInisghtActionRequest(Object source, SearchContextI context, SearchTargetI target) {
            Vector l;
            InsightRequestEvent event = new InsightRequestEvent(source, context, target);
            InitiatInsightAnouncer initiatInsightAnouncer = this;
            synchronized (initiatInsightAnouncer) {
                l = (Vector)this.listeners.clone();
            }
            int i = 0;
            while (i < l.size()) {
                try {
                    ((InsightControl)this.listeners.elementAt(i)).initiateInsight(event);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                ++i;
            }
        }
    }
}

