/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.insight.xml;

import com.tssap.tools.insight.InsightControl;
import com.tssap.tools.insight.event.InsightRequestEvent;
import com.tssap.tools.insight.interfaces.SearchContextI;
import com.tssap.tools.insight.xml.schema.SchemaPageInfo;
import com.tssap.tools.insight.xml.schema.interfaceimpl.XMLContextDirection;
import com.tssap.tools.insight.xml.schema.interfaceimpl.XmlContext;
import com.tssap.tools.insight.xml.schema.interfaceimpl.XmlMandatoryAttributesManipulationInfo;
import com.tssap.tools.insight.xml.schema.interfaceimpl.XmlRepositionManipulationInfo;
import com.tssap.tools.insight.xml.schema.interfaceimpl.XmlRootManipulationInfo;
import com.tssap.tools.insight.xml.schema.scanning.TagHistoryScanner;
import com.tssap.util.insight.interfaces.MultipleContextDirectionsI;
import com.tssap.util.insight.interfaces.PossibleElementsRequestI;
import com.tssap.util.insight.interfaces.SearchTargetI;
import com.tssap.util.insight.interfaces.VectorConverterI;
import com.tssap.util.xml.schema.model.GlobalSchemaModel;
import com.tssap.util.xml.schema.model.StringConverter;
import com.tssap.util.xml.schema.model.dispatchers.JspDispatcher;
import com.tssap.util.xml.schema.model.dispatchers.XmlDispatcher;
import com.tssap.util.xml.schema.model.dispatchers.XsdDispatcher;
import com.tssap.util.xml.schema.model.dispatchers.XslDispatcher;
import com.tssap.util.xml.schema.model.elements.ResultTag;
import com.tssap.util.xml.schema.model.interfaceimpl.XmlPossibleAttributesRequest;
import com.tssap.util.xml.schema.model.interfaceimpl.XmlPossibleTagsRequest;
import com.tssap.util.xml.schema.model.interfaceimpl.XmlPossibleValuesRequest;
import com.tssap.util.xml.schema.model.interfaceimpl.XmlTarget;
import java.util.Vector;
import org.xml.sax.EntityResolver;

public abstract class XmlInsightControl
extends InsightControl {
    public XmlInsightControl(EntityResolver er) {
        this.globalModel = new GlobalSchemaModel(er);
        this.pageInfo = new SchemaPageInfo();
        this.scanner = new TagHistoryScanner();
        this.directionHandler = new XMLContextDirection();
        this.converter = new StringConverter();
    }

    protected PossibleElementsRequestI createPossibleElementRequest(SearchTargetI target, MultipleContextDirectionsI contextDirection, SearchContextI context) {
        if (target.getTarget().equals("tag")) {
            return new XmlPossibleTagsRequest(target, contextDirection, ((XmlContext)context).getInputWord());
        }
        if (target.getTarget().equals("attribute") || target.getTarget().equals("mandatoryAttribute")) {
            return new XmlPossibleAttributesRequest(target, contextDirection, ((XmlContext)context).getInputWord(), ((XmlContext)context).getContainingTag().getAttributes());
        }
        if (target.getTarget().equals("value")) {
            return new XmlPossibleValuesRequest(target, contextDirection, ((XmlContext)context).getInputWord(), ((XmlContext)context).getAttributeName());
        }
        return null;
    }

    protected void handleEmptyResultList(SearchTargetI target) {
        if (target.getTarget().equals("tag")) {
            return;
        }
        if (target.getTarget().equals("attribute")) {
            this.manipulationAnouncer.notifyOfControlForManipulatorEvent(this, new XmlRepositionManipulationInfo(1));
        }
        if (target.getTarget().equals("mandatoryAttribute")) {
            this.initiateInsight(new InsightRequestEvent(this, null, (SearchTargetI)new XmlTarget("attribute", ((XmlTarget)target).isCallDoneByKestroke(), ((XmlTarget)target).getFileNodeType())));
        }
        if (target.getTarget().equals("value")) {
            this.manipulationAnouncer.notifyOfControlForManipulatorEvent(this, new XmlRepositionManipulationInfo(1));
            if (!((XmlTarget)target).isCallDoneByKestroke()) {
                this.initiateInsight(new InsightRequestEvent(this, null, (SearchTargetI)new XmlTarget("mandatoryAttribute", ((XmlTarget)target).isCallDoneByKestroke(), ((XmlTarget)target).getFileNodeType())));
            }
        }
    }

    protected void targetDependentDispatching(SearchTargetI target) {
        String nodeType = ((XmlTarget)target).getFileNodeType();
        if (nodeType == null) {
            System.out.println("Filetype not supported!");
            return;
        }
        if (nodeType.equals("jsp")) {
            this.pageInfo.setDispatcher(new JspDispatcher());
            this.globalModel.setDispatcher((Object)new JspDispatcher());
        } else if (nodeType.equals("xml")) {
            this.pageInfo.setDispatcher(new XmlDispatcher());
            this.globalModel.setDispatcher((Object)new XmlDispatcher());
        } else if (nodeType.equals("xsd")) {
            this.pageInfo.setDispatcher(new XsdDispatcher());
            this.globalModel.setDispatcher((Object)new XsdDispatcher());
            String editorText = this.getEditorPane().getText().trim();
            if (editorText.length() < 2) {
                this.manipulationAnouncer.notifyOfControlForManipulatorEvent(this, new XmlRootManipulationInfo("xsd"));
            }
        } else if (nodeType.equals("xsl")) {
            this.pageInfo.setDispatcher(new XslDispatcher());
            this.globalModel.setDispatcher((Object)new XslDispatcher());
            String editorText = this.getEditorPane().getText().trim();
            if (editorText.length() < 2) {
                Vector<ResultTag> xslRootElements = new Vector<ResultTag>();
                ResultTag tag = new ResultTag("xsl:stylesheet", false, false);
                tag.setConversionType(1);
                xslRootElements.add(tag);
                tag = new ResultTag("xsl:transform", false, false);
                tag.setConversionType(1);
                xslRootElements.add(tag);
                XmlContext context = new XmlContext();
                context.setStartString("");
                context.setEndString("");
                this.windowHandler.showWindow(xslRootElements, this.converter, context, (SearchTargetI)new XmlTarget("root"));
            }
        } else {
            System.out.println("File Node Type not supported: " + nodeType);
            return;
        }
    }

    protected void processDialog(SearchTargetI target, VectorConverterI converter, Vector entries, SearchContextI context) {
        if (entries != null && entries.size() > 0) {
            if (((XmlTarget)target).getTarget().equals("mandatoryAttribute")) {
                entries = converter.convertElementListToStringList(entries, target);
                this.manipulationAnouncer.notifyOfControlForManipulatorEvent(this, new XmlMandatoryAttributesManipulationInfo(entries), context);
            } else {
                this.windowHandler.showWindow(entries, converter, context, target);
            }
        }
    }
}

