/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.insight.util;

public class InsightString {
    protected String mText = null;
    protected String furtherAllowedCharacters = null;

    public InsightString() {
        this.initialize();
    }

    public InsightString(String str) {
        this.setString(str);
    }

    public InsightString(String str, String fac) {
        this.setString(str);
        this.setFurtherAllowedCharacters(fac);
    }

    public String toString() {
        return this.mText;
    }

    public void setString(String str) {
        this.mText = str;
    }

    public void setFurtherAllowedCharacters(String fac) {
        this.furtherAllowedCharacters = fac;
    }

    public boolean isInitial() {
        return this.toString().length() == 0;
    }

    public void initialize() {
        this.setString("");
    }

    public int getLength() {
        return this.toString().length();
    }

    public char getCharacterAtPosition(int position) {
        return this.toString().charAt(position);
    }

    public boolean isValidCharacter(char c) {
        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
            return true;
        }
        return this.furtherAllowedCharacters != null && this.furtherAllowedCharacters.indexOf(new String(new char[]{c})) > -1;
    }

    public void appendCharacter(char c) {
        this.setString(this.toString().concat(new String(new char[]{c})));
    }

    public void insertCharacterAtPosition(int position, char c) {
        if (position < 0) {
            return;
        }
        String lLeadingPart = null;
        String lEndingPart = null;
        if (position > this.getLength() - 1) {
            this.appendCharacter(c);
            return;
        }
        lEndingPart = this.toString().substring(position);
        lLeadingPart = position > 0 ? this.toString().substring(0, position - 1) : "";
        this.setString(lLeadingPart + new String(new char[]{c}) + lEndingPart);
    }
}

