/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.archive.internal.impl;

import com.tssap.tools.archive.ArchiveDescriptionManager;
import com.tssap.tools.archive.IArchive;
import com.tssap.tools.archive.IArchiveDescriptor;
import com.tssap.tools.archive.IFileLocation;
import com.tssap.tools.archive.IFileSet;
import com.tssap.tools.archive.IWarDescriptor;
import com.tssap.tools.archive.Pattern;
import com.tssap.tools.archive.RelativePath;
import com.tssap.tools.archive.internal.INestedArchiveDescriptor;
import com.tssap.tools.archive.internal.impl.ComponentBuildInfo;
import com.tssap.tools.archive.internal.impl.ContentNameBind;
import com.tssap.tools.archive.internal.impl.FileContainDescriptor;
import com.tssap.tools.archive.internal.impl.FileLocationImpl;
import com.tssap.tools.archive.internal.impl.FileLocationSet;
import com.tssap.tools.archive.internal.impl.FileSetPrefixSetter;
import com.tssap.tools.archive.internal.impl.NestedArchive;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WarDescriptor
extends FileContainDescriptor
implements IWarDescriptor {
    private static final String WEB_INF_FOLDER_PATH = "WEB-INF";
    private static final String WEB_INF_XML_PATH = "WEB-INF/web.xml";
    private static final String SERVER_LIB_PATH = "WEB-INF/lib/";
    private static final String SERVER_SOURCES_PATH = "WEB-INF/classes/";
    private ArrayList serverLibFileSets = new ArrayList();
    private ArrayList serverLibArchives = new ArrayList();
    private ArrayList serverLibFiles = new ArrayList();
    private ArrayList serverSources = new ArrayList();
    private ArrayList clientSources = new ArrayList();
    private String webDescriptionFilePath;

    public WarDescriptor() {
        this.setComponentBuildInfo(ComponentBuildInfo.createDefaultWarCBI());
    }

    public boolean isUseComponentBuild() {
        return true;
    }

    public void performBuild() {
        IArchiveDescriptor arDesc = ArchiveDescriptionManager.newArchiveDescription();
        arDesc.setDestPath(this.getDestPath());
        arDesc.setCompressed(this.isCompressed());
        IFileSet[] fs = this.getAllContainedFileSets();
        INestedArchiveDescriptor[] ns = this.getNestedArchives();
        int i = 0;
        while (i < fs.length) {
            arDesc.addFileSet(fs[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < ns.length) {
            arDesc.addNestedArchive(ns[i2].getArchiveDescriptor(), ns[i2].isTemporary(), ns[i2].getPathInArchive());
            ++i2;
        }
        arDesc.setComponentBuildInfo(this.getComponentBuildInfo());
        arDesc.performBuild();
    }

    public void addClientSources(IFileSet files) {
        this.clientSources.add(files);
    }

    public void addServerSideLib(IArchive archive, String fileLocation) {
        this.serverLibArchives.add(new ContentNameBind(archive, true, fileLocation, 5));
    }

    public void addServerSideLib(IFile file) {
        this.serverLibFiles.add(RelativePath.getRelativePath((IResource)file));
    }

    public void addServerSideLibs(IArchive[] archive, String[] fileLocation) {
        boolean hasLocation = true;
        if (fileLocation == null) {
            hasLocation = false;
        } else if (archive.length != fileLocation.length) {
            throw new IllegalArgumentException("IWarFileSet.addServerSideLibs(IArchiveDescriptor[] archive, String[] fileLocation) different array lengths");
        }
        int i = 0;
        while (i < archive.length) {
            this.addServerSideLib(archive[i], hasLocation ? fileLocation[i] : null);
            ++i;
        }
    }

    public void addServerSideLibs(IFileSet files) {
        this.serverLibFileSets.add(files);
    }

    public void addServerSideSources(IFileSet files) {
        this.serverSources.add(files);
    }

    public void setWebDescriptor(IFile file) {
        this.webDescriptionFilePath = RelativePath.getRelativePath((IResource)file);
    }

    public Element getXMLRepresentation(Document doc) {
        throw new RuntimeException("getXMLRepresentation( doc ) not yet implemented");
    }

    public IFileLocation[] getFileLocations() {
        IFileSet[] fileSets = this.getAllContainedFileSets();
        ArrayList<IFileLocation> allLocations = new ArrayList<IFileLocation>();
        allLocations.addAll(Arrays.asList(super.getFileLocations()));
        int i = 0;
        while (i < fileSets.length) {
            IFileLocation[] fileLocations = fileSets[i].getFileLocations();
            int j = 0;
            while (j < fileLocations.length) {
                allLocations.add(fileLocations[j]);
                ++j;
            }
            ++i;
        }
        return allLocations.toArray(new IFileLocation[allLocations.size()]);
    }

    private IFileSet[] getAllContainedFileSets() {
        ArrayList<IFileSet> allSets = new ArrayList<IFileSet>();
        allSets.addAll(Arrays.asList(super.getFileSets()));
        int i = 0;
        while (i < this.serverLibFileSets.size()) {
            allSets.add(new FileSetPrefixSetter((IFileSet)this.serverLibFileSets.get(i), SERVER_LIB_PATH));
            ++i;
        }
        FileLocationSet libFilesSet = new FileLocationSet();
        int i2 = 0;
        while (i2 < this.serverLibFiles.size()) {
            String libFile = (String)this.serverLibFiles.get(i2);
            libFilesSet.addFileLocation(new FileLocationImpl(RelativePath.removeLastSegment(libFile), Pattern.getPattern(new String[]{RelativePath.getLastSegment(libFile)}, null), null, null, false, true));
            ++i2;
        }
        allSets.add(libFilesSet);
        int i3 = 0;
        while (i3 < this.serverSources.size()) {
            allSets.add(new FileSetPrefixSetter((IFileSet)this.serverSources.get(i3), SERVER_SOURCES_PATH));
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.clientSources.size()) {
            allSets.add((IFileSet)this.clientSources.get(i4));
            ++i4;
        }
        FileLocationSet fileLocSet = new FileLocationSet();
        fileLocSet.addFileLocation(new FileLocationImpl(RelativePath.removeLastSegment(this.webDescriptionFilePath), Pattern.getPattern(new String[]{RelativePath.getLastSegment(this.webDescriptionFilePath)}, null), null, WEB_INF_XML_PATH, false, true));
        allSets.add(fileLocSet);
        return allSets.toArray(new IFileSet[allSets.size()]);
    }

    public INestedArchiveDescriptor[] getNestedArchives() {
        INestedArchiveDescriptor[] nestedAr = new INestedArchiveDescriptor[this.serverLibArchives.size()];
        int i = 0;
        while (i < nestedAr.length) {
            IArchive ar = ((ContentNameBind)this.serverLibArchives.get(i)).getArchive();
            String nameInArchive = ((ContentNameBind)this.serverLibArchives.get(i)).getLocation();
            nestedAr[i] = new NestedArchive(ar, true, SERVER_LIB_PATH + nameInArchive);
            ++i;
        }
        return nestedAr;
    }
}

