/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.archive.internal.impl;

import com.tssap.tools.XMLUtil;
import com.tssap.tools.archive.IFileLocation;
import com.tssap.tools.archive.IPattern;
import com.tssap.tools.archive.IProjectFileSet;
import com.tssap.tools.archive.Pattern;
import com.tssap.tools.archive.RelativePath;
import com.tssap.tools.archive.internal.IXMLSerializeLogger;
import com.tssap.tools.archive.internal.PatternBase;
import com.tssap.tools.archive.internal.XMLSerializable;
import com.tssap.tools.archive.internal.impl.FileLocationImpl;
import com.tssap.tools.archive.internal.impl.FileSet;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProjectFileSet
extends FileSet
implements IProjectFileSet {
    private static final String PROJECT_FILESET_TAG = "ProjectFiles";
    private static final String PROJECT_FILECONTENT_TAG = "file";
    private static final String PROJECT_FOLDERCONTENT_TAG = "folder";
    private static final String PROJECT_CONTENTPATH_ATTRIBUTE = "name";
    private static final String PROJECT_CONTENTPREFIX_ATTRIBUTE = "prefix";
    private static final String PROJECT_CONTENTNAMEINARCHIVE_ATTRIBUTE = "nameInArchive";
    private ArrayList files = new ArrayList();
    private ArrayList folders = new ArrayList();
    private ArrayList relatives = new ArrayList();

    public ProjectFileSet() {
        super(1);
    }

    public IFileLocation[] getFileLocations() {
        ArrayList<FileLocationImpl> locationList = new ArrayList<FileLocationImpl>();
        int i = 0;
        while (i < this.files.size()) {
            ProjFile f = (ProjFile)this.files.get(i);
            FileLocationImpl loc = new FileLocationImpl(RelativePath.removeLastSegment(f.getRelPath()), Pattern.getPattern(new String[]{RelativePath.getLastSegment(f.getRelPath())}, null), null, f.getNameInArchive(), false, true);
            locationList.add(loc);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.folders.size()) {
            ProjFolder f = (ProjFolder)this.folders.get(i2);
            FileLocationImpl loc = new FileLocationImpl(f.getFolder(), f.getPattern(), f.getPrefix(), null, false, false);
            locationList.add(loc);
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.relatives.size()) {
            ProjFolder f = (ProjFolder)this.relatives.get(i3);
            FileLocationImpl loc = new FileLocationImpl(f.getFolder(), f.getPattern(), f.getPrefix(), null, false, false);
            locationList.add(loc);
            ++i3;
        }
        return locationList.toArray(new IFileLocation[locationList.size()]);
    }

    public void addProjectFile(IFile f) {
        this.addProjectFile(f, f.getName());
    }

    public void addProjectFile(IFile f, String nameInArchive) {
        this.files.add(new ProjFile(RelativePath.getRelativePath((IResource)f), nameInArchive));
    }

    public void addProjectFiles(IContainer f, IPattern pattern, String prefix) {
        this.folders.add(new ProjFolder(RelativePath.getRelativePath((IResource)f), prefix, pattern));
    }

    public void addProjectFiles(IContainer f, IPattern pattern) {
        this.addProjectFiles(f, pattern, null);
    }

    public void addProjectFiles(IContainer f) {
        this.addProjectFiles(f, Pattern.getPattern(3), null);
    }

    public void addRelativeFile(IProject proj, RelativePath.PathType relPath, IPattern pattern, String prefix) {
        this.relatives.add(new ProjFolder(RelativePath.getRelativePath(proj, relPath.toString()), prefix, pattern));
    }

    public void addRelativeFile(IProject proj, RelativePath.PathType relPath, IPattern pattern) {
        this.addRelativeFile(proj, relPath, pattern, null);
    }

    public void addRelativeFile(IProject proj, RelativePath.PathType relPath) {
        this.addRelativeFile(proj, relPath, Pattern.getPattern(3), null);
    }

    public static String getElementName() {
        return PROJECT_FILESET_TAG;
    }

    public static ProjectFileSet getInstanceFromXML(Element element, IXMLSerializeLogger log) {
        log.assertt(element.getNodeName().equals(PROJECT_FILESET_TAG), "Invalid root tag for constructing ProjectFileSet: " + element.getNodeName());
        ProjectFileSet ret = new ProjectFileSet();
        Element[] children = XMLUtil.getElementsFromNodeList(element.getChildNodes());
        int i = 0;
        while (i < children.length) {
            log.assertt(children[i].getNodeName().equals(PROJECT_FOLDERCONTENT_TAG) || children[i].getNodeName().equals(PROJECT_FILECONTENT_TAG), "Invalid ProjectFileSet subtag " + children[i].getNodeName());
            String arPath = children[i].getAttribute(PROJECT_CONTENTPATH_ATTRIBUTE);
            log.assertt(arPath.length() > 0, "Archive path must be qualified in project file set content tag");
            if (children[i].getNodeName().equals(PROJECT_FOLDERCONTENT_TAG)) {
                String prefix = children[i].getAttribute(PROJECT_CONTENTPREFIX_ATTRIBUTE);
                Element[] patChild = XMLUtil.getElementsFromNodeList(children[i].getChildNodes());
                log.assertt(patChild.length <= 1, "Only one pattern sub tag allowed in one project file content");
                IPattern pat = null;
                if (patChild.length == 1) {
                    pat = PatternBase.getInstanceFromXML(patChild[0], log);
                }
                ProjFolder projFolder = ret.new ProjFolder(arPath, prefix.length() > 0 ? prefix : null, pat);
                ret.addProjFolder(projFolder);
            } else {
                String nameInArchive = children[i].getAttribute(PROJECT_CONTENTNAMEINARCHIVE_ATTRIBUTE);
                ProjFile projFile = ret.new ProjFile(arPath, nameInArchive);
                ret.addProjFile(projFile);
            }
            ++i;
        }
        return ret;
    }

    private void addProjFile(ProjFile projFile) {
        this.files.add(projFile);
    }

    private void addProjFolder(ProjFolder projFolder) {
        this.folders.add(projFolder);
    }

    public Element getXMLRepresentation(Document doc) {
        Element ret = doc.createElement(PROJECT_FILESET_TAG);
        ArrayList<Element> contentList = new ArrayList<Element>();
        int i = 0;
        while (i < this.files.size()) {
            ProjFile f = (ProjFile)this.files.get(i);
            Element el = doc.createElement(PROJECT_FILECONTENT_TAG);
            el.setAttribute(PROJECT_CONTENTPATH_ATTRIBUTE, f.getRelPath());
            if (f.getNameInArchive() != null) {
                el.setAttribute(PROJECT_CONTENTNAMEINARCHIVE_ATTRIBUTE, f.getNameInArchive());
            }
            contentList.add(el);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.folders.size() + this.relatives.size()) {
            ProjFolder f = (ProjFolder)(i2 < this.folders.size() ? this.folders.get(i2) : this.relatives.get(i2 - this.folders.size()));
            Element el = doc.createElement(PROJECT_FOLDERCONTENT_TAG);
            el.setAttribute(PROJECT_CONTENTPATH_ATTRIBUTE, f.getFolder());
            if (f.getPrefix() != null) {
                el.setAttribute(PROJECT_CONTENTPREFIX_ATTRIBUTE, f.getPrefix());
            }
            el.appendChild(((XMLSerializable)((Object)f.getPattern())).getXMLRepresentation(doc));
            contentList.add(el);
            ++i2;
        }
        int i3 = 0;
        while (i3 < contentList.size()) {
            ret.appendChild((Element)contentList.get(i3));
            ++i3;
        }
        return ret;
    }

    class ProjFolder {
        private String folderPath;
        private String prefix;
        private IPattern pattern;

        ProjFolder(String folderPath, String prefix, IPattern pattern) {
            this.folderPath = folderPath;
            this.prefix = prefix;
            this.pattern = pattern;
        }

        public String getFolder() {
            return this.folderPath;
        }

        public IPattern getPattern() {
            return this.pattern;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }

    class ProjFile {
        private String relPath;
        private String nameInArchive;

        ProjFile(String relPath, String nameInArchive) {
            this.relPath = relPath;
            this.nameInArchive = nameInArchive;
        }

        public String getNameInArchive() {
            return this.nameInArchive;
        }

        public String getRelPath() {
            return this.relPath;
        }
    }
}

