/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.archive.internal.impl;

import com.tssap.tools.XMLUtil;
import com.tssap.tools.archive.IArchive;
import com.tssap.tools.archive.internal.INestedArchiveDescriptor;
import com.tssap.tools.archive.internal.IXMLSerializeLogger;
import com.tssap.tools.archive.internal.XMLSerializable;
import com.tssap.tools.archive.internal.impl.ArchiveDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NestedArchive
implements INestedArchiveDescriptor,
XMLSerializable {
    private static final String NESTED_ARCHIVE_TAG = "NestedArchive";
    private static final String NESTED_ARCHIVE_TEMPORAY_ATTRIBUTE = "temporary";
    private static final String NESTED_ARCHIVE_NAMEINARCHIVE_ATTRIBUTE = "nameInArchive";
    private IArchive arDesc;
    private boolean isTemporary;
    private String pathInArchive;

    public NestedArchive(IArchive arDescr, boolean isTemporary, String pathInArchive) {
        this.arDesc = arDescr;
        this.isTemporary = isTemporary;
        this.pathInArchive = pathInArchive;
    }

    public IArchive getArchiveDescriptor() {
        return this.arDesc;
    }

    public String getPathInArchive() {
        return this.pathInArchive;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public static String getElementName() {
        return NESTED_ARCHIVE_TAG;
    }

    public static NestedArchive getInstanceFromXML(Element element, IXMLSerializeLogger log) {
        log.assertt(element.getNodeName().equals(NESTED_ARCHIVE_TAG), "Invalid root tag for constructing NestedArchive: " + element.getNodeName());
        String nameInArchive = element.getAttribute(NESTED_ARCHIVE_NAMEINARCHIVE_ATTRIBUTE);
        String isTmpStr = element.getAttribute(NESTED_ARCHIVE_TEMPORAY_ATTRIBUTE);
        log.assertt(nameInArchive.length() > 0, "missing nameInArchive attribute in nested archive tag");
        log.assertt(isTmpStr.length() > 0, "missing temporary attribute in nested archive tag");
        Element[] childern = XMLUtil.getElementsFromNodeList(element.getChildNodes());
        log.assertt(childern.length == 1, "NestedArchive allows just one Archive subtag");
        ArchiveDescriptor nestedDescr = ArchiveDescriptor.getInstanceFromXML(childern[0], log);
        return new NestedArchive(nestedDescr, Boolean.valueOf(isTmpStr), nameInArchive);
    }

    public Element getXMLRepresentation(Document doc) {
        Element ret = doc.createElement(NESTED_ARCHIVE_TAG);
        ret.setAttribute(NESTED_ARCHIVE_NAMEINARCHIVE_ATTRIBUTE, this.getPathInArchive());
        ret.setAttribute(NESTED_ARCHIVE_TEMPORAY_ATTRIBUTE, this.isTemporary() ? "true" : "false");
        Element nestedArchiveElement = ((XMLSerializable)((Object)this.arDesc)).getXMLRepresentation(doc);
        ret.appendChild(nestedArchiveElement);
        return ret;
    }
}

