/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.archive.internal.impl;

import com.tssap.tools.XMLUtil;
import com.tssap.tools.archive.IFileLocation;
import com.tssap.tools.archive.IJavaSet;
import com.tssap.tools.archive.IMutablePattern;
import com.tssap.tools.archive.Pattern;
import com.tssap.tools.archive.RelativePath;
import com.tssap.tools.archive.internal.IXMLSerializeLogger;
import com.tssap.tools.archive.internal.impl.FileLocationImpl;
import com.tssap.tools.archive.internal.impl.FileSet;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JavaSet
extends FileSet
implements IJavaSet {
    private static final String JAVASET_TAG = "JavaSet";
    private static final String JAVASET_SOURCECONTENT_TAG = "source";
    private static final String JAVASET_CLASSCONTENT_TAG = "class";
    private static final String JAVASET_LIBCONTENT_TAG = "library";
    private static final String JAVASET_PACKAGE_ATTRIBUTE = "package";
    private static final String JAVASET_LIBPATH_ATTRIBUTE = "path";
    private static final String JAVASET_PROJECT_ATTRIBUTE = "project";
    private static final int TYPE_CLASSES = 0;
    private static final int TYPE_SOURCES = 1;
    private static final int TYPE_LIB = 2;
    private ArrayList javaContent = new ArrayList();
    static /* synthetic */ Class class$com$tssap$tools$archive$internal$impl$JavaSet;

    public JavaSet() {
        super(3);
    }

    public void addClasses(IProject project, String packagge) {
        this.javaContent.add(new JavaContent(project.getName(), packagge, 0));
    }

    public void addSources(IProject project, String packagge) {
        this.javaContent.add(new JavaContent(project.getName(), packagge, 1));
    }

    public void addRequiredLib(IProject project, String libName) {
        this.javaContent.add(new JavaContent(project.getName(), libName, 2));
    }

    private void addJavaContent(JavaContent cont) {
        this.javaContent.add(cont);
    }

    public IFileLocation[] getFileLocations() {
        ArrayList<FileLocationImpl> locationList = new ArrayList<FileLocationImpl>();
        int i = 0;
        while (i < this.javaContent.size()) {
            IMutablePattern patterns;
            String basePath;
            JavaContent content = (JavaContent)this.javaContent.get(i);
            if (content.getType() == 2) {
                String path = RelativePath.getRelativePath(content.getProject(), content.getPackagge());
                basePath = RelativePath.removeLastSegment(path);
                patterns = Pattern.getPattern(new String[]{RelativePath.getLastSegment(path)}, null);
            } else {
                String patternStr;
                String patternBase = content.getPackagge().replace('.', '/');
                if (content.getType() == 0) {
                    basePath = RelativePath.getRelativePath(content.getProject(), RelativePath.CLASSES.toString());
                    patternStr = patternBase + (patternBase.endsWith("**") ? "/*.class" : ".class");
                    patterns = Pattern.getPattern(new String[]{patternStr}, null);
                } else if (content.getType() == 1) {
                    basePath = RelativePath.getRelativePath(content.getProject(), RelativePath.SOURCE.toString());
                    patternStr = patternBase + (patternBase.endsWith("**") ? "/*.java" : ".java");
                    patterns = Pattern.getPattern(new String[]{patternStr}, null);
                } else {
                    throw new RuntimeException((class$com$tssap$tools$archive$internal$impl$JavaSet == null ? (class$com$tssap$tools$archive$internal$impl$JavaSet = JavaSet.class$("com.tssap.tools.archive.internal.impl.JavaSet")) : class$com$tssap$tools$archive$internal$impl$JavaSet) + ": Unknown ContentType");
                }
            }
            FileLocationImpl loc = new FileLocationImpl(basePath, patterns, null, null, false, content.getType() == 2);
            locationList.add(loc);
            ++i;
        }
        return locationList.toArray(new IFileLocation[locationList.size()]);
    }

    public int getType() {
        return 3;
    }

    public static String getElementName() {
        return JAVASET_TAG;
    }

    public static JavaSet getInstanceFromXML(Element element, IXMLSerializeLogger log) {
        log.assertt(element.getNodeName().equals(JAVASET_TAG), "Invalid root tag for constructing JavaSet: " + element.getNodeName());
        JavaSet ret = new JavaSet();
        Element[] children = XMLUtil.getElementsFromNodeList(element.getChildNodes());
        int i = 0;
        while (i < children.length) {
            String contentTagName = children[i].getNodeName();
            log.assertt(contentTagName.equals(JAVASET_CLASSCONTENT_TAG) || contentTagName.equals(JAVASET_SOURCECONTENT_TAG) || contentTagName.equals(JAVASET_LIBCONTENT_TAG), "Invalid JavaSet subtag " + contentTagName);
            String packagge = children[i].getAttribute(JAVASET_PACKAGE_ATTRIBUTE);
            String project = children[i].getAttribute(JAVASET_PROJECT_ATTRIBUTE);
            String libPath = children[i].getAttribute(JAVASET_LIBPATH_ATTRIBUTE);
            if (contentTagName.equals(JAVASET_LIBCONTENT_TAG)) {
                log.assertt(project != null && libPath != null, "library must provide project and path attributes");
                ret.addJavaContent(ret.new JavaContent(project, libPath, 2));
            } else if (contentTagName.equals(JAVASET_CLASSCONTENT_TAG)) {
                log.assertt(project != null && packagge != null, "class must provide project and package attributes");
                ret.addJavaContent(ret.new JavaContent(project, packagge, 0));
            } else if (contentTagName.equals(JAVASET_SOURCECONTENT_TAG)) {
                log.assertt(project != null && packagge != null, "source must provide project and package attributes");
                ret.addJavaContent(ret.new JavaContent(project, packagge, 1));
            }
            ++i;
        }
        return ret;
    }

    public Element getXMLRepresentation(Document doc) {
        Element ret = doc.createElement(JAVASET_TAG);
        ArrayList<Element> contentList = new ArrayList<Element>();
        int i = 0;
        while (i < this.javaContent.size()) {
            Element el;
            JavaContent content = (JavaContent)this.javaContent.get(i);
            if (content.getType() == 2) {
                el = doc.createElement(JAVASET_LIBCONTENT_TAG);
                el.setAttribute(JAVASET_PROJECT_ATTRIBUTE, content.getProject());
                el.setAttribute(JAVASET_LIBPATH_ATTRIBUTE, content.getPackagge());
            } else if (content.getType() == 0) {
                el = doc.createElement(JAVASET_CLASSCONTENT_TAG);
                el.setAttribute(JAVASET_PROJECT_ATTRIBUTE, content.getProject());
                el.setAttribute(JAVASET_PACKAGE_ATTRIBUTE, content.getPackagge());
            } else if (content.getType() == 1) {
                el = doc.createElement(JAVASET_SOURCECONTENT_TAG);
                el.setAttribute(JAVASET_PROJECT_ATTRIBUTE, content.getProject());
                el.setAttribute(JAVASET_PACKAGE_ATTRIBUTE, content.getPackagge());
            } else {
                throw new RuntimeException((class$com$tssap$tools$archive$internal$impl$JavaSet == null ? (class$com$tssap$tools$archive$internal$impl$JavaSet = JavaSet.class$("com.tssap.tools.archive.internal.impl.JavaSet")) : class$com$tssap$tools$archive$internal$impl$JavaSet) + ": Unknown ContentType");
            }
            contentList.add(el);
            ++i;
        }
        int i2 = 0;
        while (i2 < contentList.size()) {
            ret.appendChild((Element)contentList.get(i2));
            ++i2;
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class JavaContent {
        private String project;
        private String packagge;
        private int type;

        JavaContent(String project, String packagge, int type) {
            this.project = project;
            this.packagge = packagge;
            this.type = type;
        }

        public String getPackagge() {
            return this.packagge;
        }

        public String getProject() {
            return this.project;
        }

        public int getType() {
            return this.type;
        }
    }
}

