/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.archive.internal.impl;

import com.tssap.tools.archive.ArchiveBuildException;
import com.tssap.tools.archive.IFileLocation;
import com.tssap.tools.archive.IFileSet;
import com.tssap.tools.archive.Pattern;
import com.tssap.tools.archive.RelativePath;
import com.tssap.tools.archive.internal.IArchiveContentSupplier;
import com.tssap.tools.archive.internal.INestedArchiveDescriptor;
import com.tssap.tools.archive.internal.impl.Archive;
import com.tssap.tools.archive.internal.impl.ContentNameBind;
import com.tssap.tools.archive.internal.impl.FileLocationImpl;
import com.tssap.tools.archive.internal.impl.FileLocationSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public abstract class FileContainDescriptor
extends Archive
implements IArchiveContentSupplier {
    private static final INestedArchiveDescriptor[] EMPTY_NESTED_ARCHIVE = new INestedArchiveDescriptor[0];
    private List fileList = new ArrayList();
    private List fileSetList = new ArrayList();

    public abstract void performBuild() throws ArchiveBuildException;

    public void addFile(IFile file, String fileLocation) {
        this.fileList.add(new ContentNameBind(RelativePath.getRelativePath((IResource)file), fileLocation, 6));
    }

    public void addFileSet(IFileSet fileSet) {
        this.fileSetList.add(fileSet);
    }

    public IFileLocation[] getFileLocations() {
        ArrayList<IFileLocation> locations = new ArrayList<IFileLocation>();
        IFileSet[] sets = this.getFileSets();
        int i = 0;
        while (i < sets.length) {
            locations.addAll(Arrays.asList(sets[i].getFileLocations()));
            ++i;
        }
        return locations.toArray(new IFileLocation[locations.size()]);
    }

    protected IFileSet[] getFileSets() {
        ArrayList<FileLocationSet> ret = new ArrayList<FileLocationSet>();
        ret.addAll(this.fileSetList);
        FileLocationSet fileSet = new FileLocationSet();
        int i = 0;
        while (i < this.fileList.size()) {
            String jarFilePath = ((ContentNameBind)this.fileList.get(i)).getRelFilePath();
            String nameInArchive = ((ContentNameBind)this.fileList.get(i)).getLocation();
            fileSet.addFileLocation(new FileLocationImpl(RelativePath.removeLastSegment(jarFilePath), Pattern.getPattern(new String[]{RelativePath.getLastSegment(jarFilePath)}, null), null, nameInArchive, false, true));
            ++i;
        }
        ret.add(fileSet);
        return ret.toArray(new IFileSet[ret.size()]);
    }

    public INestedArchiveDescriptor[] getNestedArchives() {
        return EMPTY_NESTED_ARCHIVE;
    }
}

