/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.archive.internal.impl;

import com.tssap.tools.archive.ArchiveDescriptionManager;
import com.tssap.tools.archive.IArchive;
import com.tssap.tools.archive.IArchiveDescriptor;
import com.tssap.tools.archive.IEjbJarDescriptor;
import com.tssap.tools.archive.IFileLocation;
import com.tssap.tools.archive.IFileSet;
import com.tssap.tools.archive.Pattern;
import com.tssap.tools.archive.RelativePath;
import com.tssap.tools.archive.internal.INestedArchiveDescriptor;
import com.tssap.tools.archive.internal.impl.ComponentBuildInfo;
import com.tssap.tools.archive.internal.impl.ContentNameBind;
import com.tssap.tools.archive.internal.impl.FileContainDescriptor;
import com.tssap.tools.archive.internal.impl.FileLocationImpl;
import com.tssap.tools.archive.internal.impl.FileLocationSet;
import com.tssap.tools.archive.internal.impl.NestedArchive;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class EjbJarDescriptor
extends FileContainDescriptor
implements IEjbJarDescriptor {
    private static final String DESCR_FILE_AR_LOCATION = "META-INF/ejb-jar.xml";
    private static final String WEB_SERVICE_DD_FILE__PATH = "META-INF/ws-deployment-descriptor.xml";
    private ArrayList ejbFileSets = new ArrayList();
    private ArrayList javaSourcesFileSets = new ArrayList();
    private ArrayList jarArchives = new ArrayList();
    private ArrayList jarFiles = new ArrayList();
    private String ejbJarDescriptor;
    private String webServiceDeployDescr;

    public EjbJarDescriptor() {
        this.setComponentBuildInfo(ComponentBuildInfo.createDefaultEJBJarCBI());
    }

    public boolean isUseComponentBuild() {
        return true;
    }

    public void performBuild() {
        IArchiveDescriptor arDesc = ArchiveDescriptionManager.newArchiveDescription();
        arDesc.setDestPath(this.getDestPath());
        arDesc.setCompressed(this.isCompressed());
        IFileSet[] fs = this.getAllContainedFileSets();
        INestedArchiveDescriptor[] ns = this.getNestedArchives();
        int i = 0;
        while (i < fs.length) {
            arDesc.addFileSet(fs[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < ns.length) {
            arDesc.addNestedArchive(ns[i2].getArchiveDescriptor(), ns[i2].isTemporary(), ns[i2].getPathInArchive());
            ++i2;
        }
        arDesc.setComponentBuildInfo(this.getComponentBuildInfo());
        arDesc.performBuild();
    }

    public void addEjb(IFileSet ejb) {
        this.ejbFileSets.add(ejb);
    }

    public void addEjbs(IFileSet[] ejb) {
        int i = 0;
        while (i < ejb.length) {
            this.addEjb(ejb[i]);
            ++i;
        }
    }

    public void addJar(IArchive jar, String fileLocation) {
        this.jarArchives.add(new ContentNameBind(jar, true, fileLocation, 0));
    }

    public void addJar(IFile jar, String fileLocation) {
        this.jarFiles.add(new ContentNameBind(RelativePath.getRelativePath((IResource)jar), fileLocation, 0));
    }

    public void addJavaSources(IFileSet files) {
        this.javaSourcesFileSets.add(files);
    }

    public void setEjbJarDescriptor(IFile file) {
        this.ejbJarDescriptor = RelativePath.getRelativePath((IResource)file);
    }

    public void setWebServiceDeploymentDescriptor(IFile ws) {
        this.webServiceDeployDescr = RelativePath.getRelativePath((IResource)ws);
    }

    public IFileLocation[] getFileLocations() {
        IFileSet[] fileSets = this.getAllContainedFileSets();
        ArrayList<IFileLocation> allLocations = new ArrayList<IFileLocation>();
        allLocations.addAll(Arrays.asList(super.getFileLocations()));
        int i = 0;
        while (i < fileSets.length) {
            IFileLocation[] fileLocations = fileSets[i].getFileLocations();
            int j = 0;
            while (j < fileLocations.length) {
                allLocations.add(fileLocations[j]);
                ++j;
            }
            ++i;
        }
        return allLocations.toArray(new IFileLocation[allLocations.size()]);
    }

    private IFileSet[] getAllContainedFileSets() {
        FileLocationSet fileLocSet;
        ArrayList<IFileSet> allSets = new ArrayList<IFileSet>();
        allSets.addAll(Arrays.asList(super.getFileSets()));
        int i = 0;
        while (i < this.ejbFileSets.size()) {
            allSets.add((IFileSet)this.ejbFileSets.get(i));
            ++i;
        }
        int i2 = 0;
        while (i2 < this.javaSourcesFileSets.size()) {
            allSets.add((IFileSet)this.javaSourcesFileSets.get(i2));
            ++i2;
        }
        FileLocationSet jarFileSet = new FileLocationSet();
        int i3 = 0;
        while (i3 < this.jarFiles.size()) {
            String jarFilePath = ((ContentNameBind)this.jarFiles.get(i3)).getRelFilePath();
            String nameInArchive = ((ContentNameBind)this.jarFiles.get(i3)).getLocation();
            jarFileSet.addFileLocation(new FileLocationImpl(RelativePath.removeLastSegment(jarFilePath), Pattern.getPattern(new String[]{RelativePath.getLastSegment(jarFilePath)}, null), null, nameInArchive, false, true));
            ++i3;
        }
        allSets.add(jarFileSet);
        if (this.ejbJarDescriptor != null && this.ejbJarDescriptor.length() > 0) {
            fileLocSet = new FileLocationSet();
            fileLocSet.addFileLocation(new FileLocationImpl(RelativePath.removeLastSegment(this.ejbJarDescriptor), Pattern.getPattern(new String[]{RelativePath.getLastSegment(this.ejbJarDescriptor)}, null), null, DESCR_FILE_AR_LOCATION, false, true));
            allSets.add(fileLocSet);
        }
        if (this.webServiceDeployDescr != null && this.webServiceDeployDescr.length() > 0) {
            fileLocSet = new FileLocationSet();
            fileLocSet.addFileLocation(new FileLocationImpl(RelativePath.removeLastSegment(this.webServiceDeployDescr), Pattern.getPattern(new String[]{RelativePath.getLastSegment(this.webServiceDeployDescr)}, null), null, WEB_SERVICE_DD_FILE__PATH, false, true));
            allSets.add(fileLocSet);
        }
        return allSets.toArray(new IFileSet[allSets.size()]);
    }

    public INestedArchiveDescriptor[] getNestedArchives() {
        INestedArchiveDescriptor[] nestedAr = new INestedArchiveDescriptor[this.jarArchives.size()];
        int i = 0;
        while (i < this.jarArchives.size()) {
            IArchive ar = ((ContentNameBind)this.jarArchives.get(i)).getArchive();
            String nameInArchive = ((ContentNameBind)this.jarArchives.get(i)).getLocation();
            nestedAr[i] = new NestedArchive(ar, true, nameInArchive);
            ++i;
        }
        return nestedAr;
    }
}

