/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.archive.internal.impl;

import com.tssap.tools.archive.ArchiveDescriptionManager;
import com.tssap.tools.archive.IArchive;
import com.tssap.tools.archive.IArchiveDescriptor;
import com.tssap.tools.archive.IEarDescriptor;
import com.tssap.tools.archive.IFileLocation;
import com.tssap.tools.archive.IFileSet;
import com.tssap.tools.archive.Pattern;
import com.tssap.tools.archive.RelativePath;
import com.tssap.tools.archive.internal.INestedArchiveDescriptor;
import com.tssap.tools.archive.internal.impl.ComponentBuildInfo;
import com.tssap.tools.archive.internal.impl.ContentNameBind;
import com.tssap.tools.archive.internal.impl.FileContainDescriptor;
import com.tssap.tools.archive.internal.impl.FileLocationImpl;
import com.tssap.tools.archive.internal.impl.FileLocationSet;
import com.tssap.tools.archive.internal.impl.NestedArchive;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class EarDescriptor
extends FileContainDescriptor
implements IEarDescriptor {
    private static final String DESCRIPTION_FILE__PATH = "META-INF/application.xml";
    private ArrayList content = new ArrayList();
    private String descrFile;

    public EarDescriptor() {
        this.setComponentBuildInfo(ComponentBuildInfo.createDefaultEarCBI());
    }

    public boolean isUseComponentBuild() {
        return true;
    }

    public void performBuild() {
        IArchiveDescriptor arDesc = ArchiveDescriptionManager.newArchiveDescription();
        arDesc.setDestPath(this.getDestPath());
        arDesc.setCompressed(this.isCompressed());
        IFileSet[] fs = this.getAllContainedFileSets();
        INestedArchiveDescriptor[] ns = this.getNestedArchives();
        int i = 0;
        while (i < fs.length) {
            arDesc.addFileSet(fs[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < ns.length) {
            arDesc.addNestedArchive(ns[i2].getArchiveDescriptor(), ns[i2].isTemporary(), ns[i2].getPathInArchive());
            ++i2;
        }
        arDesc.setComponentBuildInfo(this.getComponentBuildInfo());
        arDesc.performBuild();
    }

    public void addClientModule(IArchive war, String fileLocation, boolean buildTemporay) {
        this.content.add(new ContentNameBind(war, buildTemporay, fileLocation, 3));
    }

    public void addClientModule(IFile war, String fileLocation) {
        this.content.add(new ContentNameBind(RelativePath.getRelativePath((IResource)war), fileLocation, 3));
    }

    public void addResourceAdapterModule(IArchive war, String fileLocation, boolean buildTemporay) {
        this.content.add(new ContentNameBind(war, buildTemporay, fileLocation, 4));
    }

    public void addResourceAdapterModule(IFile war, String fileLocation) {
        this.content.add(new ContentNameBind(RelativePath.getRelativePath((IResource)war), fileLocation, 4));
    }

    public void addWar(IArchive war, String fileLocation, boolean buildTemporay) {
        this.content.add(new ContentNameBind(war, buildTemporay, fileLocation, 1));
    }

    public void addWar(IFile war, String fileLocation) {
        this.content.add(new ContentNameBind(RelativePath.getRelativePath((IResource)war), fileLocation, 1));
    }

    public void addEjbJar(IArchive ejbjar, String fileLocation, boolean buildTemporay) {
        this.content.add(new ContentNameBind(ejbjar, buildTemporay, fileLocation, 2));
    }

    public void addEjbJar(IFile ejbJar, String fileLocation) {
        this.content.add(new ContentNameBind(RelativePath.getRelativePath((IResource)ejbJar), fileLocation, 2));
    }

    public void addJar(IArchive jar, String fileLocation, boolean buildTemporay) {
        this.content.add(new ContentNameBind(jar, buildTemporay, fileLocation, 0));
    }

    public void addJar(IFile jar, String fileLocation) {
        this.content.add(new ContentNameBind(RelativePath.getRelativePath((IResource)jar), fileLocation, 0));
    }

    public void setEarDescriptor(IFile file) {
        this.descrFile = RelativePath.getRelativePath((IResource)file);
    }

    public IFileLocation[] getFileLocations() {
        IFileSet[] fileSets = this.getAllContainedFileSets();
        ArrayList<IFileLocation> allLocations = new ArrayList<IFileLocation>();
        allLocations.addAll(Arrays.asList(super.getFileLocations()));
        int i = 0;
        while (i < fileSets.length) {
            IFileLocation[] fileLocations = fileSets[i].getFileLocations();
            int j = 0;
            while (j < fileLocations.length) {
                allLocations.add(fileLocations[j]);
                ++j;
            }
            ++i;
        }
        return allLocations.toArray(new IFileLocation[allLocations.size()]);
    }

    private IFileSet[] getAllContainedFileSets() {
        ArrayList<IFileSet> allSets = new ArrayList<IFileSet>();
        allSets.addAll(Arrays.asList(super.getFileSets()));
        FileLocationSet contentFileSet = new FileLocationSet();
        int i = 0;
        while (i < this.content.size()) {
            ContentNameBind con = (ContentNameBind)this.content.get(i);
            if (con.getContentType() == 1) {
                String filePath = ((ContentNameBind)this.content.get(i)).getRelFilePath();
                String nameInArchive = ((ContentNameBind)this.content.get(i)).getLocation();
                contentFileSet.addFileLocation(new FileLocationImpl(RelativePath.removeLastSegment(filePath), Pattern.getPattern(new String[]{RelativePath.getLastSegment(filePath)}, null), null, nameInArchive, false, true));
            }
            ++i;
        }
        allSets.add(contentFileSet);
        if (this.descrFile != null && this.descrFile.length() > 0) {
            FileLocationSet fileLocSet = new FileLocationSet();
            fileLocSet.addFileLocation(new FileLocationImpl(RelativePath.removeLastSegment(this.descrFile), Pattern.getPattern(new String[]{RelativePath.getLastSegment(this.descrFile)}, null), null, DESCRIPTION_FILE__PATH, false, true));
            allSets.add(fileLocSet);
        }
        return allSets.toArray(new IFileSet[allSets.size()]);
    }

    public INestedArchiveDescriptor[] getNestedArchives() {
        ArrayList<NestedArchive> nestedAr = new ArrayList<NestedArchive>();
        int i = 0;
        while (i < this.content.size()) {
            ContentNameBind con = (ContentNameBind)this.content.get(i);
            if (con.getContentType() == 0) {
                IArchive ar = ((ContentNameBind)this.content.get(i)).getArchive();
                String nameInArchive = ((ContentNameBind)this.content.get(i)).getLocation();
                boolean buildTmp = ((ContentNameBind)this.content.get(i)).isArchiveTemporary();
                nestedAr.add(new NestedArchive(ar, buildTmp, nameInArchive));
            }
            ++i;
        }
        return nestedAr.toArray(new INestedArchiveDescriptor[nestedAr.size()]);
    }
}

