/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.archive.internal.impl;

import com.tssap.tools.archive.IArchive;
import com.tssap.tools.archive.RelativePath;
import java.io.File;

public class ContentNameBind {
    public static final int TYPE_ARCHIVE = 0;
    public static final int TYPE_FILE = 1;
    public static final int SEMANTIC_JAR = 0;
    public static final int SEMANTIC_WAR = 1;
    public static final int SEMANTIC_EJBJAR = 2;
    public static final int SEMANTIC_CLIENT_MODULE = 3;
    public static final int SEMANTIC_RA_MODULE = 4;
    public static final int SEMANTIC_SSLIB = 5;
    public static final int SEMANTIC_FILE = 6;
    private IArchive archive;
    private String relFilePath;
    private String location;
    private boolean isArchiveTemporary;
    private int contentType;
    private int semanticType;

    ContentNameBind(String relFilePath, String location, int semanticType) {
        this.relFilePath = relFilePath;
        this.semanticType = semanticType;
        this.location = location != null && location.length() > 0 ? location : RelativePath.getLastSegment(relFilePath);
        this.contentType = 1;
    }

    ContentNameBind(IArchive archive, boolean isArchiveTemporary, String location, int semanticType) {
        this.archive = archive;
        this.semanticType = semanticType;
        if (location != null && location.length() > 0) {
            this.location = location;
        } else {
            File f = new File(archive.getDestPath());
            this.location = f.getName();
        }
        this.contentType = 0;
        this.isArchiveTemporary = isArchiveTemporary;
    }

    public IArchive getArchive() {
        return this.archive;
    }

    public boolean isArchiveTemporary() {
        return this.isArchiveTemporary;
    }

    public String getRelFilePath() {
        return this.relFilePath;
    }

    public int getContentType() {
        return this.contentType;
    }

    public int getSemanticType() {
        return this.semanticType;
    }

    public String getLocation() {
        return this.location;
    }
}

