/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.archive.internal.impl;

import com.tssap.tools.XMLUtil;
import com.tssap.tools.archive.IArchiveSet;
import com.tssap.tools.archive.IFileLocation;
import com.tssap.tools.archive.IPattern;
import com.tssap.tools.archive.internal.IXMLSerializeLogger;
import com.tssap.tools.archive.internal.PatternBase;
import com.tssap.tools.archive.internal.XMLSerializable;
import com.tssap.tools.archive.internal.impl.FileLocationImpl;
import com.tssap.tools.archive.internal.impl.FileSet;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ArchiveSet
extends FileSet
implements IArchiveSet {
    private static final String ARCHIVE_FILESET_TAG = "ArchiveSet";
    private static final String ARSET_CONTENT_TAG = "fromArchive";
    private static final String ARSET_ARCHIVEPATH_ATTRIBUTE = "path";
    private static final String ARSET_PRIFIX_ATTRIBUTE = "prefix";
    private ArrayList archives = new ArrayList();

    public ArchiveSet() {
        super(2);
    }

    public IFileLocation[] getFileLocations() {
        IFileLocation[] locations = new IFileLocation[this.archives.size()];
        int i = 0;
        while (i < this.archives.size()) {
            ArchiveFolder arFolder = (ArchiveFolder)this.archives.get(i);
            locations[i] = new FileLocationImpl(arFolder.getArchivePath(), arFolder.getPattern(), arFolder.getPrefix(), null, true, false);
            ++i;
        }
        return locations;
    }

    public void addFromArchive(String archivePath, IPattern pattern) {
        this.addFromArchive(archivePath, pattern, null);
    }

    public void addFromArchive(String archivePath, IPattern pattern, String prefix) {
        this.archives.add(new ArchiveFolder(archivePath, prefix, pattern));
    }

    public void fillFromXMLContent(Element[] xmlElementContent) {
        throw new RuntimeException("Not supported");
    }

    public static String getElementName() {
        return ARCHIVE_FILESET_TAG;
    }

    public static ArchiveSet getInstanceFromXML(Element element, IXMLSerializeLogger log) {
        log.assertt(element.getNodeName().equals(ARCHIVE_FILESET_TAG), "Invalid root tag for constructing ArchiveSet: " + element.getNodeName());
        ArchiveSet ret = new ArchiveSet();
        Element[] children = XMLUtil.getElementsFromNodeList(element.getChildNodes());
        int i = 0;
        while (i < children.length) {
            log.assertt(children[i].getNodeName().equals(ARSET_CONTENT_TAG), "Invalid ArchiveSet subtag " + children[i].getNodeName());
            String arPath = children[i].getAttribute(ARSET_ARCHIVEPATH_ATTRIBUTE);
            String prefix = children[i].getAttribute(ARSET_PRIFIX_ATTRIBUTE);
            log.assertt(arPath.length() > 0, "Archive path must be qualified in archive set content tag");
            Element[] patChild = XMLUtil.getElementsFromNodeList(children[i].getChildNodes());
            log.assertt(patChild.length <= 1, "Only one pattern sub tag allowed in one archive content");
            IPattern pat = PatternBase.getInstanceFromXML(patChild[0], log);
            ret.addFromArchive(arPath, pat, prefix);
            ++i;
        }
        return ret;
    }

    public Element getXMLRepresentation(Document doc) {
        Element ret = doc.createElement(ARCHIVE_FILESET_TAG);
        ArrayList<Element> contentList = new ArrayList<Element>();
        int i = 0;
        while (i < this.archives.size()) {
            ArchiveFolder f = (ArchiveFolder)this.archives.get(i);
            Element el = doc.createElement(ARSET_CONTENT_TAG);
            el.setAttribute(ARSET_ARCHIVEPATH_ATTRIBUTE, f.getArchivePath());
            if (f.getPrefix() != null) {
                el.setAttribute(ARSET_PRIFIX_ATTRIBUTE, f.getPrefix());
            }
            el.appendChild(((XMLSerializable)((Object)f.getPattern())).getXMLRepresentation(doc));
            contentList.add(el);
            ++i;
        }
        int i2 = 0;
        while (i2 < contentList.size()) {
            ret.appendChild((Element)contentList.get(i2));
            ++i2;
        }
        return ret;
    }

    class ArchiveFolder {
        private String archivePath;
        private String prefix;
        private IPattern pattern;

        ArchiveFolder(String archivePath, String prefix, IPattern pattern) {
            this.archivePath = archivePath;
            this.prefix = prefix;
            this.pattern = pattern;
        }

        public String getArchivePath() {
            return this.archivePath;
        }

        public IPattern getPattern() {
            return this.pattern;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

