/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.archive.internal.impl;

import com.tssap.tools.XMLUtil;
import com.tssap.tools.archive.ArchiveBuilder;
import com.tssap.tools.archive.IArchive;
import com.tssap.tools.archive.IArchiveDescriptor;
import com.tssap.tools.archive.IFileLocation;
import com.tssap.tools.archive.IFileSet;
import com.tssap.tools.archive.internal.AntArOnTheFlyTransformer;
import com.tssap.tools.archive.internal.IArchiveContentSupplier;
import com.tssap.tools.archive.internal.INestedArchiveDescriptor;
import com.tssap.tools.archive.internal.IXMLSerializeLogger;
import com.tssap.tools.archive.internal.PathTransformer;
import com.tssap.tools.archive.internal.XMLSerializable;
import com.tssap.tools.archive.internal.impl.AbsoluteFileSet;
import com.tssap.tools.archive.internal.impl.Archive;
import com.tssap.tools.archive.internal.impl.ArchiveSet;
import com.tssap.tools.archive.internal.impl.JavaSet;
import com.tssap.tools.archive.internal.impl.NestedArchive;
import com.tssap.tools.archive.internal.impl.ProjectFileSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ArchiveDescriptor
extends Archive
implements IArchiveDescriptor,
XMLSerializable,
IArchiveContentSupplier {
    private static final String ARCHIVE_TAG = "Archive";
    private static final String ARCHIVE_COMPRESSED_ATTRIBUTE = "compressed";
    private static final String ARCHIVE_DESTPATH_ATTRIBUTE = "name";
    private ArrayList myFileSets;
    private ArrayList myNestedArchives = new ArrayList();

    public ArchiveDescriptor() {
        this.myFileSets = new ArrayList();
    }

    public void addFileSet(IFileSet fileSet) {
        this.myFileSets.add(fileSet);
    }

    public void addNestedArchive(IArchive arDescr, boolean isTemporary, String pathInArchive) {
        NestedArchive nestedAr = new NestedArchive(arDescr, isTemporary, pathInArchive);
        this.myNestedArchives.add(nestedAr);
    }

    public void performBuild() {
        AntArOnTheFlyTransformer antArDesc = new AntArOnTheFlyTransformer(new NestedArchive(this, false, null), PathTransformer.translateSingleRelPath(this.getDestPath()), 0);
        ArchiveBuilder.buildArchive(antArDesc);
    }

    public IFileLocation[] getFileLocations() {
        ArrayList<IFileLocation> allLocations = new ArrayList<IFileLocation>();
        int i = 0;
        while (i < this.myFileSets.size()) {
            allLocations.addAll(Arrays.asList(((IFileSet)this.myFileSets.get(i)).getFileLocations()));
            ++i;
        }
        return allLocations.toArray(new IFileLocation[allLocations.size()]);
    }

    public IFileSet[] getFileSets() {
        return this.myFileSets.toArray(new IFileSet[this.myFileSets.size()]);
    }

    public INestedArchiveDescriptor[] getNestedArchives() {
        return this.myNestedArchives.toArray(new INestedArchiveDescriptor[this.myNestedArchives.size()]);
    }

    public String getElementName() {
        return ARCHIVE_TAG;
    }

    public static ArchiveDescriptor getInstanceFromXML(Element element, IXMLSerializeLogger log) {
        ArchiveDescriptor ret = new ArchiveDescriptor();
        log.assertt(element.getNodeName().equals(ARCHIVE_TAG), "Invalid root tag for constructing IArchiveDescriptor: " + element.getNodeName());
        String compressedStr = element.getAttribute(ARCHIVE_COMPRESSED_ATTRIBUTE);
        String destPath = element.getAttribute(ARCHIVE_DESTPATH_ATTRIBUTE);
        ret.setDestPath(destPath);
        ret.setCompressed(Boolean.valueOf(compressedStr));
        HashMap<String, Integer> possibleSubtags = new HashMap<String, Integer>();
        possibleSubtags.put(AbsoluteFileSet.getElementName(), new Integer(0));
        possibleSubtags.put(ProjectFileSet.getElementName(), new Integer(1));
        possibleSubtags.put(ArchiveSet.getElementName(), new Integer(2));
        possibleSubtags.put(JavaSet.getElementName(), new Integer(3));
        possibleSubtags.put(NestedArchive.getElementName(), new Integer(4));
        Element[] subtags = XMLUtil.getElementsFromNodeList(element.getChildNodes());
        int i = 0;
        while (i < subtags.length) {
            int subType = (Integer)possibleSubtags.get(subtags[i].getNodeName());
            switch (subType) {
                case 0: {
                    ret.addFileSet(AbsoluteFileSet.getInstanceFromXML(subtags[i], log));
                    break;
                }
                case 1: {
                    ret.addFileSet(ProjectFileSet.getInstanceFromXML(subtags[i], log));
                    break;
                }
                case 2: {
                    ret.addFileSet(ArchiveSet.getInstanceFromXML(subtags[i], log));
                    break;
                }
                case 3: {
                    ret.addFileSet(JavaSet.getInstanceFromXML(subtags[i], log));
                    break;
                }
                case 4: {
                    NestedArchive nestedAr = NestedArchive.getInstanceFromXML(subtags[i], log);
                    ret.addNestedArchive(nestedAr.getArchiveDescriptor(), nestedAr.isTemporary(), nestedAr.getPathInArchive());
                    break;
                }
            }
            ++i;
        }
        return ret;
    }

    public Element getXMLRepresentation(Document doc) {
        Element ret = doc.createElement(ARCHIVE_TAG);
        ret.setAttribute(ARCHIVE_DESTPATH_ATTRIBUTE, this.getDestPath());
        ret.setAttribute(ARCHIVE_COMPRESSED_ATTRIBUTE, this.isCompressed() ? "true" : "false");
        int i = 0;
        while (i < this.myFileSets.size()) {
            Element el = ((XMLSerializable)this.myFileSets.get(i)).getXMLRepresentation(doc);
            ret.appendChild(el);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.myNestedArchives.size()) {
            Element el = ((XMLSerializable)this.myNestedArchives.get(i2)).getXMLRepresentation(doc);
            ret.appendChild(el);
            ++i2;
        }
        return ret;
    }
}

