/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.archive.internal.impl;

import com.tssap.tools.XMLUtil;
import com.tssap.tools.archive.IAbsoluteFileSet;
import com.tssap.tools.archive.IFileLocation;
import com.tssap.tools.archive.IPattern;
import com.tssap.tools.archive.Pattern;
import com.tssap.tools.archive.internal.IXMLSerializeLogger;
import com.tssap.tools.archive.internal.PatternBase;
import com.tssap.tools.archive.internal.XMLSerializable;
import com.tssap.tools.archive.internal.impl.FileLocationImpl;
import com.tssap.tools.archive.internal.impl.FileSet;
import java.io.File;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AbsoluteFileSet
extends FileSet
implements IAbsoluteFileSet {
    private static final String ABSOLUTE_FILESET_TAG = "AbsoluteFiles";
    private static final String ABSOLUTE_FILECONTENT_TAG = "file";
    private static final String ABSOLUTE_FOLDERCONTENT_TAG = "folder";
    private static final String ABSOLUTE_CONTENTPATH_ATTRIBUTE = "name";
    private static final String ABSOLUTE_CONTENTPREFIX_ATTRIBUTE = "prefix";
    private static final String ABSOLUTE_CONTENTNAMEINARCHIVE_ATTRIBUTE = "nameInArchive";
    private ArrayList files = new ArrayList();
    private ArrayList folders = new ArrayList();

    public AbsoluteFileSet() {
        super(0);
    }

    public void addAbsoluteFile(File file, String nameInArchive) {
        this.files.add(new AbsFile(file, nameInArchive));
    }

    public void addAbsoluteFile(File f) {
        this.addAbsoluteFile(f, f.getName());
    }

    public void addAbsoluteFiles(File folder, IPattern pattern, String prefix) {
        this.folders.add(new AbsFolder(folder, prefix, pattern));
    }

    public void addAbsoluteFiles(File folder, IPattern pattern) {
        this.addAbsoluteFiles(folder, pattern, null);
    }

    public void addAbsoluteFiles(File folder) {
        this.addAbsoluteFiles(folder, Pattern.getPattern(3), null);
    }

    public IFileLocation[] getFileLocations() {
        ArrayList<FileLocationImpl> locationList = new ArrayList<FileLocationImpl>();
        int i = 0;
        while (i < this.files.size()) {
            AbsFile f = (AbsFile)this.files.get(i);
            FileLocationImpl loc = new FileLocationImpl(f.getFile().getAbsoluteFile().getParent(), Pattern.getPattern(new String[]{f.getFile().getName()}, null), null, f.getNameInArchive(), false, true);
            locationList.add(loc);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.folders.size()) {
            AbsFolder f = (AbsFolder)this.folders.get(i2);
            FileLocationImpl loc = new FileLocationImpl(f.getFolder().getAbsoluteFile().getAbsolutePath(), f.getPattern(), f.getPrefix(), null, false, false);
            locationList.add(loc);
            ++i2;
        }
        return locationList.toArray(new IFileLocation[locationList.size()]);
    }

    public static String getElementName() {
        return ABSOLUTE_FILESET_TAG;
    }

    public static AbsoluteFileSet getInstanceFromXML(Element element, IXMLSerializeLogger log) {
        log.assertt(element.getNodeName().equals(ABSOLUTE_FILESET_TAG), "Invalid root tag for constructing AbsoluteFileSet: " + element.getNodeName());
        AbsoluteFileSet ret = new AbsoluteFileSet();
        Element[] children = XMLUtil.getElementsFromNodeList(element.getChildNodes());
        int i = 0;
        while (i < children.length) {
            log.assertt(children[i].getNodeName().equals(ABSOLUTE_FOLDERCONTENT_TAG) || children[i].getNodeName().equals(ABSOLUTE_FILECONTENT_TAG), "Invalid AbsoluteFileSet subtag " + children[i].getNodeName());
            String arPath = children[i].getAttribute(ABSOLUTE_CONTENTPATH_ATTRIBUTE);
            log.assertt(arPath.length() > 0, "Archive path must be qualified in absolue file set content tag");
            if (children[i].getNodeName().equals(ABSOLUTE_FOLDERCONTENT_TAG)) {
                String prefix = children[i].getAttribute(ABSOLUTE_CONTENTPREFIX_ATTRIBUTE);
                Element[] patChild = XMLUtil.getElementsFromNodeList(children[i].getChildNodes());
                log.assertt(patChild.length <= 1, "Only one pattern sub tag allowed in one absolute file content");
                IPattern pat = null;
                if (patChild.length == 1) {
                    pat = PatternBase.getInstanceFromXML(patChild[0], log);
                }
                AbsFolder absFolder = ret.new AbsFolder(new File(arPath), prefix.length() > 0 ? prefix : null, pat);
                ret.addAbsFolder(absFolder);
            } else {
                String nameInArchive = children[i].getAttribute(ABSOLUTE_CONTENTNAMEINARCHIVE_ATTRIBUTE);
                AbsFile absFile = ret.new AbsFile(new File(arPath), nameInArchive);
                ret.addAbsFile(absFile);
            }
            ++i;
        }
        return ret;
    }

    private void addAbsFile(AbsFile absFile) {
        this.files.add(absFile);
    }

    private void addAbsFolder(AbsFolder absFolder) {
        this.folders.add(absFolder);
    }

    public Element getXMLRepresentation(Document doc) {
        Element ret = doc.createElement(ABSOLUTE_FILESET_TAG);
        ArrayList<Element> contentList = new ArrayList<Element>();
        int i = 0;
        while (i < this.files.size()) {
            AbsFile f = (AbsFile)this.files.get(i);
            Element el = doc.createElement(ABSOLUTE_FILECONTENT_TAG);
            el.setAttribute(ABSOLUTE_CONTENTPATH_ATTRIBUTE, f.getFile().getAbsolutePath());
            if (f.getNameInArchive() != null) {
                el.setAttribute(ABSOLUTE_CONTENTNAMEINARCHIVE_ATTRIBUTE, f.getNameInArchive());
            }
            contentList.add(el);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.folders.size()) {
            AbsFolder f = (AbsFolder)this.folders.get(i2);
            Element el = doc.createElement(ABSOLUTE_FOLDERCONTENT_TAG);
            el.setAttribute(ABSOLUTE_CONTENTPATH_ATTRIBUTE, f.getFolder().getAbsolutePath());
            if (f.getPrefix() != null) {
                el.setAttribute(ABSOLUTE_CONTENTPREFIX_ATTRIBUTE, f.getPrefix());
            }
            el.appendChild(((XMLSerializable)((Object)f.getPattern())).getXMLRepresentation(doc));
            contentList.add(el);
            ++i2;
        }
        int i3 = 0;
        while (i3 < contentList.size()) {
            ret.appendChild((Element)contentList.get(i3));
            ++i3;
        }
        return ret;
    }

    class AbsFolder {
        private File folder;
        private String prefix;
        private IPattern pattern;

        AbsFolder(File folder, String prefix, IPattern pattern) {
            this.folder = folder;
            this.prefix = prefix;
            this.pattern = pattern;
        }

        public File getFolder() {
            return this.folder;
        }

        public IPattern getPattern() {
            return this.pattern;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }

    class AbsFile {
        private File file;
        private String nameInArchive;

        AbsFile(File file, String nameInArchive) {
            this.file = file;
            this.nameInArchive = nameInArchive;
        }

        public String getNameInArchive() {
            return this.nameInArchive;
        }

        public File getFile() {
            return this.file;
        }
    }
}

