/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.archive.internal;

import com.tssap.tools.XMLUtil;
import com.tssap.tools.archive.IMutablePattern;
import com.tssap.tools.archive.IPattern;
import com.tssap.tools.archive.internal.IXMLSerializeLogger;
import com.tssap.tools.archive.internal.PatternBase;
import com.tssap.tools.archive.internal.XMLSerializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PatternRecord
extends PatternBase
implements IMutablePattern,
XMLSerializable {
    static final String PATTERNMUTABLE_TAG = "Pattern";
    private static final String PATTERN_INCLUDE_TAG = "include";
    private static final String PATTERN_EXCLUDE_TAG = "exclude";
    private static final String PATTERN_INCL_EXCL_ATTRIBUTE = "name";
    private ArrayList incl = new ArrayList();
    private ArrayList excl = new ArrayList();

    public PatternRecord() {
    }

    public PatternRecord(String[] includePatterns, String[] excludePatterns) {
        this();
        if (includePatterns != null) {
            this.incl.addAll(Arrays.asList(includePatterns));
        }
        if (excludePatterns != null) {
            this.excl.addAll(Arrays.asList(excludePatterns));
        }
    }

    public void addExcludePattern(String exclPattern) {
        if (exclPattern == null) {
            throw new IllegalArgumentException();
        }
        this.excl.add(exclPattern);
    }

    public void addIncludePattern(String inclPattern) {
        if (inclPattern == null) {
            throw new IllegalArgumentException();
        }
        this.incl.add(inclPattern);
    }

    public void addExcludePattern(String[] exclPattern) {
        if (exclPattern != null) {
            int i = 0;
            while (i < exclPattern.length) {
                this.addExcludePattern(exclPattern[i]);
                ++i;
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void addIncludePattern(String[] inclPattern) {
        if (inclPattern != null) {
            int i = 0;
            while (i < inclPattern.length) {
                this.addIncludePattern(inclPattern[i]);
                ++i;
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public String[] getExcludePatterns() {
        return this.excl.toArray(new String[this.excl.size()]);
    }

    public String[] getIncludePatterns() {
        return this.incl.toArray(new String[this.incl.size()]);
    }

    public void removeExcludePattern(String exclPattern) {
        ((AbstractCollection)this.excl).remove(exclPattern);
    }

    public void removeIncludePattern(String inclPattern) {
        ((AbstractCollection)this.incl).remove(inclPattern);
    }

    public int getType() {
        return 0;
    }

    public static String getElementName() {
        return PATTERNMUTABLE_TAG;
    }

    public static IPattern getInstanceFromXML(Element element, IXMLSerializeLogger log) {
        log.assertt(element.getNodeName().equals(PATTERNMUTABLE_TAG), "Invalid root tag for constructing mutable pattern: " + element.getNodeName());
        Element[] children = XMLUtil.getElementsFromNodeList(element.getChildNodes());
        ArrayList<String> inPatterns = new ArrayList<String>();
        ArrayList<String> exPatterns = new ArrayList<String>();
        int i = 0;
        while (i < children.length) {
            log.assertt(children[i].getNodeName().equals(PATTERN_INCLUDE_TAG) || children[i].getNodeName().equals(PATTERN_EXCLUDE_TAG), "Invalid pattern sub tag: " + children[i].getNodeName());
            String pat = children[i].getAttribute(PATTERN_INCL_EXCL_ATTRIBUTE);
            log.assertt(pat.length() > 0, "Pattern String must be qualified");
            if (children[i].getNodeName().equals(PATTERN_INCLUDE_TAG)) {
                inPatterns.add(pat);
            } else if (children[i].getNodeName().equals(PATTERN_EXCLUDE_TAG)) {
                exPatterns.add(pat);
            }
            ++i;
        }
        return new PatternRecord(inPatterns.toArray(new String[inPatterns.size()]), exPatterns.toArray(new String[exPatterns.size()]));
    }

    public Element getXMLRepresentation(Document doc) {
        Element ret = doc.createElement(PATTERNMUTABLE_TAG);
        String[] incl = this.getIncludePatterns();
        String[] excl = this.getExcludePatterns();
        int i = 0;
        while (i < incl.length) {
            Element inclEl = doc.createElement(PATTERN_INCLUDE_TAG);
            inclEl.setAttribute(PATTERN_INCL_EXCL_ATTRIBUTE, incl[i]);
            ret.appendChild(inclEl);
            ++i;
        }
        int i2 = 0;
        while (i2 < excl.length) {
            Element exclEl = doc.createElement(PATTERN_EXCLUDE_TAG);
            exclEl.setAttribute(PATTERN_INCL_EXCL_ATTRIBUTE, excl[i2]);
            ret.appendChild(exclEl);
            ++i2;
        }
        return ret;
    }
}

