/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.archive.internal;

import com.tssap.tools.archive.IMutablePattern;
import com.tssap.tools.archive.IPattern;
import com.tssap.tools.archive.Pattern;
import com.tssap.tools.archive.internal.IXMLSerializeLogger;
import com.tssap.tools.archive.internal.PatternBase;
import com.tssap.tools.archive.internal.XMLSerializable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PatternDefaults
extends PatternBase
implements IPattern,
XMLSerializable {
    static final String PATTERNDEFAULT_TAG = "DefaultPattern";
    private static final String PATTERN_TYPE_ATTRIBUTE = "type";
    private String[] includes;
    private String[] excludes;
    private int type;
    private static PatternDefaults[] defaultPatterns = new PatternDefaults[4];

    private PatternDefaults(int type) {
        this.type = type;
        switch (type) {
            case 1: {
                this.includes = new String[]{"**/*.class"};
                this.excludes = new String[0];
                break;
            }
            case 2: {
                this.includes = new String[]{"**/*.java"};
                this.excludes = new String[0];
                break;
            }
            case 3: {
                this.includes = new String[]{"**"};
                this.excludes = new String[0];
            }
        }
    }

    public static IPattern getPattern(int type) {
        IMutablePattern ret = null;
        if (type != 0) {
            if (defaultPatterns[type] == null) {
                PatternDefaults.defaultPatterns[type] = new PatternDefaults(type);
            }
            return defaultPatterns[type];
        }
        ret = Pattern.getEmptyPattern();
        return ret;
    }

    public String[] getExcludePatterns() {
        return this.excludes;
    }

    public String[] getIncludePatterns() {
        return this.includes;
    }

    public int getType() {
        return this.type;
    }

    public static String getElementName() {
        return PATTERNDEFAULT_TAG;
    }

    public static IPattern getInstanceFromXML(Element element, IXMLSerializeLogger log) {
        log.assertt(element.getNodeName().equals(PATTERNDEFAULT_TAG), " Invalid root tag for constructing default pattern : " + element.getNodeName());
        String typeStr = element.getAttribute(PATTERN_TYPE_ATTRIBUTE);
        int type = Pattern.getTypeFromStringDescr(typeStr);
        return new PatternDefaults(type);
    }

    public Element getXMLRepresentation(Document doc) {
        Element ret = doc.createElement(PATTERNDEFAULT_TAG);
        ret.setAttribute(PATTERN_TYPE_ATTRIBUTE, Pattern.getTypeName(this.getType()));
        return ret;
    }
}

