/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.archive.internal;

import com.tssap.tools.archive.IFileLocation;
import com.tssap.tools.archive.RelativePath;
import com.tssap.tools.archive.internal.AntHelper;
import com.tssap.tools.archive.internal.IAntFileSet;
import com.tssap.tools.archive.internal.PathEnvironment;
import com.tssap.tools.archive.internal.impl.AbsPath;
import com.tssap.tools.archive.internal.impl.AntFileSetImpl;

public class PathTransformer {
    private static final String PROJECT_TOKEN = "Project";
    private static final String MSG_TEXT = "Translating relative path: ";
    private static PathTransformer impl = new PathTransformer();
    private static PathEnvironment pathEnv = PathEnvironment.getEnvironment(0);

    public static IAntFileSet[] translateLocations(IFileLocation fLoc) {
        IAntFileSet[] ret = null;
        AbsPath[] absPath = impl.getAbsoluteBasePath(fLoc);
        ret = new IAntFileSet[absPath.length];
        int i = 0;
        while (i < absPath.length) {
            ret[i] = new AntFileSetImpl(1, absPath[i].isArchive() ? null : absPath[i].getPath(), absPath[i].isArchive() ? absPath[i].getPath() : null, fLoc.getPatterns(), fLoc.getPrefix(), fLoc.getFullArchivePath());
            ++i;
        }
        return ret;
    }

    public static String translateSingleRelPath(String relPath) {
        if (RelativePath.isRelative(relPath)) {
            return impl.getSinglePath(RelativePath.tokenizeRelativePath(relPath));
        }
        return relPath;
    }

    protected String getSinglePath(String[] relTokens) {
        this.assertt(relTokens[0].equals(PROJECT_TOKEN), "Unknown variable path tokens: " + AntHelper.connectString(relTokens, '-'), true);
        this.assertt(relTokens.length >= 2, "Translating relative path: project token must be followed by project name token", true);
        String projPath = null;
        if (relTokens.length == 3 && (projPath = pathEnv.getPrjRelPath(relTokens[1], relTokens[2]).getPath()) == null) {
            projPath = pathEnv.getProjectBasePath(relTokens[1]) + relTokens[2];
        }
        return projPath;
    }

    private AbsPath[] getAbsoluteBasePath(IFileLocation fLoc) {
        AbsPath[] ret = RelativePath.isRelative(fLoc.getBasePath()) ? impl.getAbsolutePath(RelativePath.tokenizeRelativePath(fLoc.getBasePath())) : new AbsPath[]{new AbsPath(fLoc.getBasePath(), fLoc.isFromArchive())};
        return ret;
    }

    protected AbsPath[] getAbsolutePath(String[] varTokens) {
        AbsPath[] ret = null;
        this.assertt(varTokens[0].equals(PROJECT_TOKEN), "Unknown variable path tokens: " + AntHelper.connectString(varTokens, '-'), true);
        this.assertt(varTokens.length >= 2, "Translating relative path: project token must be followed by project name token", true);
        String projPath = pathEnv.getProjectBasePath(varTokens[1]);
        if (projPath != null) {
            ret = varTokens.length >= 3 ? (varTokens[2].equals("source") ? pathEnv.getSourcePaths(varTokens[1]) : (varTokens[2].equals("classes") ? pathEnv.getClassesPaths(varTokens[1]) : (varTokens[2].equals("classpath") ? pathEnv.getClasspathPaths(varTokens[1]) : new AbsPath[]{pathEnv.getPrjRelPath(varTokens[1], varTokens[2])}))) : new AbsPath[]{new AbsPath(projPath, false)};
        } else {
            this.assertt(false, "Translating relative path: Project " + varTokens[1] + " not found", false);
            ret = new AbsPath[]{};
        }
        return ret;
    }

    protected void assertt(boolean assertation, String message, boolean abort) {
        if (assertation) {
            return;
        }
        if (abort) {
            throw new RuntimeException(message);
        }
        System.out.println(message);
    }

    public static void setPathEnvironment(PathEnvironment env) {
        pathEnv = env;
    }
}

