/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.archive.internal;

import com.tssap.tools.archive.ArchiveBuilder;
import com.tssap.tools.archive.internal.PathEnvironment;
import com.tssap.tools.archive.internal.impl.AbsPath;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class EclpisePathEnvironment
extends PathEnvironment {
    private static PathEnvironment impl;
    static /* synthetic */ Class class$com$tssap$tools$archive$internal$EclpisePathEnvironment;

    public AbsPath[] getClassesPaths(String projId) {
        IProject proj = this.getProj(projId);
        IJavaProject javaProj = this.getJavaProj(projId);
        String outPath = null;
        try {
            outPath = proj.getLocation().append(javaProj.getOutputLocation().removeFirstSegments(1)).toOSString();
        }
        catch (JavaModelException e) {
            ArchiveBuilder.tracer.error(class$com$tssap$tools$archive$internal$EclpisePathEnvironment == null ? (class$com$tssap$tools$archive$internal$EclpisePathEnvironment = EclpisePathEnvironment.class$("com.tssap.tools.archive.internal.EclpisePathEnvironment")) : class$com$tssap$tools$archive$internal$EclpisePathEnvironment, "getClassesPaths(String projId)", "Error calculating path to classes", (Throwable)e);
        }
        return new AbsPath[]{new AbsPath(outPath, false)};
    }

    public AbsPath[] getClasspathPaths(String projId) {
        ArchiveBuilder.tracer.warning(class$com$tssap$tools$archive$internal$EclpisePathEnvironment == null ? (class$com$tssap$tools$archive$internal$EclpisePathEnvironment = EclpisePathEnvironment.class$("com.tssap.tools.archive.internal.EclpisePathEnvironment")) : class$com$tssap$tools$archive$internal$EclpisePathEnvironment, "getClasspathPaths(String projId)", "Method must not be used");
        IProject proj = this.getProj(projId);
        String path = proj.getLocation().toOSString() + "/bin/";
        return new AbsPath[]{new AbsPath(path, false), new AbsPath("C:/JDK/jdk1.4/jre/lib/rt.jar", true)};
    }

    public AbsPath[] getSourcePaths(String projId) {
        ArrayList<IPath> list = new ArrayList<IPath>();
        IProject proj = this.getProj(projId);
        IJavaProject javaProj = this.getJavaProj(projId);
        IClasspathEntry[] entries = null;
        try {
            entries = javaProj.getResolvedClasspath(true);
        }
        catch (JavaModelException e) {
            ArchiveBuilder.tracer.error(class$com$tssap$tools$archive$internal$EclpisePathEnvironment == null ? (class$com$tssap$tools$archive$internal$EclpisePathEnvironment = EclpisePathEnvironment.class$("com.tssap.tools.archive.internal.EclpisePathEnvironment")) : class$com$tssap$tools$archive$internal$EclpisePathEnvironment, "getSourcePaths(String projId)", "Error calculating path to sources", (Throwable)e);
        }
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getEntryKind() == 3) {
                list.add(entries[i].getPath());
            }
            ++i;
        }
        AbsPath[] ret = new AbsPath[list.size()];
        int i2 = 0;
        while (i2 < ret.length) {
            IPath path = (IPath)list.get(i2);
            String fullPath = proj.getLocation().append(path.removeFirstSegments(1)).toOSString();
            ret[i2] = new AbsPath(fullPath, false);
            ++i2;
        }
        return ret;
    }

    public String getProjectBasePath(String projId) {
        IProject proj = this.getProj(projId);
        String ret = proj == null ? null : proj.getLocation().toString();
        return ret;
    }

    private IProject getProj(String projId) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projId);
    }

    private IJavaProject getJavaProj(String projId) {
        IJavaProject ret = null;
        IProject proj = this.getProj(projId);
        if (proj != null) {
            ret = JavaCore.create((IProject)proj);
        }
        return ret;
    }

    public AbsPath getPrjRelPath(String prjId, String prjRelPath) {
        String fullPath = null;
        IProject prj = this.getProj(prjId);
        if (prj != null) {
            if (prjRelPath != null && prjRelPath.length() == 1 && prjRelPath.charAt(0) == '/') {
                fullPath = prj.getLocation().toFile().getAbsolutePath();
            } else {
                IFolder folder = prj.getFolder(prjRelPath);
                if (folder != null && folder.getLocation().toFile().exists()) {
                    fullPath = folder.getLocation().toFile().getAbsolutePath();
                } else {
                    IFile file = prj.getFile(prjRelPath);
                    if (file != null && file.getLocation().toFile().exists()) {
                        fullPath = file.getLocation().toFile().getAbsolutePath();
                    }
                }
            }
        }
        return new AbsPath(fullPath, false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

