/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.archive.internal;

import com.tssap.tools.archive.ArchiveBuildException;
import com.tssap.tools.archive.IComponentBuildInfo;
import com.tssap.tools.archive.internal.AntBuildListener;
import com.tssap.tools.archive.internal.IAntArchiveDesriptor;
import com.tssap.tools.archive.internal.IBuildLogger;
import com.tssap.tools.archive.internal.IBuilder;
import com.tssap.tools.archive.internal.IPostBuildTask;
import com.tssap.tools.archive.internal.ITaskBuilder;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class BaseAntBuilder
implements IBuilder {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$tools$archive$internal$BaseAntBuilder == null ? (class$com$tssap$tools$archive$internal$BaseAntBuilder = BaseAntBuilder.class$("com.tssap.tools.archive.internal.BaseAntBuilder")) : class$com$tssap$tools$archive$internal$BaseAntBuilder));
    private static final String ZIP_TARGET_NAME = "Jar";
    private static final String CLEAN_TARGET_NAME = "Clean";
    private static final String BUILD_PROJECT_NAME = "BuildProject";
    private boolean allowDoubleEntries = false;
    private IBuildLogger myBuildLogger;
    private IPostBuildTask myPostBuildTask;
    protected IProgressMonitor myMonitor;
    private final String REMOVE_ERR_MSG = "Error while removing double entries from Zip. ";
    static /* synthetic */ Class class$com$tssap$tools$archive$internal$BaseAntBuilder;

    public void buildArchive(IAntArchiveDesriptor descr, IProgressMonitor monitor) {
        tracer.path("buildArchive(IAntArchiveDesriptor descr, IProgressMonitor monitor)", "Enter");
        this.myMonitor = monitor;
        Project buildProj = new Project();
        Target buildTarget = new Target();
        Target cleanTarget = new Target();
        this.myMonitor.subTask("Start building " + BaseAntBuilder.getNameFromPath(descr.getDestPath()));
        AntBuildListener myBuildListener = new AntBuildListener(this.myBuildLogger);
        buildProj.addBuildListener((BuildListener)myBuildListener);
        cleanTarget.setName(CLEAN_TARGET_NAME);
        cleanTarget.setProject(buildProj);
        buildTarget.setName(ZIP_TARGET_NAME);
        buildTarget.setProject(buildProj);
        buildProj.addTarget(buildTarget);
        buildProj.addTarget(cleanTarget);
        buildProj.setName(BUILD_PROJECT_NAME);
        buildProj.setDefault(ZIP_TARGET_NAME);
        ITaskBuilder taskBuilder = this.createTaskBuilder();
        taskBuilder.createAndAddTasks(descr, buildTarget, cleanTarget, buildProj);
        BuildException buildException = null;
        try {
            tracer.path("Start executing zip target");
            buildProj.executeTarget(ZIP_TARGET_NAME);
            tracer.path("Finished executing zip target");
        }
        catch (BuildException e) {
            buildException = e;
            tracer.path("Executing zip target failed: " + e.getMessage());
        }
        try {
            tracer.path("Start clean target");
            buildProj.executeTarget(CLEAN_TARGET_NAME);
            tracer.path("Finished clean target");
        }
        catch (BuildException e) {
            if (buildException == null) {
                buildException = e;
            }
            tracer.path("Executing clean target failed: " + e.getMessage());
        }
        if (buildException != null) {
            throw new ArchiveBuildException(buildException.getMessage(), buildException.getException());
        }
        File arDestFile = new File(descr.getDestPath());
        if (descr instanceof IComponentBuildInfo && ((IComponentBuildInfo)((Object)descr)).isUseComponentBuild()) {
            if (this.myPostBuildTask != null) {
                try {
                    tracer.path("Start PostBuildTask");
                    this.myPostBuildTask.perform(arDestFile, descr, this.myBuildLogger, this.myMonitor);
                    tracer.path("Finished PostBuildTask");
                }
                catch (RuntimeException e) {
                    tracer.path("PostBuildTask failed: " + e.getMessage());
                    if (e instanceof ArchiveBuildException) {
                        throw (ArchiveBuildException)e;
                    }
                    throw new ArchiveBuildException(e);
                }
            } else {
                tracer.info("Archive " + descr.getDestPath() + " demands component build. No component build availible");
            }
        }
    }

    public static String getNameFromPath(String string) {
        int index = Math.max(string.lastIndexOf(47), string.lastIndexOf(92));
        String ret = index > 0 ? string.substring(index + 1, string.length()) : string;
        return ret;
    }

    protected abstract ITaskBuilder createTaskBuilder();

    public void setLogger(IBuildLogger buildLogger) {
        this.myBuildLogger = buildLogger;
    }

    private void logException(String msg, Exception e) {
        tracer.warning(msg, (Throwable)e);
    }

    private String normalizeSeparators(String path) {
        String result = path.replace(File.separatorChar, '/');
        return result;
    }

    private File createTmpFile(File f) {
        File ret = null;
        int count = 0;
        if (f != null) {
            do {
                ret = new File(f.getParentFile(), f.getName() + ".tmp" + count++ + ".zip");
            } while (!f.exists());
        }
        return ret;
    }

    public boolean isAllowDoubleEntries() {
        return this.allowDoubleEntries;
    }

    public void setPostBuildTask(IPostBuildTask task) {
        this.myPostBuildTask = task;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

