/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.archive.internal;

import com.tssap.tools.archive.IFileLocation;
import com.tssap.tools.archive.internal.IAntArchiveDesriptor;
import com.tssap.tools.archive.internal.IAntFileSet;
import java.io.File;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.ZipFileSet;

public class AntHelper {
    public static FileSet getAntFileSet(IAntFileSet set) {
        ZipFileSet ret = new ZipFileSet();
        if (set.getDir() != null && set.getDir().length() > 0) {
            ret.setDir(new File(set.getDir()));
        }
        if (set.getSrc() != null && set.getSrc().length() > 0) {
            ret.setSrc(new File(set.getSrc()));
        }
        if (set.getPrefix() != null && set.getPrefix().length() > 0) {
            ret.setPrefix(AntHelper.replacePathSeperator(set.getPrefix()));
        }
        if (set.getFullPath() != null && set.getFullPath().length() > 0) {
            ret.setFullpath(AntHelper.replacePathSeperator(set.getFullPath()));
        }
        PatternSet ps = ret.createPatternSet();
        AntHelper.addIncludes(ps, set.getPattern().getIncludePatterns());
        AntHelper.addExcludes(ps, set.getPattern().getExcludePatterns());
        return ret;
    }

    private static void addExcludes(PatternSet ps, String[] exPattern) {
        int i = 0;
        while (i < exPattern.length) {
            PatternSet.NameEntry ne = ps.createExclude();
            ne.setName(exPattern[i]);
            ++i;
        }
    }

    private static void addIncludes(PatternSet ps, String[] inPattern) {
        int i = 0;
        while (i < inPattern.length) {
            PatternSet.NameEntry ne = ps.createInclude();
            ne.setName(inPattern[i]);
            ++i;
        }
    }

    public static String replacePathSeperator(String s) {
        return s.replace(File.separatorChar, '/');
    }

    public static String connectString(String[] parts, char seperator) {
        StringBuffer sBuf = new StringBuffer();
        if (parts == null) {
            return "";
        }
        int i = 0;
        while (i < parts.length) {
            sBuf.append(parts[i]);
            if (i < parts.length - 1) {
                sBuf.append(seperator);
            }
            ++i;
        }
        return sBuf.toString();
    }

    public static void dump(IFileLocation loc) {
        System.out.println("Path:" + loc.getBasePath() + " Incl:" + AntHelper.connectString(loc.getPatterns().getIncludePatterns(), ',') + " Excl:" + AntHelper.connectString(loc.getPatterns().getExcludePatterns(), ',') + " Pre:" + loc.getPrefix() + " Full:" + loc.getFullArchivePath());
    }

    public static void dump(IAntArchiveDesriptor antArDesc) {
        IAntFileSet[] fSets = antArDesc.getFileSets();
        int i = 0;
        while (i < fSets.length) {
            AntHelper.dump(fSets[i]);
            ++i;
        }
        IAntArchiveDesriptor[] nestedAr = antArDesc.getNestedArchives();
        int i2 = 0;
        while (i2 < nestedAr.length) {
            System.out.println("/nNestetArchive:");
            AntHelper.dump(nestedAr[i2]);
            ++i2;
        }
    }

    private static void dump(IAntFileSet iFileSet) {
        System.out.println("Dir: " + iFileSet.getDir() + " -Src:" + iFileSet.getSrc() + " -Incl: " + AntHelper.connectString(iFileSet.getPattern().getIncludePatterns(), ',') + " -excl: " + AntHelper.connectString(iFileSet.getPattern().getExcludePatterns(), ',') + " -full: " + iFileSet.getFullPath() + " -pre:" + iFileSet.getPrefix());
    }
}

