/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.archive.internal;

import com.tssap.tools.archive.ArchiveBuilder;
import com.tssap.tools.archive.Pattern;
import com.tssap.tools.archive.internal.AntHelper;
import com.tssap.tools.archive.internal.BaseAntBuilder;
import com.tssap.tools.archive.internal.BaseTaskBuilder;
import com.tssap.tools.archive.internal.IAntArchiveDesriptor;
import com.tssap.tools.archive.internal.IAntFileSet;
import com.tssap.tools.archive.internal.IAntNestedArchiveDesriptor;
import com.tssap.tools.archive.internal.ITaskBuilder;
import com.tssap.tools.archive.internal.impl.AntFileSetImpl;
import java.io.File;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;

public class AntArchiveBuilder
extends BaseAntBuilder {
    protected ITaskBuilder createTaskBuilder() {
        return new AntTaskBuilder();
    }

    public class AntTaskBuilder
    extends BaseTaskBuilder
    implements ITaskBuilder {
        public void createAndAddTasks(IAntArchiveDesriptor descr, Target buildTarget, Target cleanTarget, Project buildProj) {
            Zip zipTask = new Zip();
            zipTask.setProject(buildProj);
            Zip.WhenEmpty emptyBehavior = new Zip.WhenEmpty();
            emptyBehavior.setValue("create");
            zipTask.setWhenempty(emptyBehavior);
            zipTask.setUpdate(false);
            Zip.Duplicate db = new Zip.Duplicate();
            db.setValue("preserve");
            zipTask.setDuplicate(db);
            File destFile = new File(descr.getDestPath());
            if (!destFile.getParentFile().exists()) {
                destFile.getParentFile().mkdirs();
            }
            if (destFile.exists()) {
                destFile.delete();
            }
            zipTask.setDestFile(destFile);
            zipTask.setCompress(descr.isCompressed());
            IAntFileSet[] fs = descr.getFileSets();
            int i = 0;
            while (i < fs.length) {
                FileSet antFs = AntHelper.getAntFileSet(fs[i]);
                File antFsBaseDir = antFs.getDir(buildProj);
                if (antFsBaseDir != null && antFsBaseDir.exists()) {
                    zipTask.addFileset(antFs);
                } else {
                    String baseDirName = antFsBaseDir != null ? antFsBaseDir.getAbsolutePath() : "null";
                    ArchiveBuilder.tracer.info("Skipping FileSet because base directory " + baseDirName + " not exsist");
                }
                ++i;
            }
            IAntArchiveDesriptor[] innerAr = descr.getNestedArchives();
            int i2 = 0;
            while (i2 < innerAr.length) {
                AntArchiveBuilder.this.buildArchive(innerAr[i2], AntArchiveBuilder.this.myMonitor);
                AntFileSetImpl nestedFs = null;
                if (innerAr[i2] instanceof IAntNestedArchiveDesriptor) {
                    IAntNestedArchiveDesriptor nestedAr = (IAntNestedArchiveDesriptor)innerAr[i2];
                    File outFile = new File(nestedAr.getDestPath());
                    nestedFs = new AntFileSetImpl(1, outFile.getParent(), null, Pattern.getPattern(new String[]{outFile.getName()}, null), null, nestedAr.getNestedArchivePath());
                    if (nestedAr.isTemporary()) {
                        Delete delTask = new Delete();
                        delTask.setFile(outFile);
                        delTask.setProject(buildProj);
                        cleanTarget.addTask((Task)delTask);
                        this.addCleanTask((Task)delTask);
                    }
                } else {
                    throw new RuntimeException("AntArchiveBuilder.buildArchive: Inner archive not instanceof IAntNestedArchiveDesriptor");
                }
                zipTask.addFileset(AntHelper.getAntFileSet(nestedFs));
                ++i2;
            }
            buildTarget.addTask((Task)zipTask);
            this.addBuildTask((Task)zipTask);
        }
    }
}

