/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.archive.internal;

import com.tssap.tools.archive.IArchive;
import com.tssap.tools.archive.IComponent;
import com.tssap.tools.archive.IComponentBuildInfo;
import com.tssap.tools.archive.IFileLocation;
import com.tssap.tools.archive.internal.IAntArchiveDesriptor;
import com.tssap.tools.archive.internal.IAntFileSet;
import com.tssap.tools.archive.internal.IAntNestedArchiveDesriptor;
import com.tssap.tools.archive.internal.IArchiveContentSupplier;
import com.tssap.tools.archive.internal.INestedArchiveDescriptor;
import com.tssap.tools.archive.internal.PathTransformer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;

public class AntArOnTheFlyTransformer
implements IAntNestedArchiveDesriptor,
IComponentBuildInfo {
    String myParentDestPath;
    int mySiblingNumber;
    INestedArchiveDescriptor nestedDescr;
    IArchive arDescr;

    public AntArOnTheFlyTransformer(INestedArchiveDescriptor nestedArDescr, String parentDestPath, int nestedSiblingNum) {
        this.nestedDescr = nestedArDescr;
        if (!(this.nestedDescr.getArchiveDescriptor() instanceof IArchiveContentSupplier)) {
            throw new RuntimeException("Constructor AntArOnTheFlyTransformer: nestedDescr.getArchiveDescriptor() must be instanceof IArchiveContentSupplier");
        }
        this.arDescr = this.nestedDescr.getArchiveDescriptor();
        this.mySiblingNumber = nestedSiblingNum;
        this.myParentDestPath = parentDestPath;
    }

    public boolean isTemporary() {
        return this.nestedDescr.isTemporary();
    }

    public String getNestedArchivePath() {
        return this.nestedDescr.getPathInArchive();
    }

    public String getDestPath() {
        String ret = null;
        ret = this.nestedDescr.isTemporary() ? this.createTmpDestPath() : PathTransformer.translateSingleRelPath(this.arDescr.getDestPath());
        return ret;
    }

    public boolean isCompressed() {
        return this.arDescr.isCompressed();
    }

    public IAntFileSet[] getFileSets() {
        IFileLocation[] locs = ((IArchiveContentSupplier)((Object)this.arDescr)).getFileLocations();
        ArrayList<IAntFileSet> fileSets = new ArrayList<IAntFileSet>();
        int i = 0;
        while (i < locs.length) {
            IAntFileSet[] fs = PathTransformer.translateLocations(locs[i]);
            fileSets.addAll(Arrays.asList(fs));
            ++i;
        }
        return fileSets.toArray(new IAntFileSet[fileSets.size()]);
    }

    public IAntArchiveDesriptor[] getNestedArchives() {
        INestedArchiveDescriptor[] nestedAr = ((IArchiveContentSupplier)((Object)this.arDescr)).getNestedArchives();
        IAntArchiveDesriptor[] ret = new IAntArchiveDesriptor[nestedAr.length];
        int i = 0;
        while (i < nestedAr.length) {
            ret[i] = new AntArOnTheFlyTransformer(nestedAr[i], this.getDestPath(), i);
            ++i;
        }
        return ret;
    }

    private String createTmpDestPath() {
        return this.myParentDestPath + ".tmp" + this.mySiblingNumber;
    }

    public IComponent getComponent() {
        return this.arDescr.getComponentBuildInfo().getComponent();
    }

    public IComponent[] getDependencies() {
        return this.arDescr.getComponentBuildInfo().getDependencies();
    }

    public String getDeployFileContent() {
        return this.arDescr.getComponentBuildInfo().getDeployFileContent();
    }

    public File getDeployFile() {
        return this.arDescr.getComponentBuildInfo().getDeployFile();
    }

    public boolean isUseComponentBuild() {
        return this.arDescr.getComponentBuildInfo().isUseComponentBuild();
    }

    public void addDependency(IComponent dependentComponent) {
        this.arDescr.getComponentBuildInfo().addDependency(dependentComponent);
    }

    public void setComponent(IComponent component) {
        this.arDescr.getComponentBuildInfo().setComponent(component);
    }

    public void setDeployFileContent(String deployFilePath) {
        this.arDescr.getComponentBuildInfo().setDeployFileContent(deployFilePath);
    }

    public void setDeployFile(File deployFile) {
        this.arDescr.getComponentBuildInfo().setDeployFile(deployFile);
    }

    public void setUseComponentBuild(boolean useCompBuild) {
        this.arDescr.getComponentBuildInfo().setUseComponentBuild(useCompBuild);
    }
}

