/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.archive;

import java.io.File;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class RelativePath {
    private static final String SEP_START = "{";
    private static final String SEP_END = "}";
    private static final String PROJ_TOKEN = "Project";
    private static final String PROJ_TOKEN_FULL = "{Project}";
    private static final char IO_FILE_SEP_C = File.separatorChar;
    private static final String IO_FILE_SEP_S = File.separator;
    private static final String JAVA_FILE_SEP = "/";
    public static final PathType SOURCE = new PathType(0);
    public static final PathType CLASSES = new PathType(1);
    public static final PathType CLASSPATH = new PathType(2);

    public static String getRelativePath(IProject project) {
        return RelativePath.getRelativePath(project.getName());
    }

    public static String getRelativePath(IProject proj, String additionalPath) {
        return RelativePath.getRelativePath(proj.getName(), additionalPath);
    }

    public static String getRelativePath(String projectName) {
        return "{Project}{" + projectName + SEP_END;
    }

    public static String getRelativePath(String projectName, String additionalPath) {
        if (additionalPath == null) {
            additionalPath = "";
        } else if (!(additionalPath.startsWith(JAVA_FILE_SEP) || additionalPath.startsWith(IO_FILE_SEP_S) || additionalPath.startsWith(SEP_START))) {
            additionalPath = JAVA_FILE_SEP + additionalPath;
        }
        return RelativePath.getRelativePath(projectName) + additionalPath;
    }

    public static String getRelativePath(IResource resource) {
        return RelativePath.getRelativePath(resource.getProject(), resource.getFullPath().removeFirstSegments(1).toString());
    }

    public static String[] tokenizeRelativePath(String relPath) {
        StringTokenizer sTokens = new StringTokenizer(relPath, "{}");
        String[] ret = new String[sTokens.countTokens()];
        int i = 0;
        while (i < ret.length) {
            ret[i] = sTokens.nextToken();
            ++i;
        }
        return ret;
    }

    public static boolean isRelative(String path) {
        return path.startsWith(PROJ_TOKEN_FULL);
    }

    public static String removeLastSegment(String string) {
        return string.substring(0, RelativePath.getLastSegmentIndex(string));
    }

    public static String getLastSegment(String string) {
        return string.substring(RelativePath.getLastSegmentIndex(string) + 1, string.length());
    }

    private static int getLastSegmentIndex(String string) {
        int ret = string.lastIndexOf(JAVA_FILE_SEP);
        ret = Math.max(ret, string.lastIndexOf(IO_FILE_SEP_S));
        ret = Math.max(ret, string.lastIndexOf(SEP_END));
        return ret;
    }

    public static class PathType {
        static final String[] stringRepresentation = new String[]{"{source}", "{classes}", "{classpath}"};
        private int type;

        private PathType(int type) {
            this.type = type;
        }

        public String toString() {
            return stringRepresentation[this.type];
        }
    }
}

