/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.archive;

import com.tssap.tools.archive.IMutablePattern;
import com.tssap.tools.archive.IPattern;
import com.tssap.tools.archive.internal.PatternDefaults;
import com.tssap.tools.archive.internal.PatternRecord;

public class Pattern {
    public static final int MUTABLE = 0;
    public static final int ALL_CLASS_FILES = 1;
    public static final int ALL_JAVA_FILES = 2;
    public static final int ALL_FILES = 3;
    private static final int DEFAULT_PATTERN_NUMBER = 3;
    private static final String[] TYPENAMES = new String[]{"Mutable", "All_ClassFiles", "All_JavaFiles", "All_Files"};

    private Pattern() {
    }

    public static IMutablePattern getEmptyPattern() {
        return new PatternRecord();
    }

    public static IMutablePattern getPattern(IPattern templatePattern) {
        return new PatternRecord(templatePattern.getIncludePatterns(), templatePattern.getExcludePatterns());
    }

    public static IPattern getPattern(int type) {
        if (type < 0 || type > 3) {
            throw new IllegalArgumentException("No such Pattern: Pattern.getPattern(type) type =" + type);
        }
        return PatternDefaults.getPattern(type);
    }

    public static IMutablePattern getPattern(String[] includePatterns, String[] excludePatterns) {
        return new PatternRecord(includePatterns, excludePatterns);
    }

    public static int getTypeFromStringDescr(String typeStr) {
        int ret = -1;
        int i = 0;
        while (i < TYPENAMES.length && ret == -1) {
            if (TYPENAMES[i].equals(typeStr)) {
                ret = i;
            }
            ++i;
        }
        return ret;
    }

    public static String getTypeName(int i) {
        return TYPENAMES[i];
    }
}

