/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.archive;

import com.tssap.tools.XMLUtil;
import com.tssap.tools.archive.IAbsoluteFileSet;
import com.tssap.tools.archive.IArchiveDescriptor;
import com.tssap.tools.archive.IArchiveSet;
import com.tssap.tools.archive.IEarDescriptor;
import com.tssap.tools.archive.IEjbJarDescriptor;
import com.tssap.tools.archive.IJavaSet;
import com.tssap.tools.archive.IProjectFileSet;
import com.tssap.tools.archive.IWarDescriptor;
import com.tssap.tools.archive.internal.XMLSerializable;
import com.tssap.tools.archive.internal.impl.AbsoluteFileSet;
import com.tssap.tools.archive.internal.impl.ArchiveDescriptor;
import com.tssap.tools.archive.internal.impl.ArchiveSet;
import com.tssap.tools.archive.internal.impl.EarDescriptor;
import com.tssap.tools.archive.internal.impl.EjbJarDescriptor;
import com.tssap.tools.archive.internal.impl.JavaSet;
import com.tssap.tools.archive.internal.impl.ProjectFileSet;
import com.tssap.tools.archive.internal.impl.WarDescriptor;
import com.tssap.tools.archive.internal.impl.XMLSerializeLogger;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ArchiveDescriptionManager {
    public static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$tools$archive$ArchiveDescriptionManager == null ? (class$com$tssap$tools$archive$ArchiveDescriptionManager = ArchiveDescriptionManager.class$("com.tssap.tools.archive.ArchiveDescriptionManager")) : class$com$tssap$tools$archive$ArchiveDescriptionManager));
    private static final String ARCHIVE_ROOT_TAG = "ArchiveDescription";
    static /* synthetic */ Class class$com$tssap$tools$archive$ArchiveDescriptionManager;

    public static IAbsoluteFileSet getAbsoluteFileSet() {
        return new AbsoluteFileSet();
    }

    public static IProjectFileSet getProjectFileSet() {
        return new ProjectFileSet();
    }

    public static IArchiveSet getArchiveSet() {
        return new ArchiveSet();
    }

    public static IJavaSet getJavaSet() {
        return new JavaSet();
    }

    public static IArchiveDescriptor newArchiveDescription() {
        return new ArchiveDescriptor();
    }

    public static IArchiveDescriptor getArchiveDescription(String filePath) {
        Document doc = null;
        Element rootElement = null;
        try {
            doc = XMLUtil.parse(new File(filePath));
            rootElement = doc.getDocumentElement();
        }
        catch (SAXException e) {
            tracer.warning("Error parsing archive description file " + filePath, (Throwable)e);
        }
        catch (IOException e) {
            tracer.warning("Error parsing archive description file " + filePath, (Throwable)e);
        }
        catch (Exception e) {
            tracer.warning("Error parsing archive description file " + filePath, (Throwable)e);
        }
        return rootElement != null ? ArchiveDescriptionManager.getArDescrFromXML(rootElement) : null;
    }

    public static IWarDescriptor newWarDescription() {
        return new WarDescriptor();
    }

    public static IEarDescriptor newEarDescription() {
        return new EarDescriptor();
    }

    public static IEjbJarDescriptor newEjbJarDescription() {
        return new EjbJarDescriptor();
    }

    public static void saveArchiveDescription(String filename, IArchiveDescriptor descr) {
        Document doc = XMLUtil.createNewDocument();
        ArchiveDescriptionManager.fillXMLfromArciveDescriptor(doc, descr);
        String xmlRepresentation = XMLUtil.serialize(doc);
        File outFile = new File(filename);
        try {
            FileWriter writer = new FileWriter(outFile);
            writer.write(xmlRepresentation);
            writer.close();
        }
        catch (IOException e) {
            tracer.warning("Error writing archive description to file: " + filename);
        }
    }

    private static void fillXMLfromArciveDescriptor(Document doc, IArchiveDescriptor descr) {
        Element rootElement = doc.createElement(ARCHIVE_ROOT_TAG);
        doc.appendChild(rootElement);
        Element archiveElement = ((XMLSerializable)((Object)descr)).getXMLRepresentation(doc);
        rootElement.appendChild(archiveElement);
    }

    private static IArchiveDescriptor getArDescrFromXML(Element rootElement) {
        ArchiveDescriptor ret = null;
        XMLSerializeLogger deserializeLogger = new XMLSerializeLogger();
        if (rootElement.getNodeName().equals(ARCHIVE_ROOT_TAG)) {
            NodeList rootChildren = rootElement.getChildNodes();
            Element[] childElements = XMLUtil.getElementsFromNodeList(rootChildren);
            if (childElements.length == 1) {
                ret = ArchiveDescriptor.getInstanceFromXML(childElements[0], deserializeLogger);
            } else {
                deserializeLogger.log("only one archive in one file");
            }
        } else {
            deserializeLogger.log("Invalid root Tag");
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

