/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.archive;

import com.tssap.tools.archive.ArchiveBuildException;
import com.tssap.tools.archive.internal.AntArchiveBuilder;
import com.tssap.tools.archive.internal.IAntArchiveDesriptor;
import com.tssap.tools.archive.internal.IBuildLogger;
import com.tssap.tools.archive.internal.IBuilder;
import com.tssap.tools.archive.internal.IPostBuildTask;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ArchiveBuilder {
    public static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$tools$archive$ArchiveBuilder == null ? (class$com$tssap$tools$archive$ArchiveBuilder = ArchiveBuilder.class$("com.tssap.tools.archive.ArchiveBuilder")) : class$com$tssap$tools$archive$ArchiveBuilder));
    private static final String JARSAP_BUILDER_PLUGIN = "com.sap.ide.eclipse.jarsap";
    private static final String JARSAP_POSTBUILDTASK_CLASS = "com.sap.ide.eclipse.jarsap.archive.JarSapHelper";
    static MyLogger myLogger = new MyLogger();
    private static boolean suppressMonitor = false;
    private static IBuilder myAntZipBuilder;
    private static IPostBuildTask myJarSapPostBuildTask;
    static /* synthetic */ Class class$com$tssap$tools$archive$ArchiveBuilder;

    public static void suppressMonitorDialog(boolean suppressMonitorNextBuild) {
        suppressMonitor = suppressMonitorNextBuild;
    }

    public static synchronized void buildArchive(IAntArchiveDesriptor descr) {
        ArchiveBuildException buildExc;
        block11: {
            if (tracer.debug()) {
                tracer.debug("Start building Archive: " + descr.getDestPath());
            }
            IBuilder builder = ArchiveBuilder.getAntZipBuilder();
            builder.setLogger(ArchiveBuilder.getLogger());
            ArchiveBuilder.getLogger().clearLog();
            builder.setPostBuildTask(ArchiveBuilder.getJarSapPostBuildTask());
            BuilderRunnable builderRunnable = new BuilderRunnable(builder, descr);
            buildExc = null;
            if (suppressMonitor) {
                try {
                    BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)builderRunnable);
                }
                catch (Exception e) {
                    if (e instanceof ArchiveBuildException) {
                        buildExc = (ArchiveBuildException)e;
                        break block11;
                    }
                    buildExc = new ArchiveBuildException(e);
                }
            } else {
                try {
                    Shell shell = Display.getDefault().getActiveShell();
                    ProgressMonitorDialog pmd = new ProgressMonitorDialog(shell);
                    pmd.run(false, false, (IRunnableWithProgress)builderRunnable);
                }
                catch (InvocationTargetException e) {
                    Throwable buildException = e.getTargetException();
                    buildExc = buildException instanceof ArchiveBuildException ? (ArchiveBuildException)buildException : new ArchiveBuildException(buildException);
                }
                catch (InterruptedException e) {
                    buildExc = new ArchiveBuildException(e);
                }
            }
        }
        suppressMonitor = false;
        if (tracer.info()) {
            tracer.info(ArchiveBuilder.getLog());
        }
        if (buildExc != null) {
            tracer.warning("Error building Archive", (Throwable)buildExc);
            throw buildExc;
        }
    }

    public static void startLog() {
        ArchiveBuilder.getLogger().clearLog();
    }

    public static String getLog() {
        return ArchiveBuilder.getLogger().getLog();
    }

    private static IBuildLogger getLogger() {
        return myLogger;
    }

    private static IBuilder getAntZipBuilder() {
        if (myAntZipBuilder == null) {
            myAntZipBuilder = new AntArchiveBuilder();
        }
        return myAntZipBuilder;
    }

    private static IPostBuildTask getJarSapPostBuildTask() {
        if (myJarSapPostBuildTask == null) {
            String msg = null;
            try {
                ClassLoader cl;
                Class<?> jarSapPostBuildTask;
                Plugin plugin = Platform.getPlugin((String)JARSAP_BUILDER_PLUGIN);
                if (plugin == null) {
                    msg = "com.sap.ide.eclipse.jarsap not availible";
                }
                if ((jarSapPostBuildTask = (cl = plugin.getDescriptor().getPluginClassLoader()).loadClass(JARSAP_POSTBUILDTASK_CLASS)) == null) {
                    msg = "Class com.sap.ide.eclipse.jarsap.archive.JarSapHelper not availible";
                }
                Object jarSapPostBuildTaskInst = null;
                jarSapPostBuildTaskInst = jarSapPostBuildTask.newInstance();
                if (jarSapPostBuildTaskInst instanceof IPostBuildTask) {
                    myJarSapPostBuildTask = jarSapPostBuildTaskInst;
                }
            }
            catch (Exception e) {
                if (msg == null) {
                    msg = e.getMessage();
                }
                tracer.info("JarSap not availible: " + msg);
            }
        }
        return myJarSapPostBuildTask;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class MyLogger
    implements IBuildLogger {
        private static final byte[] lineSepBytes;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(this.bOut);

        MyLogger() {
        }

        public void log(String msg) {
            try {
                ((FilterOutputStream)this.ps).write(msg.getBytes());
                ((FilterOutputStream)this.ps).write(lineSepBytes);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void clearLog() {
            this.bOut.reset();
        }

        public String getLog() {
            return this.bOut.toString();
        }

        public PrintStream getPrintStream() {
            return this.ps;
        }

        static {
            String lSep = System.getProperty("line.separator");
            lineSepBytes = lSep != null ? lSep.getBytes() : new byte[]{};
        }
    }

    static class BuilderRunnable
    implements IRunnableWithProgress,
    Runnable {
        private IBuilder builder;
        private IAntArchiveDesriptor descr;

        BuilderRunnable(IBuilder builder, IAntArchiveDesriptor descr) {
            this.builder = builder;
            this.descr = descr;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask("Building Archive", -1);
            this.builder.buildArchive(this.descr, monitor);
        }

        public void run() {
            ArchiveBuildException buildExc = null;
            try {
                this.run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (InvocationTargetException e) {
                Throwable buildException = e.getTargetException();
                buildExc = buildException instanceof ArchiveBuildException ? (ArchiveBuildException)buildException : new ArchiveBuildException(buildException);
            }
            catch (InterruptedException e) {
                buildExc = new ArchiveBuildException(e);
            }
            if (buildExc != null) {
                throw buildExc;
            }
        }
    }
}

