/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.addlib.util;

import com.tssap.tools.addlib.AddLibManager;
import com.tssap.tools.addlib.IAddLib;
import com.tssap.tools.addlib.IAddLibDefinition;
import com.tssap.tools.addlib.ILibraryProjectAddLib;
import com.tssap.tools.addlib.ILibraryProjectSupport;
import com.tssap.tools.addlib.internal.AddLibCompInfo;
import com.tssap.tools.addlib.internal.AddLibDefinition;
import com.tssap.util.projectinfo.ComplexInfo;
import com.tssap.util.projectinfo.ProjectInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class ProjectClasspathHandler {
    private static ProjectClasspathHandler handlerSingleton;

    private ProjectClasspathHandler() {
        ProjectInfo.addComplexInfoHandler((String)AddLibCompInfo.INFO_ID, (ComplexInfo)new AddLibCompInfo());
    }

    protected static ProjectClasspathHandler getInstance() {
        if (handlerSingleton == null) {
            handlerSingleton = new ProjectClasspathHandler();
        }
        return handlerSingleton;
    }

    protected IAddLibDefinition[] getAddLibDefsOfProj(IJavaProject project) {
        Object ciObj = ProjectInfo.getComplexInfo((IProject)project.getProject(), (String)AddLibCompInfo.INFO_ID);
        IAddLibDefinition[] ret = ciObj instanceof AddLibCompInfo ? ((AddLibCompInfo)((Object)ciObj)).getAddLibs() : new AddLibDefinition[]{};
        return ret;
    }

    public static IAddLibDefinition[] getAddLibDefinitionsOfProject(IJavaProject project) {
        return ProjectClasspathHandler.getInstance().getAddLibDefsOfProj(project);
    }

    protected void setAddLibsOfProj(IJavaProject project, IAddLib[] addLibs, boolean updateClasspath) {
        AddLibCompInfo ci = new AddLibCompInfo(addLibs);
        ProjectInfo.setComplexInfo((IProject)project.getProject(), (ComplexInfo)ci, (String)AddLibCompInfo.INFO_ID);
        if (updateClasspath) {
            this.updateClasspath(project, addLibs);
        }
    }

    public static void setAddLibsOfProject(IJavaProject project, IAddLib[] addLibs, boolean updateClasspath) {
        ProjectClasspathHandler.getInstance().setAddLibsOfProj(project, addLibs, updateClasspath);
    }

    private void updateClasspath(IJavaProject project, IAddLib[] newAddLibs) {
        try {
            Vector<IClasspathEntry> clEntryVector = new Vector<IClasspathEntry>();
            ILibraryProjectSupport libSupport = AddLibManager.getLibraryProjectSupport();
            IClasspathEntry[] clEntries = project.getRawClasspath();
            int cle = 0;
            while (cle < clEntries.length) {
                IClasspathEntry clEntry = clEntries[cle];
                String firstSegmentOfPath = clEntry.getPath().segment(0);
                boolean isLibProjRef = false;
                if (clEntry.getEntryKind() == 2) {
                    IProject refPrj = ResourcesPlugin.getWorkspace().getRoot().getProject(firstSegmentOfPath);
                    boolean bl = isLibProjRef = libSupport != null && refPrj != null ? libSupport.isLibraryProject(refPrj) : false;
                }
                if (!(firstSegmentOfPath.equals("SAP_USER_ADD_LIBS") || firstSegmentOfPath.equals("SAP_SYSTEM_ADD_LIBS") || firstSegmentOfPath.equals("SAP_ENGINE_ADD_LIBS") || isLibProjRef)) {
                    clEntryVector.add(clEntry);
                }
                ++cle;
            }
            IProjectDescription prjDescr = null;
            boolean descrChanged = false;
            try {
                prjDescr = project.getProject().getDescription();
            }
            catch (CoreException e) {
                AddLibManager.getTracer().warning("Error getting project description from project " + project.getProject().getName());
            }
            if (libSupport != null && prjDescr != null) {
                IProject[] refProjs = prjDescr.getReferencedProjects();
                ArrayList<IProject> refProjList = null;
                int i = 0;
                while (i < refProjs.length) {
                    if (libSupport.isLibraryProject(refProjs[i])) {
                        if (refProjList == null) {
                            refProjList = new ArrayList<IProject>(Arrays.asList(refProjs));
                            descrChanged = true;
                        }
                        refProjList.remove(refProjs[i]);
                    }
                    ++i;
                }
                if (refProjList != null) {
                    prjDescr.setReferencedProjects(refProjList.toArray(new IProject[refProjList.size()]));
                }
            }
            int selAL = 0;
            while (selAL < newAddLibs.length) {
                IAddLib addLib = newAddLibs[selAL];
                if (addLib.getAddLibType() == 2 || addLib.getAddLibType() == 3) {
                    IPath[] clPathJars = addLib.getClassPathJars();
                    int jp = 0;
                    while (jp < clPathJars.length) {
                        IClasspathEntry entry = JavaCore.newVariableEntry((IPath)clPathJars[jp], null, null);
                        clEntryVector.add(entry);
                        ++jp;
                    }
                } else if (addLib.getAddLibType() == 1) {
                    IProject prj = ((ILibraryProjectAddLib)addLib).getLibraryProject();
                    IProject[] prjRefs = prjDescr.getReferencedProjects();
                    IProject[] newPrjRefs = new IProject[prjRefs.length + 1];
                    System.arraycopy(prjRefs, 0, newPrjRefs, 0, prjRefs.length);
                    newPrjRefs[newPrjRefs.length - 1] = prj;
                    prjDescr.setReferencedProjects(newPrjRefs);
                    descrChanged = true;
                    IClasspathEntry newCpEntry = JavaCore.newProjectEntry((IPath)prj.getFullPath());
                    clEntryVector.add(newCpEntry);
                }
                ++selAL;
            }
            IClasspathEntry[] newEntries = clEntryVector.toArray(new IClasspathEntry[0]);
            project.setRawClasspath(newEntries, (IProgressMonitor)new NullProgressMonitor());
            if (descrChanged) {
                try {
                    project.getProject().setDescription(prjDescr, 3, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    AddLibManager.getTracer().warning("Error setting project description from project " + project.getProject().getName());
                }
            }
        }
        catch (JavaModelException ex) {
            AddLibManager.getTracer().error("Cannot compute classpath of java project", (Throwable)ex);
        }
    }
}

