/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.addlib.util;

import com.tssap.tools.addlib.AddLibManager;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.ClasspathVariableInitializer;
import org.eclipse.jdt.core.JavaCore;

public class ClasspathVarInitializer
extends ClasspathVariableInitializer {
    public static final String USER_ADD_LIBS_VARIABLE = "SAP_USER_ADD_LIBS";
    public static final String SYSTEM_ADD_LIBS_VARIABLE = "SAP_SYSTEM_ADD_LIBS";
    public static final String ENGINE_ADD_LIBS_VARIABLE = "SAP_ENGINE_ADD_LIBS";
    public static final String AP_PLUGIN_ID = "com.sap.tc.ap";
    public static final String USER_PATH = "c:\\temp";

    public void initialize(String variable) {
        try {
            if (variable.equals(SYSTEM_ADD_LIBS_VARIABLE)) {
                Plugin apPlugin = Platform.getPlugin((String)AP_PLUGIN_ID);
                if (apPlugin == null) {
                    this.setJREVariable((IPath)new Path(""), variable);
                } else {
                    URL pluginUrl = Platform.resolve((URL)apPlugin.getDescriptor().getInstallURL());
                    Path newPath = new Path(pluginUrl.getFile());
                    this.setJREVariable((IPath)newPath, variable);
                }
            }
            if (!this.exsitsJREVariable(USER_ADD_LIBS_VARIABLE)) {
                this.setJREVariable((IPath)new Path(USER_PATH), USER_ADD_LIBS_VARIABLE);
            }
        }
        catch (CoreException e) {
            AddLibManager.getTracer().error("Got core excetption when setting classpath variables", (Throwable)e);
        }
        catch (IOException e) {
            AddLibManager.getTracer().error("Got i/o excetption when setting classpath variables", (Throwable)e);
        }
    }

    private void setJREVariable(IPath newPath, String var) throws CoreException {
        if (this.changedJREVariable(newPath, var)) {
            JavaCore.setClasspathVariable((String)var, (IPath)newPath, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private boolean changedJREVariable(IPath newPath, String var) throws CoreException {
        IPath oldPath = JavaCore.getClasspathVariable((String)var);
        return !newPath.equals((Object)oldPath);
    }

    private boolean exsitsJREVariable(String var) throws CoreException {
        IPath oldPath = JavaCore.getClasspathVariable((String)var);
        return oldPath != null;
    }
}

