/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.addlib.internal;

import com.tssap.tools.addlib.AddLibManager;
import com.tssap.tools.addlib.IAddLib;
import com.tssap.tools.addlib.IAddLibSearcher;
import com.tssap.tools.addlib.internal.LocalAddLib;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class LocalAddLibSearcher
implements IAddLibSearcher {
    public static final String DCDEF_FILENAME = ".dcdef";
    public static final String JAR_FILE_ENDING = ".jar";
    private static FileFilter dcdefFilter = new InnerDcdefFileFilter();
    private static FileFilter jarFilter = new InnerJarFileFilter();
    private static final String DEV_COMP = "development-component";
    private static final String COMP_TYPE = "component-type";
    private static final String VENDOR = "vendor";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String TYPE_CONTENT = "J2EE Server Component";
    private static final String SUB_TYPE = "sub-type";
    private static final String SPEC_SUB_DIR = "/gen/default/public";
    private IAddLib[] myCache;
    private String classPathVariable;
    private IPath classPathValue;

    public LocalAddLibSearcher(String classPathVar) {
        this.classPathVariable = classPathVar;
    }

    public String getClassPathVariable() {
        return this.classPathVariable;
    }

    public String getName() {
        return "Local additional library searcher for : " + this.getClassPathVariable();
    }

    public IAddLib[] searchAddLibs() {
        IAddLib[] ret;
        if (this.myCache != null && this.isUpToDate()) {
            ret = this.myCache;
        } else {
            IPath topLevelPath;
            Vector addLibVector = new Vector();
            this.classPathValue = topLevelPath = JavaCore.getClasspathVariable((String)this.getClassPathVariable());
            if (topLevelPath != null) {
                File topLevelFile = topLevelPath.toFile();
                this.searchDcdefFiles(topLevelFile, "/", addLibVector);
            }
            this.myCache = new IAddLib[addLibVector.size()];
            this.myCache = addLibVector.toArray(this.myCache);
            ret = this.myCache;
        }
        return ret;
    }

    public boolean isUpToDate() {
        IPath currentPath = JavaCore.getClasspathVariable((String)this.getClassPathVariable());
        boolean ret = currentPath != null ? currentPath.equals((Object)this.classPathValue) : this.classPathValue == null;
        return ret &= this.myCache != null;
    }

    public void reset() {
        this.myCache = null;
    }

    private void searchDcdefFiles(File root, String currentPath, Vector alVec) {
        if (root.isDirectory()) {
            File[] files = root.listFiles(dcdefFilter);
            int fi = 0;
            while (fi < files.length) {
                File file = files[fi];
                if (!file.isDirectory() && file.getName().equals(DCDEF_FILENAME)) {
                    this.analyseDcdefFile(root, file, currentPath, alVec);
                }
                if (file.isDirectory()) {
                    this.searchDcdefFiles(file, currentPath + "/" + file.getName(), alVec);
                }
                ++fi;
            }
        }
    }

    private void analyseDcdefFile(File root, File dcdefFile, String currentPath, Vector alVec) {
        try {
            FileReader dcdefFileReader = new FileReader(dcdefFile);
            XMLMemento dcdefMemento = XMLMemento.createReadRoot((Reader)dcdefFileReader);
            if (dcdefMemento.getID() != null) {
                IMemento typeMemento;
                IMemento compTypeMemento = dcdefMemento.getChild(COMP_TYPE);
                if (compTypeMemento != null && (typeMemento = compTypeMemento.getChild(TYPE)) != null && TYPE_CONTENT.equals(typeMemento.getTextData())) {
                    String vendorName = dcdefMemento.getChild(VENDOR) != null ? dcdefMemento.getChild(VENDOR).getTextData() : "?";
                    String componentName = dcdefMemento.getChild(NAME) != null ? dcdefMemento.getChild(NAME).getTextData() : "?";
                    Vector jarFiles = new Vector();
                    this.searchForJarsInDefinedSubDirs(root, currentPath, jarFiles);
                    IPath[] jarFilePaths = new IPath[jarFiles.size()];
                    jarFilePaths = jarFiles.toArray(jarFilePaths);
                    int subType = 1;
                    String subTypeStr = null;
                    IMemento subTypeMemento = compTypeMemento.getChild(SUB_TYPE);
                    if (subTypeMemento != null) {
                        subTypeStr = subTypeMemento.getTextData();
                        if ("Library".equals(subTypeStr)) {
                            subType = 2;
                        } else if ("Interface".equals(subTypeStr)) {
                            subType = 3;
                        } else if ("Service".equals(subTypeStr)) {
                            subType = 4;
                        }
                    }
                    if (subType == 1) {
                        AddLibManager.getTracer().info("Unknown sub-type : " + subTypeStr);
                    } else {
                        LocalAddLib newAddLib = new LocalAddLib(vendorName, componentName, jarFilePaths, subType);
                        alVec.add(newAddLib);
                    }
                }
            } else {
                AddLibManager.getTracer().error("Tag not found in xml : development-component");
            }
        }
        catch (FileNotFoundException ioex) {
            AddLibManager.getTracer().error("During analysis of dcdef file ", (Throwable)ioex);
        }
        catch (WorkbenchException wex) {
            AddLibManager.getTracer().error("During analysis of dcdef file ", (Throwable)wex);
        }
    }

    private void searchForJarsInDefinedSubDirs(File root, String currentPath, Vector jarFileVec) {
        File subFile = new File(root, SPEC_SUB_DIR);
        if (subFile.exists()) {
            this.searchForJarsInAllSubDirs(subFile, currentPath + SPEC_SUB_DIR, jarFileVec);
        }
    }

    private void searchForJarsInAllSubDirs(File root, String currentPath, Vector jarFileVec) {
        if (root.isDirectory()) {
            File[] files = root.listFiles(jarFilter);
            int fi = 0;
            while (fi < files.length) {
                File file = files[fi];
                if (!file.isDirectory() && file.getName().endsWith(JAR_FILE_ENDING)) {
                    Path foundJar = new Path(this.getClassPathVariable() + currentPath + "/" + file.getName());
                    jarFileVec.add(foundJar);
                }
                if (file.isDirectory()) {
                    String updatedName = currentPath + "/" + file.getName();
                    this.searchForJarsInAllSubDirs(file, updatedName, jarFileVec);
                }
                ++fi;
            }
        }
    }

    private static class InnerJarFileFilter
    implements FileFilter {
        private InnerJarFileFilter() {
        }

        public boolean accept(File fil) {
            boolean acceptFlag = fil.isDirectory() || fil.getName().endsWith(LocalAddLibSearcher.JAR_FILE_ENDING);
            return acceptFlag;
        }
    }

    private static class InnerDcdefFileFilter
    implements FileFilter {
        private InnerDcdefFileFilter() {
        }

        public boolean accept(File fil) {
            boolean acceptFlag = fil.isDirectory() || fil.getName().equals(LocalAddLibSearcher.DCDEF_FILENAME);
            return acceptFlag;
        }
    }
}

