/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.addlib.internal;

import com.tssap.tools.addlib.IAddLibDefinition;
import com.tssap.tools.addlib.internal.AddLibDefinition;
import com.tssap.util.projectinfo.ComplexInfo;
import org.eclipse.ui.IMemento;

public class AddLibCompInfo
extends ComplexInfo {
    private static String ADDLIB_TAG = "AddLib";
    public static String INFO_ID = "AddLibs";
    IAddLibDefinition[] myAddLibs;

    public AddLibCompInfo() {
        this(new IAddLibDefinition[0]);
    }

    public AddLibCompInfo(IAddLibDefinition[] addLibs) {
        this.setAddLibs(addLibs);
    }

    public IAddLibDefinition[] getAddLibs() {
        return this.myAddLibs;
    }

    public void setAddLibs(IAddLibDefinition[] libs) {
        if (libs == null) {
            throw new IllegalArgumentException("Argument must not be null");
        }
        this.myAddLibs = libs;
    }

    public Object createInfoObject(IMemento memento) {
        AddLibCompInfo ret;
        if (memento != null) {
            IMemento[] propMems = memento.getChildren(ADDLIB_TAG);
            IAddLibDefinition[] addLibs = new IAddLibDefinition[propMems.length];
            int i = 0;
            while (i < addLibs.length) {
                String name = propMems[i].getString("name");
                String vendor = propMems[i].getString("vendor");
                addLibs[i] = new AddLibDefinition(vendor, name);
                ++i;
            }
            ret = new AddLibCompInfo(addLibs);
        } else {
            ret = new AddLibCompInfo();
        }
        return ret;
    }

    public void saveState(IMemento memento) {
        if (this.myAddLibs != null) {
            int i = 0;
            while (i < this.myAddLibs.length) {
                String name = this.myAddLibs[i].getName();
                String vendor = this.myAddLibs[i].getVendor();
                IMemento propMem = memento.createChild(ADDLIB_TAG);
                propMem.putString("name", name);
                propMem.putString("vendor", vendor);
                ++i;
            }
        }
    }
}

