/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.addlib;

import com.tssap.tools.addlib.IAddLib;
import com.tssap.tools.addlib.IAddLibManager;
import com.tssap.tools.addlib.IAddLibSearcher;
import com.tssap.tools.addlib.ILibraryProjectSupport;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class AddLibManager
implements IAddLibManager {
    private static final String LIBRARY_PROJECT_SUPPORT_CLASS = "com.tssap.j2ee.library.LibrarySupport";
    private static final String LIBRARY_PLUGIN_ID = "com.tssap.j2ee.library";
    private static ILibraryProjectSupport librarySupport;
    private static AddLibManager manager;
    private static Comparator addLibComparator;
    private Vector searcherVector = new Vector();
    private IAddLib[] addLibs = new IAddLib[0];
    private boolean isReseted = true;
    private static TracerI addLibTracer;
    static /* synthetic */ Class class$com$tssap$tools$addlib$AddLibManager;

    private AddLibManager() {
    }

    public static IAddLibManager getManager() {
        if (manager == null) {
            manager = new AddLibManager();
        }
        return manager;
    }

    public static ILibraryProjectSupport getLibraryProjectSupport() {
        if (librarySupport == null) {
            String msg = null;
            try {
                ClassLoader cl;
                Class<?> libSupportClass;
                Plugin plugin = Platform.getPlugin((String)LIBRARY_PLUGIN_ID);
                if (plugin == null) {
                    msg = "com.tssap.j2ee.library not availible";
                }
                if ((libSupportClass = (cl = plugin.getDescriptor().getPluginClassLoader()).loadClass(LIBRARY_PROJECT_SUPPORT_CLASS)) == null) {
                    msg = "Class com.tssap.j2ee.library.LibrarySupport not availible";
                }
                Object libSupport = null;
                libSupport = libSupportClass.newInstance();
                if (libSupport instanceof ILibraryProjectSupport) {
                    librarySupport = libSupport;
                }
            }
            catch (Exception e) {
                if (msg == null) {
                    msg = e.getMessage();
                }
                AddLibManager.getTracer().warning("Library project searcher not availible: " + msg);
            }
        }
        return librarySupport;
    }

    public IAddLib[] getAddLibs() {
        IAddLib[] ret = null;
        boolean shortRun = true;
        IAddLibSearcher[] searchers = this.getSearchers();
        int i = 0;
        while (i < searchers.length && shortRun) {
            shortRun &= searchers[i].isUpToDate();
            ++i;
        }
        if (!shortRun) {
            Display displ = Display.getCurrent();
            if (displ == null) {
                displ = Display.getDefault();
            }
            final ArrayList resultList = new ArrayList();
            BusyIndicator.showWhile((Display)displ, (Runnable)new Runnable(){

                public void run() {
                    IAddLib[] libs = AddLibManager.this.searchAddLibs();
                    resultList.addAll(Arrays.asList(libs));
                }
            });
            ret = resultList.toArray(new IAddLib[resultList.size()]);
        } else {
            ret = this.searchAddLibs();
        }
        return ret;
    }

    public static IAddLib[] getAddLibsByType(int addLibType, IAddLib[] libs) {
        Vector<IAddLib> libVec = new Vector<IAddLib>();
        int i = 0;
        while (i < libs.length) {
            if (libs[i].getAddLibType() == addLibType) {
                libVec.add(libs[i]);
            }
            ++i;
        }
        return libVec.toArray(new IAddLib[libVec.size()]);
    }

    public static String[] getAddLibVendors(IAddLib[] libs) {
        String[] vendors = new String[]{};
        HashSet<String> vendorSet = new HashSet<String>();
        int l = 0;
        while (l < libs.length) {
            IAddLib lib = libs[l];
            vendorSet.add(lib.getVendor());
            ++l;
        }
        vendors = ((AbstractCollection)vendorSet).toArray(vendors);
        return vendors;
    }

    public static IAddLib[] getAddLibsByVendor(String vendor, IAddLib[] libs) {
        IAddLib[] vendorLibs = new IAddLib[]{};
        Vector<IAddLib> libVec = new Vector<IAddLib>();
        int l = 0;
        while (l < libs.length) {
            IAddLib lib = libs[l];
            if (vendor.equals(lib.getVendor())) {
                libVec.add(lib);
            }
            ++l;
        }
        vendorLibs = libVec.toArray(vendorLibs);
        return vendorLibs;
    }

    public static IAddLib getAddLibsByVendorAndName(String vendor, String name, IAddLib[] libs) {
        if (vendor == null || name == null || libs == null) {
            throw new IllegalArgumentException("Arguments must not be null");
        }
        IAddLib ret = null;
        IAddLib[] vendorLibs = AddLibManager.getAddLibsByVendor(vendor, libs);
        int i = 0;
        while (i < vendorLibs.length) {
            if (vendorLibs[i].getName() != null && vendorLibs[i].getName().equals(name)) {
                ret = vendorLibs[i];
            }
            ++i;
        }
        return ret;
    }

    public String[] getAddLibVendors() {
        IAddLib[] libs = this.getAddLibs();
        return AddLibManager.getAddLibVendors(libs);
    }

    public IAddLib[] getAddLibsByVendor(String vendor) {
        IAddLib[] libs = this.getAddLibs();
        return AddLibManager.getAddLibsByVendor(vendor, libs);
    }

    public IAddLib getAddLibsByVendorAndName(String vendor, String name) {
        IAddLib[] libs = this.getAddLibs();
        return AddLibManager.getAddLibsByVendorAndName(vendor, name, libs);
    }

    private synchronized IAddLib[] searchAddLibs() {
        TreeSet<IAddLib> addLibTS = new TreeSet<IAddLib>(addLibComparator);
        Iterator iter = ((AbstractList)this.getSearcherVector()).iterator();
        while (iter.hasNext()) {
            IAddLibSearcher searcher = (IAddLibSearcher)iter.next();
            IAddLib[] searchedLibs = searcher.searchAddLibs();
            int ele = 0;
            while (ele < searchedLibs.length) {
                addLibTS.add(searchedLibs[ele]);
                ++ele;
            }
        }
        return addLibTS.toArray(new IAddLib[0]);
    }

    public synchronized void resetSearchers() {
        IAddLibSearcher[] searchers = this.getSearchers();
        int i = 0;
        while (i < searchers.length) {
            searchers[i].reset();
            ++i;
        }
    }

    public void addSearcher(IAddLibSearcher newSearcher) {
        this.addSearcher(newSearcher, -1);
    }

    public void addSearcher(IAddLibSearcher newSearcher, int priority) {
        if (priority >= 0 && priority < this.getSearcherVector().size()) {
            this.getSearcherVector().insertElementAt(newSearcher, priority);
        } else {
            this.getSearcherVector().add(newSearcher);
        }
        this.resetSearchers();
    }

    public void removeSearcher(IAddLibSearcher remSearcher) {
        this.getSearcherVector().remove(remSearcher);
        this.resetSearchers();
    }

    public IAddLibSearcher[] getSearchers() {
        IAddLibSearcher[] searchers = this.getSearcherVector().toArray(new IAddLibSearcher[0]);
        return searchers;
    }

    private Vector getSearcherVector() {
        return this.searcherVector;
    }

    public static TracerI getTracer() {
        if (addLibTracer == null) {
            addLibTracer = TracingManager.getTracer((Class)(class$com$tssap$tools$addlib$AddLibManager == null ? (class$com$tssap$tools$addlib$AddLibManager = AddLibManager.class$("com.tssap.tools.addlib.AddLibManager")) : class$com$tssap$tools$addlib$AddLibManager));
        }
        return addLibTracer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        addLibComparator = new InnerTreeSetComparator();
    }

    private static class InnerTreeSetComparator
    implements Comparator {
        private InnerTreeSetComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            return this.specificCompare((IAddLib)arg0, (IAddLib)arg1);
        }

        public int specificCompare(IAddLib lib0, IAddLib lib1) {
            int vendorCompare = lib0.getVendor().compareTo(lib1.getVendor());
            if (vendorCompare != 0) {
                return vendorCompare;
            }
            int nameCompare = lib0.getName().compareTo(lib1.getName());
            return nameCompare;
        }
    }
}

