/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools;

import com.tssap.tools.ToolsPlugin;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLUtil {
    private static DocumentBuilderFactory myBuilderFactory;
    private static DocumentBuilder myBuilder;
    static /* synthetic */ Class class$com$tssap$tools$XMLUtil;

    private static DocumentBuilder getDocumentBuilder() {
        if (myBuilder == null) {
            try {
                DocumentBuilderFactory dbf = XMLUtil.getDBF();
                if (dbf != null) {
                    myBuilder = dbf.newDocumentBuilder();
                }
            }
            catch (ParserConfigurationException e) {
                ToolsPlugin.tracer.error(class$com$tssap$tools$XMLUtil == null ? (class$com$tssap$tools$XMLUtil = XMLUtil.class$("com.tssap.tools.XMLUtil")) : class$com$tssap$tools$XMLUtil, "getDocumentBuilder()", "Error creating DocumentBuilder", (Throwable)e);
            }
        }
        return myBuilder;
    }

    private static DocumentBuilderFactory getDBF() {
        if (myBuilderFactory == null) {
            myBuilderFactory = XMLUtil.createDBF();
        }
        return myBuilderFactory;
    }

    private static DocumentBuilderFactory createDBF() {
        DocumentBuilderFactoryImpl dbf = new DocumentBuilderFactoryImpl();
        return dbf;
    }

    public static Document createNewDocument() {
        Document ret = null;
        ret = XMLUtil.getDocumentBuilder().newDocument();
        return ret;
    }

    public static Document parse(File f) throws SAXException, IOException {
        Document doc = null;
        if (XMLUtil.getDocumentBuilder() != null) {
            doc = XMLUtil.getDocumentBuilder().parse(f);
        }
        return doc;
    }

    public static String serialize(Document doc) {
        String ret = null;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        XMLUtil.serialize(doc, outStream);
        ret = outStream.toString();
        return ret;
    }

    public static void serialize(Document doc, File f) {
        try {
            FileOutputStream outStream = new FileOutputStream(f);
            XMLUtil.serialize(doc, outStream);
            outStream.close();
        }
        catch (FileNotFoundException e) {
            ToolsPlugin.tracer.error(class$com$tssap$tools$XMLUtil == null ? (class$com$tssap$tools$XMLUtil = XMLUtil.class$("com.tssap.tools.XMLUtil")) : class$com$tssap$tools$XMLUtil, "serialize(Document doc, File f)", "Error serializing Document", (Throwable)e);
        }
        catch (IOException e) {
            ToolsPlugin.tracer.error(class$com$tssap$tools$XMLUtil == null ? (class$com$tssap$tools$XMLUtil = XMLUtil.class$("com.tssap.tools.XMLUtil")) : class$com$tssap$tools$XMLUtil, "serialize(Document doc, File f)", "Error serializing Document", (Throwable)e);
        }
    }

    public static void serialize(Document doc, OutputStream outStream) {
        SerializerFactory seriFact = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Object var6_4;
            try {
                Thread.currentThread().setContextClassLoader((class$com$tssap$tools$XMLUtil == null ? (class$com$tssap$tools$XMLUtil = XMLUtil.class$("com.tssap.tools.XMLUtil")) : class$com$tssap$tools$XMLUtil).getClassLoader());
                seriFact = SerializerFactory.getSerializerFactory((String)"xml");
            }
            catch (Exception e) {
                ToolsPlugin.tracer.error(class$com$tssap$tools$XMLUtil == null ? (class$com$tssap$tools$XMLUtil = XMLUtil.class$("com.tssap.tools.XMLUtil")) : class$com$tssap$tools$XMLUtil, "serialize(Document doc, OutputStream outStream)", "Unable to create SerializerFactory");
                var6_4 = null;
                Thread.currentThread().setContextClassLoader(cl);
            }
            var6_4 = null;
            Thread.currentThread().setContextClassLoader(cl);
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            Thread.currentThread().setContextClassLoader(cl);
            throw throwable;
        }
        if (seriFact != null) {
            OutputFormat outFormat = new OutputFormat(doc);
            outFormat.setIndent(2);
            Serializer seri = seriFact.makeSerializer(outFormat);
            seri.setOutputByteStream(outStream);
            try {
                seri.asDOMSerializer().serialize(doc);
            }
            catch (IOException e) {
                ToolsPlugin.tracer.error(class$com$tssap$tools$XMLUtil == null ? (class$com$tssap$tools$XMLUtil = XMLUtil.class$("com.tssap.tools.XMLUtil")) : class$com$tssap$tools$XMLUtil, "serialize(Document doc, OutputStream outStream)", "Error serializing Document", (Throwable)e);
            }
        }
    }

    public static Element[] getElementsFromNodeList(NodeList rootChildren) {
        ArrayList<Node> elementList = new ArrayList<Node>();
        int i = 0;
        while (i < rootChildren.getLength()) {
            if (rootChildren.item(i).getNodeType() == 1) {
                elementList.add(rootChildren.item(i));
            }
            ++i;
        }
        return elementList.toArray(new Element[elementList.size()]);
    }

    public static Element findElement(Element root, String elementName) {
        Element ret = null;
        if (root.getNodeName().equals(elementName)) {
            ret = root;
        } else {
            Element[] children = XMLUtil.getElementsFromNodeList(root.getChildNodes());
            int i = 0;
            while (i < children.length && ret != null) {
                if (children[i].getNodeName().equals(elementName)) {
                    ret = children[i];
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < children.length && ret != null) {
                ret = XMLUtil.findElement(children[i2], elementName);
                ++i2;
            }
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

