/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.snippeteditor;

import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompletionRequestor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.template.ContextType;
import org.eclipse.jdt.internal.corext.template.ContextTypeRegistry;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.JavaSnippetEditor;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.SnippetMessages;
import org.eclipse.jdt.internal.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposalComparator;
import org.eclipse.jdt.internal.ui.text.java.JavaParameterListValidator;
import org.eclipse.jdt.internal.ui.text.java.ResultCollector;
import org.eclipse.jdt.internal.ui.text.template.TemplateEngine;
import org.eclipse.jdt.internal.ui.text.template.TemplateProposal;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.widgets.Shell;

public class JavaSnippetCompletionProcessor
implements IContentAssistProcessor {
    private ResultCollector fCollector = new ResultCollector();
    private JavaSnippetEditor fEditor;
    private IContextInformationValidator fValidator;
    private TemplateEngine fTemplateEngine;
    private JavaCompletionProposalComparator fComparator;
    private char[] fProposalAutoActivationSet;

    public JavaSnippetCompletionProcessor(JavaSnippetEditor editor) {
        this.fEditor = editor;
        ContextType contextType = ContextTypeRegistry.getInstance().getContextType("java");
        if (contextType != null) {
            this.fTemplateEngine = new TemplateEngine(contextType);
        }
        this.fComparator = new JavaCompletionProposalComparator();
    }

    public String getErrorMessage() {
        return this.fCollector.getErrorMessage();
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this.fValidator == null) {
            this.fValidator = new JavaParameterListValidator();
        }
        return this.fValidator;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int position) {
        try {
            this.fCollector.reset(position, this.fEditor.findJavaProject(), null);
            this.fEditor.codeComplete((ICompletionRequestor)this.fCollector);
        }
        catch (JavaModelException x) {
            Shell shell = viewer.getTextWidget().getShell();
            ErrorDialog.openError((Shell)shell, (String)SnippetMessages.getString("CompletionProcessor.errorTitle"), (String)SnippetMessages.getString("CompletionProcessor.errorMessage"), (IStatus)x.getStatus());
            JDIDebugUIPlugin.log(x);
        }
        JavaCompletionProposal[] results = this.fCollector.getResults();
        if (this.fTemplateEngine != null) {
            try {
                this.fTemplateEngine.reset();
                this.fTemplateEngine.complete(viewer, position, null);
            }
            catch (JavaModelException x) {
                JDIDebugUIPlugin.log(x);
                Shell shell = viewer.getTextWidget().getShell();
                ErrorDialog.openError((Shell)shell, (String)SnippetMessages.getString("CompletionProcessor.errorTitle"), (String)SnippetMessages.getString("CompletionProcessor.errorMessage"), (IStatus)x.getStatus());
            }
            TemplateProposal[] templateResults = this.fTemplateEngine.getResults();
            IJavaCompletionProposal[] total = new IJavaCompletionProposal[results.length + templateResults.length];
            System.arraycopy(templateResults, 0, total, 0, templateResults.length);
            System.arraycopy(results, 0, total, templateResults.length, results.length);
            results = total;
        }
        return this.order((IJavaCompletionProposal[])results);
    }

    private ICompletionProposal[] order(IJavaCompletionProposal[] proposals) {
        Arrays.sort(proposals, this.fComparator);
        return proposals;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.fProposalAutoActivationSet = activationSet;
    }

    public void orderProposalsAlphabetically(boolean order) {
        this.fComparator.setOrderAlphabetically(order);
    }
}

