/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.monitors;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.internal.ui.views.AbstractDebugEventHandler;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.internal.debug.ui.monitors.MonitorManager;
import org.eclipse.jdt.internal.debug.ui.monitors.MonitorsView;

public class MonitorsDebugEventHandler
extends AbstractDebugEventHandler {
    public MonitorsDebugEventHandler(MonitorsView view) {
        super((AbstractDebugView)view);
    }

    protected void doHandleDebugEvents(DebugEvent[] events) {
        boolean monitorInformationAvailable = true;
        boolean updateNeeded = false;
        int i = 0;
        while (i < events.length) {
            IJavaDebugTarget target;
            DebugEvent event = events[i];
            Object source = event.getSource();
            if (event.getKind() == 2) {
                if (source instanceof IJavaDebugTarget) {
                    target = (IJavaDebugTarget)source;
                    monitorInformationAvailable = target.supportsMonitorInformation();
                    if (monitorInformationAvailable) {
                        MonitorManager.getDefault().updatePartial(target);
                        updateNeeded = true;
                    }
                } else if (source instanceof IJavaThread && (monitorInformationAvailable = (target = (IJavaDebugTarget)((IJavaThread)source).getDebugTarget()).supportsMonitorInformation())) {
                    MonitorManager.getDefault().updatePartial(target);
                    updateNeeded = true;
                }
            } else if (event.getKind() == 1) {
                if (source instanceof IJavaDebugTarget) {
                    target = (IJavaDebugTarget)source;
                    monitorInformationAvailable = target.supportsMonitorInformation();
                    if (monitorInformationAvailable) {
                        MonitorManager.getDefault().updatePartial((IJavaDebugTarget)source);
                        updateNeeded = true;
                    }
                } else if (source instanceof IJavaThread && (monitorInformationAvailable = (target = (IJavaDebugTarget)((IJavaThread)source).getDebugTarget()).supportsMonitorInformation())) {
                    MonitorManager.getDefault().updatePartial((IJavaDebugTarget)((IJavaThread)source).getDebugTarget());
                    updateNeeded = true;
                }
            } else if (event.getKind() == 8 && source instanceof IJavaDebugTarget) {
                MonitorManager.getDefault().removeMonitorInformation((IJavaDebugTarget)source);
                updateNeeded = true;
            }
            ++i;
        }
        if (updateNeeded) {
            ((MonitorsView)this.getView()).refreshCurrentViewer(monitorInformationAvailable, false);
        }
    }

    public void refresh() {
        ((MonitorsView)this.getView()).selectionChanged(null, this.getView().getSite().getPage().getSelection("org.eclipse.debug.ui.DebugView"));
    }
}

