/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class ZipTreeNode {
    private ZipTreeNode fParent;
    private List fChildren;
    private String fName;
    private boolean fRepresentsZip = false;
    private static final String SEGMENT_SEPARATOR = "/";

    private ZipTreeNode(ZipTreeNode parent, String name) {
        this.fParent = parent;
        this.fChildren = new ArrayList(0);
        this.fName = name;
    }

    String getName() {
        return this.fName;
    }

    boolean representsZipFile() {
        return this.fRepresentsZip;
    }

    boolean hasChildren() {
        return this.fChildren != null && !this.fChildren.isEmpty();
    }

    Object[] getChildren() {
        return this.fChildren.toArray();
    }

    Object getParent() {
        return this.fParent;
    }

    private static int separatorIndex(String name) {
        return name.indexOf(SEGMENT_SEPARATOR);
    }

    private static String getFirstSegment(String name) {
        if (ZipTreeNode.separatorIndex(name) == -1) {
            return name;
        }
        return name.substring(0, ZipTreeNode.separatorIndex(name));
    }

    private static String getTail(String name) {
        return name.substring(ZipTreeNode.separatorIndex(name) + 1);
    }

    private boolean isRoot() {
        return this.fName == null;
    }

    ZipTreeNode findNode(String name) {
        if (this.isRoot()) {
            return ((ZipTreeNode)this.fChildren.get(0)).findNode(name);
        }
        if (this.representsZipFile() && "".equals(name)) {
            return this;
        }
        if (!this.representsZipFile() && ZipTreeNode.separatorIndex(name) == -1) {
            if (name.equals(this.fName)) {
                return this;
            }
            return null;
        }
        String firstSegment = ZipTreeNode.getFirstSegment(name);
        if (!this.representsZipFile() && !firstSegment.equals(this.fName)) {
            return null;
        }
        Object[] kids = this.getChildren();
        String tail = ZipTreeNode.getTail(name);
        int i = 0;
        while (i < kids.length) {
            ZipTreeNode found = this.representsZipFile() ? ((ZipTreeNode)kids[i]).findNode(name) : ((ZipTreeNode)kids[i]).findNode(tail);
            if (found != null) {
                return found;
            }
            ++i;
        }
        return null;
    }

    void insert(String name) {
        if ("".equals(name) || ZipTreeNode.separatorIndex(name) == -1) {
            return;
        }
        String firstSegment = ZipTreeNode.getFirstSegment(name);
        Object[] kids = this.getChildren();
        String tail = ZipTreeNode.getTail(name);
        int i = 0;
        while (i < kids.length) {
            ZipTreeNode each = (ZipTreeNode)kids[i];
            if (each.getName().equals(firstSegment)) {
                each.insert(tail);
                return;
            }
            ++i;
        }
        ZipTreeNode newKid = new ZipTreeNode(this, firstSegment);
        this.fChildren.add(newKid);
        newKid.insert(tail);
    }

    private StringBuffer toStringBuffer() {
        if (this.fName == null || this.representsZipFile()) {
            return new StringBuffer();
        }
        return this.fParent.toStringBuffer().append(this.fName).append(SEGMENT_SEPARATOR);
    }

    public String toString() {
        if (this.representsZipFile()) {
            return "";
        }
        StringBuffer sb = this.toStringBuffer();
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    static ZipTreeNode newZipTree(ZipFile file) {
        ZipTreeNode topLevel = new ZipTreeNode(null, null);
        ZipTreeNode zipNode = new ZipTreeNode(topLevel, file.getName());
        zipNode.fRepresentsZip = true;
        Enumeration<? extends ZipEntry> all = file.entries();
        while (all.hasMoreElements()) {
            ZipEntry each = all.nextElement();
            zipNode.insert(each.getName().substring(0, each.getName().lastIndexOf(SEGMENT_SEPARATOR) + 1));
        }
        ArrayList<ZipTreeNode> l = new ArrayList<ZipTreeNode>(1);
        l.add(zipNode);
        topLevel.fChildren = l;
        return topLevel;
    }
}

