/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import java.util.zip.ZipFile;
import org.eclipse.jdt.internal.debug.ui.launcher.ZipTreeNode;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

class ZipContentProvider
implements ITreeContentProvider {
    private ZipTreeNode fTree;
    private ZipFile fZipFile;

    ZipContentProvider() {
    }

    ZipTreeNode getSelectedNode(String initialSelection) {
        ZipTreeNode node = null;
        if (initialSelection != null) {
            node = this.fTree.findNode(initialSelection);
        }
        if (node == null) {
            node = this.fTree.findNode("");
        }
        return node;
    }

    void setInitialInput(ZipFile file) {
        this.fTree = this.createTree(file);
    }

    private ZipTreeNode createTree(ZipFile zipFile) {
        if (zipFile.equals(this.fZipFile)) {
            return this.fTree;
        }
        this.fZipFile = zipFile;
        return ZipTreeNode.newZipTree(zipFile);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof ZipFile) {
            this.fTree = this.createTree((ZipFile)newInput);
        } else {
            this.fTree = null;
            this.fZipFile = null;
        }
    }

    public Object getParent(Object element) {
        return ((ZipTreeNode)element).getParent();
    }

    public boolean hasChildren(Object element) {
        return ((ZipTreeNode)element).hasChildren();
    }

    public Object[] getChildren(Object element) {
        return ((ZipTreeNode)element).getChildren();
    }

    public Object[] getElements(Object zipFile) {
        if (this.fTree == null && zipFile instanceof ZipFile) {
            this.fTree = this.createTree((ZipFile)zipFile);
        }
        return this.fTree.getChildren();
    }

    public void dispose() {
        this.fTree = null;
        this.fZipFile = null;
    }
}

