/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.JavaLaunchConfigurationTab;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class WorkingDirectoryBlock
extends JavaLaunchConfigurationTab {
    protected Label fWorkingDirLabel;
    protected Button fLocalDirButton;
    protected Text fWorkingDirText;
    protected Button fWorkingDirBrowseButton;
    protected Button fWorkspaceDirButton;
    protected Text fWorkspaceDirText;
    protected Button fWorkspaceDirBrowseButton;
    protected Button fUseDefaultWorkingDirButton;
    protected ILaunchConfiguration fLaunchConfiguration;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite workingDirComp = new Composite(parent, 0);
        WorkbenchHelp.setHelp((Control)workingDirComp, (String)IJavaDebugHelpContextIds.WORKING_DIRECTORY_BLOCK);
        GridLayout workingDirLayout = new GridLayout();
        workingDirLayout.numColumns = 3;
        workingDirLayout.marginHeight = 0;
        workingDirLayout.marginWidth = 0;
        workingDirComp.setLayout((Layout)workingDirLayout);
        GridData gd = new GridData(768);
        workingDirComp.setLayoutData((Object)gd);
        workingDirComp.setFont(font);
        this.setControl((Control)workingDirComp);
        this.fWorkingDirLabel = new Label(workingDirComp, 0);
        this.fWorkingDirLabel.setText(LauncherMessages.getString("JavaArgumentsTab.Wor&king_directory__2"));
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.fWorkingDirLabel.setLayoutData((Object)gd);
        this.fWorkingDirLabel.setFont(font);
        this.fLocalDirButton = this.createRadioButton(workingDirComp, LauncherMessages.getString("WorkingDirectoryBlock.&Local_directory__1"));
        this.fLocalDirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                WorkingDirectoryBlock.this.handleLocationButtonSelected();
            }
        });
        this.fWorkingDirText = new Text(workingDirComp, 2052);
        gd = new GridData(768);
        this.fWorkingDirText.setLayoutData((Object)gd);
        this.fWorkingDirText.setFont(font);
        this.fWorkingDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                WorkingDirectoryBlock.this.updateLaunchConfigurationDialog();
            }
        });
        this.fWorkingDirBrowseButton = this.createPushButton(workingDirComp, LauncherMessages.getString("JavaArgumentsTab.&Browse_3"), null);
        this.fWorkingDirBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                WorkingDirectoryBlock.this.handleWorkingDirBrowseButtonSelected();
            }
        });
        this.fWorkspaceDirButton = this.createRadioButton(workingDirComp, LauncherMessages.getString("WorkingDirectoryBlock.Works&pace__2"));
        this.fWorkspaceDirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                WorkingDirectoryBlock.this.handleLocationButtonSelected();
            }
        });
        this.fWorkspaceDirText = new Text(workingDirComp, 2052);
        gd = new GridData(768);
        this.fWorkspaceDirText.setLayoutData((Object)gd);
        this.fWorkspaceDirText.setFont(font);
        this.fWorkspaceDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                WorkingDirectoryBlock.this.updateLaunchConfigurationDialog();
            }
        });
        this.fWorkspaceDirBrowseButton = this.createPushButton(workingDirComp, LauncherMessages.getString("WorkingDirectoryBlock.B&rowse..._3"), null);
        this.fWorkspaceDirBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                WorkingDirectoryBlock.this.handleWorkspaceDirBrowseButtonSelected();
            }
        });
        this.fUseDefaultWorkingDirButton = new Button(workingDirComp, 32);
        this.fUseDefaultWorkingDirButton.setText(LauncherMessages.getString("JavaArgumentsTab.Use_de&fault_working_directory_4"));
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.fUseDefaultWorkingDirButton.setLayoutData((Object)gd);
        this.fUseDefaultWorkingDirButton.setFont(font);
        this.fUseDefaultWorkingDirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                WorkingDirectoryBlock.this.handleUseDefaultWorkingDirButtonSelected();
            }
        });
    }

    public void dispose() {
    }

    protected void handleWorkingDirBrowseButtonSelected() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setMessage(LauncherMessages.getString("JavaArgumentsTab.Select_a_&working_directory_for_the_launch_configuration__7"));
        String currentWorkingDir = this.fWorkingDirText.getText();
        if (!currentWorkingDir.trim().equals("") && (path = new File(currentWorkingDir)).exists()) {
            dialog.setFilterPath(currentWorkingDir);
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.fWorkingDirText.setText(selectedDirectory);
        }
    }

    protected void handleWorkspaceDirBrowseButtonSelected() {
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, LauncherMessages.getString("WorkingDirectoryBlock.Select_a_&workspace_relative_working_directory__4"));
        IContainer currentContainer = this.getContainer();
        if (currentContainer != null) {
            IPath path = currentContainer.getFullPath();
            dialog.setInitialSelections(new Object[]{path});
        }
        dialog.showClosedProjects(false);
        dialog.open();
        Object[] results = dialog.getResult();
        if (results != null && results.length > 0 && results[0] instanceof IPath) {
            IPath path = (IPath)results[0];
            String containerName = path.makeRelative().toString();
            this.fWorkspaceDirText.setText(containerName);
        }
    }

    protected IContainer getContainer() {
        IResource res = this.getResource();
        if (res instanceof IContainer) {
            return (IContainer)res;
        }
        return null;
    }

    protected IResource getResource() {
        Path path = new Path(this.fWorkspaceDirText.getText());
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return root.findMember((IPath)path);
    }

    protected void handleLocationButtonSelected() {
        if (!this.isDefaultWorkingDirectory()) {
            boolean local = this.isLocalWorkingDirectory();
            this.fWorkingDirText.setEnabled(local);
            this.fWorkingDirBrowseButton.setEnabled(local);
            this.fWorkspaceDirText.setEnabled(!local);
            this.fWorkspaceDirBrowseButton.setEnabled(!local);
        }
        this.updateLaunchConfigurationDialog();
    }

    protected void handleUseDefaultWorkingDirButtonSelected() {
        if (this.isDefaultWorkingDirectory()) {
            this.setDefaultWorkingDir();
            this.fLocalDirButton.setEnabled(false);
            this.fWorkingDirText.setEnabled(false);
            this.fWorkingDirBrowseButton.setEnabled(false);
            this.fWorkspaceDirButton.setEnabled(false);
            this.fWorkspaceDirText.setEnabled(false);
            this.fWorkspaceDirBrowseButton.setEnabled(false);
        } else {
            this.fLocalDirButton.setEnabled(true);
            this.fWorkspaceDirButton.setEnabled(true);
            this.handleLocationButtonSelected();
        }
    }

    protected void setDefaultWorkingDir() {
        try {
            IJavaProject javaProject;
            ILaunchConfiguration config = this.getLaunchConfiguration();
            if (config != null && (javaProject = JavaRuntime.getJavaProject((ILaunchConfiguration)config)) != null) {
                this.fWorkspaceDirText.setText(javaProject.getPath().makeRelative().toOSString());
                this.fLocalDirButton.setSelection(false);
                this.fWorkspaceDirButton.setSelection(true);
                return;
            }
        }
        catch (CoreException coreException) {}
        this.fWorkingDirText.setText(System.getProperty("user.dir"));
        this.fLocalDirButton.setSelection(true);
        this.fWorkspaceDirButton.setSelection(false);
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.isLocalWorkingDirectory()) {
            String workingDirPath = this.fWorkingDirText.getText().trim();
            if (workingDirPath.length() > 0) {
                File dir = new File(workingDirPath);
                if (!dir.exists()) {
                    this.setErrorMessage(LauncherMessages.getString("JavaArgumentsTab.Working_directory_does_not_exist_10"));
                    return false;
                }
                if (!dir.isDirectory()) {
                    this.setErrorMessage(LauncherMessages.getString("JavaArgumentsTab.Working_directory_is_not_a_directory_11"));
                    return false;
                }
            }
        } else if (this.getContainer() == null) {
            this.setErrorMessage(LauncherMessages.getString("WorkingDirectoryBlock.Specified_project_or_folder_does_not_exist._5"));
            return false;
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, null);
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, null);
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, null);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setLaunchConfiguration(configuration);
        try {
            String wd = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, null);
            this.fWorkspaceDirText.setText("");
            this.fWorkingDirText.setText("");
            if (wd == null) {
                this.fUseDefaultWorkingDirButton.setSelection(true);
            } else {
                Path path = new Path(wd);
                if (path.isAbsolute()) {
                    this.fWorkingDirText.setText(wd);
                    this.fLocalDirButton.setSelection(true);
                    this.fWorkspaceDirButton.setSelection(false);
                } else {
                    this.fWorkspaceDirText.setText(wd);
                    this.fWorkspaceDirButton.setSelection(true);
                    this.fLocalDirButton.setSelection(false);
                }
                this.fUseDefaultWorkingDirButton.setSelection(false);
            }
            this.handleUseDefaultWorkingDirButtonSelected();
        }
        catch (CoreException e) {
            this.setErrorMessage(String.valueOf(LauncherMessages.getString("JavaArgumentsTab.Exception_occurred_reading_configuration___15")) + e.getStatus().getMessage());
            JDIDebugUIPlugin.log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String wd = null;
        if (!this.isDefaultWorkingDirectory()) {
            if (this.isLocalWorkingDirectory()) {
                wd = this.getAttributeValueFrom(this.fWorkingDirText);
            } else {
                Path path = new Path(this.fWorkspaceDirText.getText());
                path = path.makeRelative();
                wd = path.toString();
            }
        }
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, wd);
    }

    protected String getAttributeValueFrom(Text text) {
        String content = text.getText().trim();
        if (content.length() > 0) {
            return content;
        }
        return null;
    }

    public String getName() {
        return LauncherMessages.getString("WorkingDirectoryBlock.Working_Directory_8");
    }

    protected boolean isDefaultWorkingDirectory() {
        return this.fUseDefaultWorkingDirButton.getSelection();
    }

    protected boolean isLocalWorkingDirectory() {
        return this.fLocalDirButton.getSelection();
    }

    protected void setLaunchConfiguration(ILaunchConfiguration config) {
        this.fLaunchConfiguration = config;
    }

    protected ILaunchConfiguration getLaunchConfiguration() {
        return this.fLaunchConfiguration;
    }
}

