/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.debug.ui.IJavaDebugUIConstants;
import org.eclipse.jdt.internal.debug.ui.ExceptionHandler;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.AddVMDialog;
import org.eclipse.jdt.internal.debug.ui.launcher.IAddVMDialogRequestor;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.debug.ui.launcher.ListContentProvider;
import org.eclipse.jdt.internal.debug.ui.launcher.VMLabelProvider;
import org.eclipse.jdt.internal.launching.VMDefinitionsContainer;
import org.eclipse.jdt.launching.AbstractVMInstallType;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.help.WorkbenchHelp;

public class VMPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IAddVMDialogRequestor {
    private CheckboxTableViewer fVMList;
    private Button fAddButton;
    private Button fRemoveButton;
    private Button fEditButton;
    private Button fSearchButton;
    private IVMInstallType[] fVMTypes;
    private VMDefinitionsContainer fOriginalVMs;
    private List fVMStandins;
    private static String fgLastUsedID;

    public VMPreferencePage() {
        this.setTitle(LauncherMessages.getString("VMPreferencePage.Installed_JREs_1"));
        this.setDescription(LauncherMessages.getString("vmPreferencePage.message"));
        this.fVMTypes = JavaRuntime.getVMInstallTypes();
        this.fOriginalVMs = new VMDefinitionsContainer();
        IVMInstall def = JavaRuntime.getDefaultVMInstall();
        if (def != null) {
            this.fOriginalVMs.setDefaultVMInstallCompositeID(JavaRuntime.getCompositeIdFromVM((IVMInstall)def));
        }
        int i = 0;
        while (i < this.fVMTypes.length) {
            IVMInstall[] vms = this.fVMTypes[i].getVMInstalls();
            int j = 0;
            while (j < vms.length) {
                this.fOriginalVMs.addVM(vms[j]);
                ++j;
            }
            ++i;
        }
    }

    public void init(IWorkbench workbench) {
    }

    private void populateVMList() {
        JavaRuntime.getDefaultVMInstall();
        this.fVMStandins = new ArrayList();
        int i = 0;
        while (i < this.fVMTypes.length) {
            IVMInstall[] vmInstalls = this.fVMTypes[i].getVMInstalls();
            int j = 0;
            while (j < vmInstalls.length) {
                this.fVMStandins.add(new VMStandin(vmInstalls[j]));
                ++j;
            }
            ++i;
        }
        this.fVMList.setInput((Object)this.fVMStandins);
        this.initDefaultVM();
    }

    private void initDefaultVM() {
        IVMInstall realDefault = JavaRuntime.getDefaultVMInstall();
        if (realDefault != null) {
            Iterator iter = this.fVMStandins.iterator();
            while (iter.hasNext()) {
                IVMInstall fakeVM = (IVMInstall)iter.next();
                if (!this.isSameVM(fakeVM, realDefault)) continue;
                this.verifyDefaultVM(fakeVM);
                break;
            }
        }
    }

    protected Control createContents(Composite ancestor) {
        Font font = ancestor.getFont();
        this.initializeDialogUnits((Control)ancestor);
        this.noDefaultAndApplyButton();
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Label tableLabel = new Label(parent, 0);
        tableLabel.setText(LauncherMessages.getString("VMPreferencePage.Installed_&JREs__1"));
        GridData data = new GridData();
        data.horizontalSpan = 2;
        tableLabel.setLayoutData((Object)data);
        Table table = new Table(parent, 67618);
        data = new GridData(1808);
        table.setLayoutData((Object)data);
        table.setFont(font);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(LauncherMessages.getString("vmPreferencePage.jreType"));
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(LauncherMessages.getString("vmPreferencePage.jreName"));
        TableColumn column3 = new TableColumn(table, 0);
        column3.setText(LauncherMessages.getString("vmPreferencePage.jreLocation"));
        this.fVMList = new CheckboxTableViewer(table);
        this.fVMList.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IVMInstall && e2 instanceof IVMInstall) {
                    String rightType;
                    IVMInstall left = (IVMInstall)e1;
                    IVMInstall right = (IVMInstall)e2;
                    String leftType = left.getVMInstallType().getName();
                    int res = leftType.compareToIgnoreCase(rightType = right.getVMInstallType().getName());
                    if (res != 0) {
                        return res;
                    }
                    return left.getName().compareToIgnoreCase(right.getName());
                }
                return super.compare(viewer, e1, e2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.fVMList.setLabelProvider((IBaseLabelProvider)new VMLabelProvider());
        this.fVMList.setContentProvider((IContentProvider)new ListContentProvider((StructuredViewer)this.fVMList, Collections.EMPTY_LIST));
        this.fVMList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent evt) {
                VMPreferencePage.this.enableButtons();
            }
        });
        this.fVMList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                IVMInstall vm = (IVMInstall)event.getElement();
                if (event.getChecked()) {
                    VMPreferencePage.this.verifyDefaultVM(vm);
                }
                VMPreferencePage.this.fVMList.setCheckedElements(new Object[]{vm});
            }
        });
        this.fVMList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                VMPreferencePage.this.editVM();
            }
        });
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.fAddButton = new Button(buttons, 8);
        this.setButtonLayoutData(this.fAddButton);
        this.fAddButton.setFont(font);
        this.fAddButton.setText(LauncherMessages.getString("vmPreferencePage.add"));
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                VMPreferencePage.this.addVM();
            }
        });
        this.fEditButton = new Button(buttons, 8);
        this.setButtonLayoutData(this.fEditButton);
        this.fEditButton.setFont(font);
        this.fEditButton.setText(LauncherMessages.getString("vmPreferencePage.edit"));
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                VMPreferencePage.this.editVM();
            }
        });
        this.fRemoveButton = new Button(buttons, 8);
        this.fRemoveButton.setFont(font);
        this.setButtonLayoutData(this.fRemoveButton);
        this.fRemoveButton.setText(LauncherMessages.getString("vmPreferencePage.remove"));
        this.fRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                VMPreferencePage.this.removeVMs();
            }
        });
        this.fSearchButton = new Button(buttons, 8);
        this.fSearchButton.setFont(font);
        this.setButtonLayoutData(this.fSearchButton);
        this.fSearchButton.setText(LauncherMessages.getString("VMPreferencePage.&Search..._1"));
        this.fSearchButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                VMPreferencePage.this.search();
            }
        });
        this.configureTableResizing(parent, buttons, table, column1, column2, column3);
        this.populateVMList();
        this.enableButtons();
        WorkbenchHelp.setHelp((Control)parent, (String)IJavaDebugHelpContextIds.JRE_PREFERENCE_PAGE);
        return parent;
    }

    protected void configureTableResizing(final Composite parent, final Composite buttons, final Table table, final TableColumn column1, final TableColumn column2, final TableColumn column3) {
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = parent.getClientArea();
                Point preferredSize = table.computeSize(-1, -1);
                int width = area.width - 2 * table.getBorderWidth();
                if (preferredSize.y > area.height) {
                    Point vBarSize = table.getVerticalBar().getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = table.getSize();
                if (oldSize.x > (width -= buttons.getSize().x)) {
                    column1.setWidth(width / 4);
                    column2.setWidth(width / 4);
                    column3.setWidth(width - (column1.getWidth() + column2.getWidth()));
                    table.setSize(width, area.height);
                } else {
                    table.setSize(width, area.height);
                    column1.setWidth(width / 4);
                    column2.setWidth(width / 4);
                    column3.setWidth(width - (column1.getWidth() + column2.getWidth()));
                }
            }
        });
    }

    public boolean isDuplicateName(String name) {
        int i = 0;
        while (i < this.fVMStandins.size()) {
            IVMInstall vm = (IVMInstall)this.fVMStandins.get(i);
            if (vm.getName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void addVM() {
        AddVMDialog dialog = new AddVMDialog(this, this.getShell(), this.fVMTypes, null);
        dialog.setTitle(LauncherMessages.getString("vmPreferencePage.addJRE.title"));
        if (dialog.open() != 0) {
            return;
        }
        this.fVMList.refresh();
    }

    public void vmAdded(IVMInstall vm) {
        this.fVMStandins.add(vm);
        this.fVMList.refresh();
        if (this.getCurrentDefaultVM() == null) {
            this.verifyDefaultVM(vm);
        }
    }

    private void removeVMs() {
        IStructuredSelection selection = (IStructuredSelection)this.fVMList.getSelection();
        Iterator elements = selection.iterator();
        while (elements.hasNext()) {
            Object o = elements.next();
            this.fVMStandins.remove(o);
        }
        this.fVMList.refresh();
        if (this.getCurrentDefaultVM() == null && this.fVMList.getTable().getItemCount() > 0) {
            this.verifyDefaultVM((IVMInstall)this.fVMList.getElementAt(0));
        }
    }

    private void editVM() {
        IStructuredSelection selection = (IStructuredSelection)this.fVMList.getSelection();
        IVMInstall vm = (IVMInstall)selection.getFirstElement();
        AddVMDialog dialog = new AddVMDialog(this, this.getShell(), this.fVMTypes, vm);
        dialog.setTitle(LauncherMessages.getString("vmPreferencePage.editJRE.title"));
        if (dialog.open() != 0) {
            return;
        }
        this.fVMList.refresh((Object)vm);
    }

    private boolean isSameVM(IVMInstall left, IVMInstall right) {
        if (left == right) {
            return true;
        }
        if (left != null && right != null) {
            return left.getId().equals(right.getId());
        }
        return false;
    }

    public boolean performOk() {
        VMDefinitionsContainer vmContainer = new VMDefinitionsContainer();
        IVMInstall defaultVM = this.getCurrentDefaultVM();
        String defaultVMId = JavaRuntime.getCompositeIdFromVM((IVMInstall)defaultVM);
        vmContainer.setDefaultVMInstallCompositeID(defaultVMId);
        vmContainer.addVMList(this.fVMStandins);
        boolean buildRequired = false;
        try {
            buildRequired = this.isBuildRequired(this.fOriginalVMs, vmContainer);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        boolean build = false;
        if (buildRequired) {
            MessageDialog messageDialog = new MessageDialog(this.getShell(), LauncherMessages.getString("VMPreferencePage.JRE_Settings_Changed_1"), null, LauncherMessages.getString("VMPreferencePage.The_JRE_settings_have_changed._A_full_build_is_required_to_make_the_changes_effective._Do_the_full_build_now__2"), 3, new String[]{LauncherMessages.getString("VMPreferencePage.&Yes_3"), LauncherMessages.getString("VMPreferencePage.&No_4"), LauncherMessages.getString("VMPreferencePage.&Cancel_1")}, 0);
            int button = messageDialog.open();
            if (button == 2) {
                return false;
            }
            build = button == 0;
        }
        this.saveVMDefinitions(vmContainer);
        if (build) {
            this.buildWorkspace();
        }
        return super.performOk();
    }

    private void saveVMDefinitions(final VMDefinitionsContainer container) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    String vmDefXML = container.getAsXML();
                    JavaRuntime.getPreferences().setValue(JavaRuntime.PREF_VM_XML, vmDefXML);
                    JavaRuntime.savePreferences();
                }
                catch (IOException ioe) {
                    JDIDebugUIPlugin.log(ioe);
                }
            }
        });
    }

    protected IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
    }

    private void buildWorkspace() {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        try {
            dialog.run(true, true, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        ResourcesPlugin.getWorkspace().build(6, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), LauncherMessages.getString("VMPreferencePage.Installed_JREs_1"), LauncherMessages.getString("VMPreferencePage.Build_failed._1"));
        }
    }

    private IVMInstall getCurrentDefaultVM() {
        Object[] checked = this.fVMList.getCheckedElements();
        if (checked.length > 0) {
            return (IVMInstall)checked[0];
        }
        return null;
    }

    private void enableButtons() {
        this.fAddButton.setEnabled(this.fVMTypes.length > 0);
        int selectionCount = ((IStructuredSelection)this.fVMList.getSelection()).size();
        this.fEditButton.setEnabled(selectionCount == 1);
        this.fRemoveButton.setEnabled(selectionCount > 0 && selectionCount < this.fVMList.getTable().getItemCount());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void verifyDefaultVM(IVMInstall vm) {
        if (vm == null) {
            this.fVMList.setCheckedElements(new Object[0]);
            return;
        }
        LibraryLocation[] locations = JavaRuntime.getLibraryLocations((IVMInstall)vm);
        boolean exist = true;
        int i = 0;
        while (i < locations.length) {
            exist = exist && new File(locations[i].getSystemLibraryPath().toOSString()).exists();
            ++i;
        }
        if (exist) {
            this.fVMList.setCheckedElements(new Object[]{vm});
            return;
        }
        this.fVMList.remove((Object)vm);
        this.fVMStandins.remove(vm);
        IVMInstall def = JavaRuntime.getDefaultVMInstall();
        if (def == null) {
            this.fVMList.setCheckedElements(new Object[0]);
        } else {
            this.fVMList.setChecked((Object)def, true);
        }
        ErrorDialog.openError((Shell)this.getControl().getShell(), (String)LauncherMessages.getString("VMPreferencePage.Installed_JREs_1"), (String)LauncherMessages.getString("VMPreferencePage.Installed_JRE_location_no_longer_exists.__JRE_will_be_removed_2"), (IStatus)new Status(4, IJavaDebugUIConstants.PLUGIN_ID, 150, LauncherMessages.getString("VMPreferencePage.JRE_removed_3"), null));
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setTitle(LauncherMessages.getString("vmPreferencePage.title"));
        }
    }

    public void search() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setMessage(LauncherMessages.getString("VMPreferencePage.Select_a_directory_to_search_in._2"));
        dialog.setText(LauncherMessages.getString("VMPreferencePage.Directory_Selection_3"));
        String path = dialog.open();
        if (path == null) {
            return;
        }
        final HashSet<File> exstingLocations = new HashSet<File>();
        Iterator iter = this.fVMStandins.iterator();
        while (iter.hasNext()) {
            exstingLocations.add(((IVMInstall)iter.next()).getInstallLocation());
        }
        final File rootDir = new File(path);
        final ArrayList locations = new ArrayList();
        final ArrayList types = new ArrayList();
        ProgressMonitorDialog pm = new ProgressMonitorDialog(this.getShell());
        IRunnableWithProgress r = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(LauncherMessages.getString("VMPreferencePage.Searching..._4"), -1);
                VMPreferencePage.this.search(rootDir, locations, types, exstingLocations, monitor);
                monitor.done();
            }
        };
        try {
            pm.run(true, true, r);
        }
        catch (InvocationTargetException e) {
            JDIDebugUIPlugin.log(e);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        if (locations.isEmpty()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)LauncherMessages.getString("VMPreferencePage.Information_1"), (String)MessageFormat.format(LauncherMessages.getString("VMPreferencePage.No_JREs_found_in_{0}_2"), path));
        } else {
            iter = locations.iterator();
            Iterator iter2 = types.iterator();
            while (iter.hasNext()) {
                File location = (File)iter.next();
                IVMInstallType type = (IVMInstallType)iter2.next();
                VMStandin vm = new VMStandin(type, this.createUniqueId(type));
                String name = location.getName();
                String nameCopy = new String(name);
                int i = 1;
                while (this.isDuplicateName(nameCopy)) {
                    nameCopy = String.valueOf(name) + '(' + i++ + ')';
                }
                vm.setName(nameCopy);
                vm.setInstallLocation(location);
                if (type instanceof AbstractVMInstallType) {
                    AbstractVMInstallType abs = (AbstractVMInstallType)type;
                    vm.setJavadocLocation(abs.getDefaultJavadocLocation(location));
                }
                this.vmAdded((IVMInstall)vm);
            }
        }
    }

    private String createUniqueId(IVMInstallType vmType) {
        String id = null;
        while (vmType.findVMInstall(id = String.valueOf(System.currentTimeMillis())) != null || id.equals(fgLastUsedID)) {
        }
        fgLastUsedID = id;
        return id;
    }

    protected void search(File directory, List found, List types, Set ignore, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        String[] names = directory.list();
        ArrayList<File> subDirs = new ArrayList<File>();
        int i = 0;
        while (i < names.length) {
            if (monitor.isCanceled()) {
                return;
            }
            File file = new File(directory, names[i]);
            try {
                monitor.subTask(MessageFormat.format(LauncherMessages.getString("VMPreferencePage.Found__{0}_-_Searching_{1}_7"), Integer.toString(found.size()), file.getCanonicalPath()));
            }
            catch (IOException iOException) {}
            if (file.isDirectory() && !ignore.contains(file)) {
                boolean validLocation = false;
                int j = 0;
                while (j < this.fVMTypes.length) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    IVMInstallType type = this.fVMTypes[j];
                    IStatus status = type.validateInstallLocation(file);
                    if (status.isOK()) {
                        found.add(file);
                        types.add(type);
                        validLocation = true;
                        break;
                    }
                    ++j;
                }
                if (!validLocation) {
                    subDirs.add(file);
                }
            }
            ++i;
        }
        while (!subDirs.isEmpty()) {
            File subDir = (File)subDirs.remove(0);
            this.search(subDir, found, types, ignore, monitor);
            if (!monitor.isCanceled()) continue;
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isBuildRequired(VMDefinitionsContainer prev, VMDefinitionsContainer curr) throws CoreException {
        String currDef;
        String prevDef = prev.getDefaultVMInstallCompositeID();
        boolean defaultChanged = !this.isEqual(prevDef, currDef = curr.getDefaultVMInstallCompositeID());
        IJavaProject[] projects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
        if (defaultChanged) {
            int i = 0;
            while (i < projects.length) {
                IJavaProject project = projects[i];
                IClasspathEntry[] entries = project.getRawClasspath();
                int j = 0;
                while (j < entries.length) {
                    IClasspathEntry entry = entries[j];
                    switch (entry.getEntryKind()) {
                        case 4: {
                            IPath path = entry.getPath();
                            if (path.segmentCount() != 1 || !path.segment(0).equals("JRE_LIB")) break;
                            return true;
                        }
                        case 5: {
                            IPath path = entry.getPath();
                            if (path.segmentCount() != 1 || !path.segment(0).equals(JavaRuntime.JRE_CONTAINER)) break;
                            return true;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        List futureVMs = curr.getVMList();
        int i = 0;
        while (i < projects.length) {
            IJavaProject project = projects[i];
            IVMInstall prevVM = JavaRuntime.getVMInstall((IJavaProject)project);
            if (prevVM != null) {
                LibraryLocation[] newLibs;
                int index = futureVMs.indexOf(prevVM);
                if (index < 0) return true;
                IVMInstall futureVM = (IVMInstall)futureVMs.get(index);
                LibraryLocation[] prevLibs = JavaRuntime.getLibraryLocations((IVMInstall)prevVM);
                if (prevLibs.length != (newLibs = JavaRuntime.getLibraryLocations((IVMInstall)futureVM)).length) return true;
                int j = 0;
                while (j < newLibs.length) {
                    String prevPath;
                    LibraryLocation newLib = newLibs[j];
                    LibraryLocation prevLib = prevLibs[j];
                    String newPath = newLib.getSystemLibraryPath().toOSString();
                    if (!newPath.equalsIgnoreCase(prevPath = prevLib.getSystemLibraryPath().toOSString())) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean isEqual(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }
}

