/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class StandardVMCommandTab
extends AbstractLaunchConfigurationTab {
    protected Text fJavaCommandText;
    protected Button fDefaultButton;
    protected static final Map EMPTY_MAP = new HashMap(1);

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        topLayout.marginWidth = 0;
        topLayout.marginHeight = 0;
        GridData gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        comp.setFont(font);
        this.createVerticalSpacer(comp, 2);
        Label javaCommandLabel = new Label(comp, 0);
        javaCommandLabel.setText(LauncherMessages.getString("AbstractJavaCommandTab.Name_of_Java_e&xecutable__1"));
        javaCommandLabel.setFont(font);
        this.fJavaCommandText = new Text(comp, 2052);
        gd = new GridData(768);
        this.fJavaCommandText.setLayoutData((Object)gd);
        this.fJavaCommandText.setFont(font);
        this.fJavaCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                StandardVMCommandTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fDefaultButton = new Button(comp, 32);
        this.fDefaultButton.setText(LauncherMessages.getString("AbstractJavaCommandTab.Use_de&fault_Java_executable_2"));
        gd = new GridData(32);
        gd.horizontalSpan = 2;
        this.fDefaultButton.setLayoutData((Object)gd);
        this.fDefaultButton.setFont(font);
        this.fDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                StandardVMCommandTab.this.handleDefaultButtonSelected(StandardVMCommandTab.this.fDefaultButton.getSelection());
            }
        });
        this.setControl((Control)comp);
    }

    protected void handleDefaultButtonSelected(boolean useDefault) {
        if (useDefault) {
            this.fJavaCommandText.setText(this.getDefaultCommand());
        }
        this.fJavaCommandText.setEnabled(!useDefault);
    }

    protected String getDefaultCommand() {
        return "javaw";
    }

    public String getName() {
        return LauncherMessages.getString("AbstractJavaCommandTab.Standard_VM_Java_Command_3");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        String javaCommand = null;
        try {
            Map attributeMap = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE_SPECIFIC_ATTRS_MAP, null);
            if (attributeMap != null) {
                javaCommand = (String)attributeMap.get(IJavaLaunchConfigurationConstants.ATTR_JAVA_COMMAND);
            }
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
        if (javaCommand == null) {
            javaCommand = this.getDefaultCommand();
        }
        this.fJavaCommandText.setText(javaCommand);
        if (javaCommand.equals(this.getDefaultCommand())) {
            this.fDefaultButton.setSelection(true);
            this.handleDefaultButtonSelected(true);
        } else {
            this.fDefaultButton.setSelection(false);
            this.handleDefaultButtonSelected(false);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fDefaultButton.getSelection()) {
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE_SPECIFIC_ATTRS_MAP, null);
        } else {
            String javaCommand = this.fJavaCommandText.getText();
            HashMap<String, String> attributeMap = new HashMap<String, String>(1);
            attributeMap.put(IJavaLaunchConfigurationConstants.ATTR_JAVA_COMMAND, javaCommand);
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE_SPECIFIC_ATTRS_MAP, attributeMap);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE_SPECIFIC_ATTRS_MAP, null);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean valid;
        boolean bl = valid = this.fJavaCommandText.getText().length() != 0;
        if (valid) {
            this.setErrorMessage(null);
            this.setMessage(null);
        } else {
            this.setErrorMessage(LauncherMessages.getString("AbstractJavaCommandTab.Java_executable_must_be_specified_5"));
            this.setMessage(null);
        }
        return valid;
    }
}

