/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import java.io.File;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.sourcelookup.LocalFileStorage;
import org.eclipse.jdt.launching.sourcelookup.ZipEntryStorage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class SourceElementQualifierProvider
extends LabelProvider
implements ILabelProvider {
    public String getText(Object element) {
        if (element instanceof IJavaElement) {
            IJavaProject project = ((IJavaElement)element).getJavaProject();
            return project.getElementName();
        }
        if (element instanceof ZipEntryStorage) {
            ZipEntryStorage storage = (ZipEntryStorage)element;
            ZipFile zipFile = storage.getArchive();
            Path path = new Path(zipFile.getName());
            IRuntimeClasspathEntry entry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path);
            IResource res = entry.getResource();
            if (res == null) {
                return zipFile.getName();
            }
            return res.getName();
        }
        if (element instanceof LocalFileStorage) {
            LocalFileStorage storage = (LocalFileStorage)element;
            File extFile = storage.getFile();
            Path path = new Path(extFile.getAbsolutePath());
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            if (file == null) {
                return extFile.getParent();
            }
            return file.getProject().getName();
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof IJavaElement) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
        }
        if (element instanceof ZipEntryStorage) {
            return JavaPluginImages.get((String)"org.eclipse.jdt.ui.jar_src_obj.gif");
        }
        if (element instanceof LocalFileStorage) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        return super.getImage(element);
    }
}

