/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.internal.debug.ui.launcher.IEntriesChangedListener;
import org.eclipse.jdt.internal.debug.ui.launcher.RuntimeClasspathEntryLabelProvider;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;

public class RuntimeClasspathViewer
extends TableViewer {
    private boolean fEnabled = true;
    private ListenerList fListeners = new ListenerList(3);
    private ILaunchConfiguration fLaunchConfiguration;
    protected List fEntries = new ArrayList();

    public RuntimeClasspathViewer(Composite parent) {
        super(parent);
        this.setContentProvider((IContentProvider)new ContentProvider());
        RuntimeClasspathEntryLabelProvider lp = new RuntimeClasspathEntryLabelProvider();
        lp.setLaunchConfiguration(this.fLaunchConfiguration);
        this.setLabelProvider((IBaseLabelProvider)lp);
        this.setInput(this.fEntries);
    }

    public void setEntries(IRuntimeClasspathEntry[] entries) {
        this.fEntries.clear();
        int i = 0;
        while (i < entries.length) {
            this.fEntries.add(entries[i]);
            ++i;
        }
        this.setInput(this.fEntries);
        this.notifyChanged();
    }

    public IRuntimeClasspathEntry[] getEntries() {
        return this.fEntries.toArray(new IRuntimeClasspathEntry[this.fEntries.size()]);
    }

    public void addEntries(IRuntimeClasspathEntry[] entries) {
        IStructuredSelection sel = (IStructuredSelection)this.getSelection();
        if (sel.isEmpty()) {
            int i = 0;
            while (i < entries.length) {
                if (!this.fEntries.contains(entries[i])) {
                    this.fEntries.add(entries[i]);
                }
                ++i;
            }
        } else {
            int index = this.fEntries.indexOf(sel.getFirstElement());
            int i = 0;
            while (i < entries.length) {
                if (!this.fEntries.contains(entries[i])) {
                    this.fEntries.add(index, entries[i]);
                    ++index;
                }
                ++i;
            }
        }
        this.setSelection((ISelection)new StructuredSelection((Object[])entries));
        this.refresh();
        this.notifyChanged();
    }

    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
        this.setSelection(this.getSelection());
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public void setLaunchConfiguration(ILaunchConfiguration configuration) {
        this.fLaunchConfiguration = configuration;
        if (this.getLabelProvider() != null) {
            ((RuntimeClasspathEntryLabelProvider)this.getLabelProvider()).setLaunchConfiguration(configuration);
        }
    }

    public void addEntriesChangedListener(IEntriesChangedListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeEntriesChangedListener(IEntriesChangedListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public void notifyChanged() {
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IEntriesChangedListener)listeners[i]).entriesChanged(this);
            ++i;
        }
    }

    public int indexOf(IRuntimeClasspathEntry entry) {
        return this.fEntries.indexOf(entry);
    }

    class ContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return RuntimeClasspathViewer.this.getEntries();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

