/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.ui.util.MainMethodSearchEngine;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class MainMethodFinder {
    static /* synthetic */ Class class$0;

    private MainMethodFinder() {
    }

    public static IType[] findTargets(IRunnableContext context, final Object[] elements) throws InvocationTargetException, InterruptedException {
        final HashSet result = new HashSet();
        if (elements.length > 0) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InterruptedException {
                    int nElements = elements.length;
                    pm.beginTask(LauncherMessages.getString("MainMethodFinder.description"), nElements);
                    try {
                        int i = 0;
                        while (i < nElements) {
                            try {
                                MainMethodFinder.collectTypes(elements[i], (IProgressMonitor)new SubProgressMonitor(pm, 1), result);
                            }
                            catch (JavaModelException e) {
                                JDIDebugUIPlugin.log(e);
                            }
                            if (pm.isCanceled()) {
                                throw new InterruptedException();
                            }
                            ++i;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        pm.done();
                        throw throwable;
                    }
                    Object var5_7 = null;
                    pm.done();
                }
            };
            context.run(true, true, runnable);
        }
        return result.toArray(new IType[result.size()]);
    }

    private static void collectTypes(Object element, IProgressMonitor monitor, Set result) throws JavaModelException {
        if (element instanceof IProcess) {
            element = ((IProcess)element).getLaunch();
        } else if (element instanceof IDebugTarget) {
            element = ((IDebugTarget)element).getLaunch();
        }
        if (element instanceof IAdaptable) {
            IJavaElement jelem;
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((jelem = (IJavaElement)iAdaptable.getAdapter((Class)clazz)) != null) {
                IType parentType = (IType)jelem.getAncestor(7);
                if (parentType != null && JavaModelUtil.hasMainMethod((IType)parentType)) {
                    result.add(parentType);
                    monitor.done();
                    return;
                }
                IJavaElement openable = (IJavaElement)jelem.getOpenable();
                if (openable != null) {
                    if (openable.getElementType() == 5) {
                        ICompilationUnit cu = (ICompilationUnit)openable;
                        IType mainType = cu.getType(Signature.getQualifier((String)cu.getElementName()));
                        if (mainType.exists() && JavaModelUtil.hasMainMethod((IType)mainType)) {
                            result.add(mainType);
                        }
                        monitor.done();
                        return;
                    }
                    if (openable.getElementType() == 6) {
                        IType mainType = ((IClassFile)openable).getType();
                        if (JavaModelUtil.hasMainMethod((IType)mainType)) {
                            result.add(mainType);
                        }
                        monitor.done();
                        return;
                    }
                }
                IType[] types = MainMethodFinder.searchMainMethods(jelem, monitor);
                int i = 0;
                while (i < types.length) {
                    result.add(types[i]);
                    ++i;
                }
            }
        }
    }

    private static IType[] searchMainMethods(IJavaElement elem, IProgressMonitor monitor) throws JavaModelException {
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{elem});
        MainMethodSearchEngine searchEngine = new MainMethodSearchEngine();
        return searchEngine.searchMainMethods(monitor, scope, 8);
    }
}

