/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.ui.JavaUISourceLocator;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.debug.ui.launcher.MainMethodFinder;
import org.eclipse.jdt.internal.debug.ui.launcher.MainTypeSelectionDialog;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class JavaApplicationLaunchShortcut
implements ILaunchShortcut {
    static /* synthetic */ Class class$0;

    public void searchAndLaunch(Object[] search, String mode, boolean editor) {
        IType[] types = null;
        if (search != null) {
            try {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
                types = MainMethodFinder.findTargets((IRunnableContext)dialog, search);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)LauncherMessages.getString("JavaApplicationAction.Launch_failed_7"), (String)e.getMessage());
                return;
            }
            IType type = null;
            if (types.length == 0) {
                String message = null;
                message = editor ? LauncherMessages.getString("JavaApplicationLaunchShortcut.The_active_editor_does_not_contain_a_main_type._1") : LauncherMessages.getString("JavaApplicationLaunchShortcut.The_selection_does_not_contain_a_main_type._2");
                MessageDialog.openError((Shell)this.getShell(), (String)LauncherMessages.getString("JavaApplicationAction.Launch_failed_7"), (String)message);
            } else {
                type = types.length > 1 ? this.chooseType(types, mode) : types[0];
            }
            if (type != null) {
                this.launch(type, mode);
            }
        }
    }

    protected IType chooseType(IType[] types, String mode) {
        MainTypeSelectionDialog dialog = new MainTypeSelectionDialog(this.getShell(), types);
        if (mode.equals("debug")) {
            dialog.setTitle(LauncherMessages.getString("JavaApplicationAction.Type_Selection_Debug"));
        } else {
            dialog.setTitle(LauncherMessages.getString("JavaApplicationAction.Type_Selection_Run"));
        }
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    protected void launch(IType type, String mode) {
        ILaunchConfiguration config = this.findLaunchConfiguration(type, mode);
        if (config != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    protected ILaunchConfiguration findLaunchConfiguration(IType type, String mode) {
        ILaunchConfigurationType configType = this.getJavaLaunchConfigType();
        ArrayList<ILaunchConfiguration> candidateConfigs = Collections.EMPTY_LIST;
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                if (config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "").equals(type.getFullyQualifiedName()) && config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(type.getJavaProject().getElementName())) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount < 1) {
            return this.createConfiguration(type);
        }
        if (candidateCount == 1) {
            return (ILaunchConfiguration)candidateConfigs.get(0);
        }
        ILaunchConfiguration config = this.chooseConfiguration(candidateConfigs, mode);
        if (config != null) {
            return config;
        }
        return null;
    }

    protected ILaunchConfiguration chooseConfiguration(List configList, String mode) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(LauncherMessages.getString("JavaApplicationAction.Launch_Configuration_Selection_1"));
        if (mode.equals("debug")) {
            dialog.setMessage(LauncherMessages.getString("JavaApplicationAction.Choose_a_launch_configuration_to_debug_2"));
        } else {
            dialog.setMessage(LauncherMessages.getString("JavaApplicationAction.Choose_a_launch_configuration_to_run_3"));
        }
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected ILaunchConfiguration createConfiguration(IType type) {
        ILaunchConfiguration config = null;
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            ILaunchConfigurationType configType = this.getJavaLaunchConfigType();
            wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(type.getElementName()));
        }
        catch (CoreException exception) {
            this.reportCreatingConfiguration(exception);
            return null;
        }
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, type.getFullyQualifiedName());
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, type.getJavaProject().getElementName());
        wc.setAttribute(IDebugUIConstants.ATTR_TARGET_DEBUG_PERSPECTIVE, "perspective_default");
        wc.setAttribute(IDebugUIConstants.ATTR_TARGET_RUN_PERSPECTIVE, "perspective_default");
        wc.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, JavaUISourceLocator.ID_PROMPTING_JAVA_SOURCE_LOCATOR);
        try {
            config = wc.doSave();
        }
        catch (CoreException exception) {
            this.reportCreatingConfiguration(exception);
        }
        return config;
    }

    protected void reportCreatingConfiguration(final CoreException exception) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError((Shell)JavaApplicationLaunchShortcut.this.getShell(), (String)LauncherMessages.getString("JavaApplicationLaunchShortcut.Error_Launching_1"), (String)LauncherMessages.getString("JavaApplicationLaunchShortcut.Exception"), (IStatus)exception.getStatus());
            }
        });
    }

    protected ILaunchConfigurationType getJavaLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected Shell getShell() {
        return JDIDebugUIPlugin.getActiveWorkbenchShell();
    }

    public void launch(IEditorPart editor, String mode) {
        IJavaElement je;
        IEditorInput input = editor.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((je = (IJavaElement)input.getAdapter((Class)clazz)) != null) {
            this.searchAndLaunch(new Object[]{je}, mode, true);
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)LauncherMessages.getString("JavaApplicationAction.Launch_failed_7"), (String)LauncherMessages.getString("JavaApplicationLaunchShortcut.The_active_editor_does_not_contain_a_main_type._1"));
        }
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.searchAndLaunch(((IStructuredSelection)selection).toArray(), mode, false);
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)LauncherMessages.getString("JavaApplicationAction.Launch_failed_7"), (String)LauncherMessages.getString("JavaApplicationLaunchShortcut.The_selection_does_not_contain_a_main_type._2"));
        }
    }
}

