/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.ui.JavaUISourceLocator;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.AppletLaunchConfigurationUtils;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class JavaAppletLaunchShortcut
implements ILaunchShortcut {
    private static final String EMPTY_STRING = "";
    static /* synthetic */ Class class$0;

    protected void searchAndLaunch(Object[] search, String mode) {
        IType[] types = null;
        if (search != null) {
            try {
                types = AppletLaunchConfigurationUtils.findApplets((IRunnableContext)new ProgressMonitorDialog(this.getShell()), search);
            }
            catch (InterruptedException e) {
                JDIDebugUIPlugin.log(e);
                return;
            }
            catch (InvocationTargetException e) {
                JDIDebugUIPlugin.log(e);
                return;
            }
            IType type = null;
            if (types.length == 0) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)LauncherMessages.getString("appletlauncher.search.dialog.title"), (String)LauncherMessages.getString("appletlauncher.search.dialog.error.noapplets"));
            } else {
                type = types.length > 1 ? this.chooseType(types, mode) : types[0];
            }
            if (type != null) {
                this.launch(type, mode);
            }
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IJavaElement javaElement;
        IEditorInput input = editor.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((javaElement = (IJavaElement)input.getAdapter((Class)clazz)) != null) {
            this.searchAndLaunch(new Object[]{javaElement}, mode);
        }
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.searchAndLaunch(((IStructuredSelection)selection).toArray(), mode);
        }
    }

    protected IType chooseType(IType[] types, String mode) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider());
        dialog.setElements((Object[])types);
        dialog.setTitle(LauncherMessages.getString("appletlauncher.selection.type.dialog.title"));
        if (mode.equals("debug")) {
            dialog.setMessage(LauncherMessages.getString("appletlauncher.selection.type.dialog.message.debug"));
        } else {
            dialog.setMessage(LauncherMessages.getString("appletlauncher.selection.type.dialog.message.run"));
        }
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    protected void launch(IType type, String mode) {
        try {
            ILaunchConfiguration config = this.findLaunchConfiguration(type, mode);
            if (config != null) {
                config.launch(mode, null);
            }
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)LauncherMessages.getString("appletlauncher.launching.error.failure"), (String)e.getMessage(), (IStatus)e.getStatus());
        }
    }

    protected ILaunchConfiguration findLaunchConfiguration(IType type, String mode) {
        ILaunchConfigurationType configType = this.getAppletLaunchConfigType();
        ArrayList<ILaunchConfiguration> candidateConfigs = Collections.EMPTY_LIST;
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                if (config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, EMPTY_STRING).equals(type.getFullyQualifiedName()) && config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, EMPTY_STRING).equals(type.getJavaProject().getElementName())) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount < 1) {
            return this.createConfiguration(type);
        }
        if (candidateCount == 1) {
            return (ILaunchConfiguration)candidateConfigs.get(0);
        }
        ILaunchConfiguration config = this.chooseConfiguration(candidateConfigs, mode);
        if (config != null) {
            return config;
        }
        return null;
    }

    protected ILaunchConfiguration createConfiguration(IType type) {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationType configType = this.getAppletLaunchConfigType();
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(type.getElementName()));
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, type.getFullyQualifiedName());
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, type.getJavaProject().getElementName());
            wc.setAttribute(IDebugUIConstants.ATTR_TARGET_DEBUG_PERSPECTIVE, "perspective_default");
            wc.setAttribute(IDebugUIConstants.ATTR_TARGET_RUN_PERSPECTIVE, "perspective_default");
            wc.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, JavaUISourceLocator.ID_PROMPTING_JAVA_SOURCE_LOCATOR);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_WIDTH, 200);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_HEIGHT, 200);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_NAME, EMPTY_STRING);
            config = wc.doSave();
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
        return config;
    }

    protected ILaunchConfiguration chooseConfiguration(List configList, String mode) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(LauncherMessages.getString("appletlauncher.selection.configuration.dialog.title"));
        if (mode.equals("debug")) {
            dialog.setMessage(LauncherMessages.getString("appletlauncher.selection.configuration.dialog.message.debug"));
        } else {
            dialog.setMessage(LauncherMessages.getString("appletlauncher.selection.configuration.dialog.message.run"));
        }
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected ILaunchConfigurationType getAppletLaunchConfigType() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        return lm.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLET);
    }

    protected Shell getShell() {
        return JDIDebugUIPlugin.getActiveWorkbenchShell();
    }

    protected IStructuredSelection resolveSelection(IWorkbenchWindow window) {
        if (window == null) {
            return null;
        }
        ISelection selection = window.getSelectionService().getSelection();
        if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            selection = null;
            IWorkbenchPage page = window.getActivePage();
            if (page == null) {
                return null;
            }
            IEditorPart editor = page.getActiveEditor();
            IEditorInput element = null;
            if (editor != null) {
                element = editor.getEditorInput();
            }
            if (selection == null && element != null) {
                selection = new StructuredSelection((Object)element);
            }
        }
        return (IStructuredSelection)selection;
    }
}

