/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaJRETab;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaDebugImages;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class JREContainerWizardPage
extends WizardPage
implements IClasspathContainerPage {
    private IClasspathEntry fSelection;
    private JavaJRETab fJRETab;
    private ILaunchConfigurationWorkingCopy fConfig;
    private Image fImage;

    public JREContainerWizardPage() {
        super(LauncherMessages.getString("JREContainerWizardPage.JRE_System_Library_1"));
    }

    public boolean finish() {
        this.fJRETab.performApply(this.fConfig);
        String typeId = null;
        String name = null;
        try {
            typeId = this.fConfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, null);
            name = this.fConfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, null);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.errorDialog(LauncherMessages.getString("JREContainerWizardPage.Unable_to_set_JRE_for_project._2"), e);
            return false;
        }
        Path path = new Path(JavaRuntime.JRE_CONTAINER);
        if (typeId != null) {
            path = path.append(typeId);
            path = path.append(name);
        }
        this.fSelection = JavaCore.newContainerEntry((IPath)path);
        return true;
    }

    public IClasspathEntry getSelection() {
        return this.fSelection;
    }

    public void setSelection(IClasspathEntry containerEntry) {
        this.fSelection = containerEntry;
        this.initializeFromSelection();
    }

    protected void initializeFromSelection() {
        if (this.getControl() != null) {
            IPath path;
            String typeId = null;
            String name = null;
            if (this.fSelection != null && (path = this.fSelection.getPath()).segmentCount() > 1) {
                typeId = path.segment(1);
                name = path.segment(2);
            }
            this.fConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, typeId);
            this.fConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, name);
            this.fJRETab.initializeFrom((ILaunchConfiguration)this.fConfig);
        }
    }

    public void createControl(Composite parent) {
        this.fJRETab = new JavaJRETab();
        this.fJRETab.setVMSpecificArgumentsVisible(false);
        this.fJRETab.createControl(parent);
        this.setControl(this.fJRETab.getControl());
        this.setTitle(LauncherMessages.getString("JREContainerWizardPage.JRE_System_Library_1"));
        this.setMessage(LauncherMessages.getString("JREContainerWizardPage.Select_the_JRE_used_to_build_this_project._4"));
        ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        try {
            this.fConfig = type.newInstance(null, "TEMP_CONFIG");
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.errorDialog(LauncherMessages.getString("JREContainerWizardPage.Unable_to_retrieve_existing_JREs_6"), e);
            return;
        }
        this.initializeFromSelection();
    }

    public Image getImage() {
        if (this.fImage == null) {
            this.fImage = JavaDebugImages.DESC_WIZBAN_LIBRARY.createImage();
        }
        return this.fImage;
    }

    public void dispose() {
        super.dispose();
        if (this.fImage != null) {
            this.fImage.dispose();
        }
    }
}

