/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IFileEditorInput;

public class AppletLaunchConfigurationUtils {
    public static void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), code, message, exception));
    }

    public static IType getMainType(String mainTypeName, IJavaProject javaProject) throws CoreException {
        if (mainTypeName == null || mainTypeName.trim().length() < 1) {
            AppletLaunchConfigurationUtils.abort(LauncherMessages.getString("appletlauncher.utils.error.main_type_not_specified"), null, 101);
        }
        IType mainType = null;
        try {
            mainType = AppletLaunchConfigurationUtils.findType(javaProject, mainTypeName);
        }
        catch (JavaModelException javaModelException) {}
        if (mainType == null) {
            AppletLaunchConfigurationUtils.abort(LauncherMessages.getString("appletlauncher.utils.error.main_type_does_not_exist"), null, 101);
        }
        return mainType;
    }

    public static IType findType(IJavaProject javaProject, String mainTypeName) throws JavaModelException {
        String pathStr = String.valueOf(mainTypeName.replace('.', '/')) + ".java";
        IJavaElement javaElement = javaProject.findElement((IPath)new Path(pathStr));
        if (javaElement == null) {
            return null;
        }
        if (javaElement instanceof IType) {
            return (IType)javaElement;
        }
        if (javaElement.getElementType() == 5) {
            String simpleName = Signature.getSimpleName((String)mainTypeName);
            return ((ICompilationUnit)javaElement).getType(simpleName);
        }
        if (javaElement.getElementType() == 6) {
            return ((IClassFile)javaElement).getType();
        }
        return null;
    }

    public static Set collectAppletTypesInProject(IProgressMonitor monitor, IJavaProject project) {
        HashSet<IType> result = null;
        try {
            IType javaLangApplet = AppletLaunchConfigurationUtils.getMainType("java.applet.Applet", project);
            ITypeHierarchy hierarchy = javaLangApplet.newTypeHierarchy(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IType[] types = hierarchy.getAllSubtypes(javaLangApplet);
            int length = types.length;
            if (length != 0) {
                result = new HashSet<IType>(length);
                int i = 0;
                while (i < length) {
                    if (!types[i].isBinary()) {
                        result.add(types[i]);
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (CoreException coreException) {}
        monitor.done();
        return result;
    }

    private static void collectTypes(Object element, IProgressMonitor monitor, Set result) throws JavaModelException {
        element = AppletLaunchConfigurationUtils.computeScope(element);
        while (element instanceof IJavaElement && !(element instanceof ICompilationUnit) && element instanceof ISourceReference) {
            if (element instanceof IType && AppletLaunchConfigurationUtils.isSubclassOfApplet(monitor, (IType)element)) {
                result.add(element);
                monitor.done();
                return;
            }
            element = ((IJavaElement)element).getParent();
        }
        if (element instanceof ICompilationUnit) {
            ICompilationUnit cu = (ICompilationUnit)element;
            IType[] types = cu.getAllTypes();
            int i = 0;
            while (i < types.length) {
                if (AppletLaunchConfigurationUtils.isSubclassOfApplet(monitor, types[i])) {
                    result.add(types[i]);
                }
                ++i;
            }
            monitor.done();
            return;
        }
        if (element instanceof IJavaElement) {
            List found = AppletLaunchConfigurationUtils.searchSubclassesOfApplet(monitor, (IJavaElement)element);
            result.addAll(found);
            monitor.done();
        }
    }

    private static List searchSubclassesOfApplet(IProgressMonitor pm, IJavaElement javaElement) throws JavaModelException {
        return new ArrayList(AppletLaunchConfigurationUtils.collectAppletTypesInProject(pm, javaElement.getJavaProject()));
    }

    private static boolean isSubclassOfApplet(IProgressMonitor pm, IType type) {
        return AppletLaunchConfigurationUtils.collectAppletTypesInProject(pm, type.getJavaProject()).contains(type);
    }

    private static Object computeScope(Object element) throws JavaModelException {
        if (element instanceof IFileEditorInput) {
            element = ((IFileEditorInput)element).getFile();
        }
        if (element instanceof IResource) {
            element = JavaCore.create((IResource)((IResource)element));
        }
        return element;
    }

    public static IType[] findApplets(IRunnableContext context, final Object[] elements) throws InvocationTargetException, InterruptedException {
        final HashSet result = new HashSet();
        if (elements.length > 0) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InterruptedException {
                    int nElements = elements.length;
                    pm.beginTask(LauncherMessages.getString("appletlauncher.search.task.inprogress"), nElements);
                    try {
                        int i = 0;
                        while (i < nElements) {
                            try {
                                AppletLaunchConfigurationUtils.collectTypes(elements[i], (IProgressMonitor)new SubProgressMonitor(pm, 1), result);
                            }
                            catch (JavaModelException jme) {
                                JDIDebugUIPlugin.log(jme.getStatus());
                            }
                            if (pm.isCanceled()) {
                                throw new InterruptedException();
                            }
                            ++i;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        pm.done();
                        throw throwable;
                    }
                    Object var5_7 = null;
                    pm.done();
                }
            };
            context.run(true, true, runnable);
        }
        return result.toArray(new IType[result.size()]);
    }
}

